/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.render;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.tree.TreeNode;
import org.sbml.jsbml.AbstractNamedSBase;
import org.sbml.jsbml.PropertyUndefinedError;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.UniqueNamedSBase;
import org.sbml.jsbml.ext.render.RenderGroup;
import org.sbml.jsbml.ext.render.XMLTools;

public class Style
extends AbstractNamedSBase
implements UniqueNamedSBase {
    private static final long serialVersionUID = -4660813321564690910L;
    protected RenderGroup group;
    protected List<String> roleList;
    protected List<Type> typeList;

    public Style() {
        this.initDefaults();
    }

    public Style(RenderGroup group) {
        this.setGroup(group);
        this.initDefaults();
    }

    public Style(int level, int version, RenderGroup group) {
        this(null, level, version, group);
    }

    public Style(String id, int level, int version, RenderGroup group) {
        super(id, level, version);
        this.initDefaults();
        this.setGroup(group);
    }

    public Style(Style obj) {
        super((AbstractNamedSBase)obj);
        if (obj.isSetRoleList()) {
            this.setRoleList(new ArrayList<String>(obj.roleList));
        }
        if (obj.isSetTypeList()) {
            this.setTypeList(new ArrayList<Type>(obj.typeList));
        }
        if (obj.isSetGroup()) {
            this.setGroup(obj.getGroup().clone());
        }
    }

    public Style clone() {
        return new Style(this);
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public TreeNode getChildAt(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException(MessageFormat.format(resourceBundle.getString("IndexSurpassesBoundsException"), index, 0));
        }
        int count = super.getChildCount();
        int pos = 0;
        if (index < count) {
            return super.getChildAt(index);
        }
        index -= count;
        if (this.isSetGroup()) {
            if (pos == index) {
                return this.getGroup();
            }
            ++pos;
        }
        throw new IndexOutOfBoundsException(MessageFormat.format(resourceBundle.getString("IndexExceedsBoundsException"), index, Math.min(pos, 0)));
    }

    public int getChildCount() {
        int count = super.getChildCount();
        if (this.isSetGroup()) {
            ++count;
        }
        return count;
    }

    public RenderGroup getGroup() {
        if (this.isSetGroup()) {
            return this.group;
        }
        throw new PropertyUndefinedError("g", (SBase)this);
    }

    public void initDefaults() {
        this.setPackageVersion(-1);
        this.packageName = "render";
        this.roleList = null;
        this.typeList = null;
    }

    public boolean isIdMandatory() {
        return true;
    }

    public boolean isSetGroup() {
        return this.group != null;
    }

    public void setGroup(RenderGroup group) {
        this.unsetGroup();
        this.group = group;
        this.registerChild((SBase)group);
    }

    public int hashCode() {
        int prime = 3083;
        int result = super.hashCode();
        result = 3083 * result + (this.group == null ? 0 : this.group.hashCode());
        if (this.isSetRoleList()) {
            result = 3083 * result + this.roleList.hashCode();
        }
        if (this.isSetTypeList()) {
            result = 3083 * result + this.typeList.hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        Style other = (Style)((Object)obj);
        if (this.group == null ? other.group != null : !this.group.equals((Object)other.group)) {
            return false;
        }
        if (this.isSetRoleList() == other.isSetRoleList() || this.isSetRoleList() && !this.roleList.equals(other.roleList)) {
            return false;
        }
        return this.isSetTypeList() != other.isSetTypeList() && (!this.isSetTypeList() || this.typeList.equals(other.typeList));
    }

    public boolean unsetGroup() {
        if (this.isSetGroup()) {
            RenderGroup oldGroup = this.group;
            this.group = null;
            oldGroup.fireNodeRemovedEvent();
            return true;
        }
        return false;
    }

    public List<String> getRoleList() {
        if (!this.isSetRoleList()) {
            this.roleList = new ArrayList<String>();
        }
        return this.roleList;
    }

    public boolean isSetRoleList() {
        return this.roleList != null;
    }

    public boolean setRoleList(List<String> roleList) {
        List<String> oldRoleList = this.roleList;
        this.roleList = roleList;
        this.firePropertyChange("roleList", oldRoleList, this.roleList);
        return roleList != oldRoleList;
    }

    public List<Type> getTypeList() {
        if (!this.isSetTypeList()) {
            this.typeList = new ArrayList<Type>();
        }
        return this.typeList;
    }

    public boolean isSetTypeList() {
        return this.typeList != null;
    }

    public boolean setTypeList(List<Type> typeList) {
        List<Type> oldTypeList = this.typeList;
        this.typeList = typeList;
        this.firePropertyChange("typeList", oldTypeList, this.typeList);
        return typeList != oldTypeList;
    }

    public boolean unsetTypeList() {
        return this.setTypeList(null);
    }

    public boolean unsetRoleList() {
        return this.setRoleList(null);
    }

    public Map<String, String> writeXMLAttributes() {
        Map attributes = super.writeXMLAttributes();
        if (this.isSetRoleList()) {
            attributes.remove("roleList");
            attributes.put("render:roleList", XMLTools.arrayToWhitespaceSeparatedString(this.getRoleList().toArray(new String[0])));
        }
        if (this.isSetTypeList()) {
            attributes.remove("typeList");
            String[] typeListAsStrings = new String[this.getTypeList().size()];
            for (int i = 0; i < this.getTypeList().size(); ++i) {
                typeListAsStrings[i] = this.getTypeList().get(i).toString();
            }
            attributes.put("render:typeList", XMLTools.arrayToWhitespaceSeparatedString(typeListAsStrings));
        }
        return attributes;
    }

    public boolean readAttribute(String attributeName, String prefix, String value) {
        boolean isAttributeRead = super.readAttribute(attributeName, prefix, value);
        if (!isAttributeRead) {
            isAttributeRead = true;
            if (attributeName.equals("roleList")) {
                this.setRoleList(Arrays.asList(value.split(" ")));
            } else if (attributeName.equals("typeList")) {
                ArrayList<Type> readTypeList = new ArrayList<Type>();
                for (String entry : value.split(" ")) {
                    readTypeList.add(Type.valueOf(entry));
                }
                this.setTypeList(readTypeList);
            } else {
                isAttributeRead = false;
            }
        }
        return isAttributeRead;
    }

    public static enum Type {
        COMPARTMENTGLYPH,
        SPECIESGLYPH,
        REACTIONGLYPH,
        SPECIESREFERENCEGLYPH,
        TEXTGLYPH,
        GENERALGLYPH,
        GRAPHICALOBJECT,
        ANY;

    }
}

