/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.ext.render.Ellipse;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.InvalidAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;

public class EllipseConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                this.addRangeToSet(set, 1320601, 1320609);
                break;
            }
        }
    }

    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func;
        switch (errorCode) {
            case 1320601: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 1320602: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 1320603: {
                func = new UnknownPackageAttributeValidationFunction<Ellipse>("render"){

                    public boolean check(ValidationContext ctx, Ellipse ellipse) {
                        return super.check(ctx, (TreeNodeWithChangeSupport)ellipse) && ellipse.isSetCx() && ellipse.isSetCy() && ellipse.isSetRx();
                    }
                };
                break;
            }
            case 1320604: {
                func = new ValidationFunction<Ellipse>(){

                    public boolean check(ValidationContext ctx, Ellipse ellipse) {
                        return ellipse.isSetCx() && (ellipse.getCx().isSetAbsoluteValue() || ellipse.getCx().isSetRelativeValue());
                    }
                };
                break;
            }
            case 1320605: {
                func = new ValidationFunction<Ellipse>(){

                    public boolean check(ValidationContext ctx, Ellipse ellipse) {
                        return ellipse.isSetCy() && (ellipse.getCy().isSetAbsoluteValue() || ellipse.getCy().isSetRelativeValue());
                    }
                };
                break;
            }
            case 1320606: {
                func = new ValidationFunction<Ellipse>(){

                    public boolean check(ValidationContext ctx, Ellipse ellipse) {
                        return ellipse.isSetRx() && (ellipse.getRx().isSetAbsoluteValue() || ellipse.getRx().isSetRelativeValue());
                    }
                };
                break;
            }
            case 1320607: {
                func = new InvalidAttributeValidationFunction<Ellipse>("ratio"){

                    public boolean check(ValidationContext ctx, Ellipse ellipse) {
                        return super.check(ctx, (TreeNodeWithChangeSupport)ellipse);
                    }
                };
                break;
            }
            case 1320608: {
                func = new ValidationFunction<Ellipse>(){

                    public boolean check(ValidationContext ctx, Ellipse ellipse) {
                        return !ellipse.isSetCz() || ellipse.getCz().isSetAbsoluteValue() || ellipse.getCz().isSetRelativeValue();
                    }
                };
                break;
            }
            case 1320609: {
                func = new ValidationFunction<Ellipse>(){

                    public boolean check(ValidationContext ctx, Ellipse ellipse) {
                        return !ellipse.isSetRy() || ellipse.getRy().isSetAbsoluteValue() || ellipse.getRy().isSetRelativeValue();
                    }
                };
                break;
            }
            default: {
                func = null;
            }
        }
        return func;
    }
}

