/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.ext.render.LineEnding;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.DuplicatedElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.InvalidAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageElementValidationFunction;

public class LineEndingConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                this.addRangeToSet(set, 1321301, 1321305);
                break;
            }
        }
    }

    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func;
        switch (errorCode) {
            case 1321301: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 1321302: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 1321303: {
                func = new UnknownPackageAttributeValidationFunction<LineEnding>("render"){

                    public boolean check(ValidationContext ctx, LineEnding ending) {
                        return super.check(ctx, (TreeNodeWithChangeSupport)ending) && ending.isSetId();
                    }
                };
                break;
            }
            case 1321304: {
                func = new UnknownPackageElementValidationFunction<LineEnding>("render"){

                    public boolean check(ValidationContext ctx, LineEnding ending) {
                        return super.check(ctx, (TreeNodeWithChangeSupport)ending) && new DuplicatedElementValidationFunction("boundingBox").check(ctx, (TreeNodeWithChangeSupport)ending) && new DuplicatedElementValidationFunction("g").check(ctx, (TreeNodeWithChangeSupport)ending);
                    }
                };
                break;
            }
            case 1321305: {
                func = new InvalidAttributeValidationFunction("enableRotationalMapping");
                break;
            }
            default: {
                func = null;
            }
        }
        return func;
    }
}

