/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.ext.render.LinearGradient;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;

public class LinearGradientConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                this.addRangeToSet(set, 1321401, 1321409);
                break;
            }
        }
    }

    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func;
        switch (errorCode) {
            case 1321401: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 1321402: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 1321403: {
                func = new UnknownPackageAttributeValidationFunction("render");
                break;
            }
            case 1321404: {
                func = new ValidationFunction<LinearGradient>(){

                    public boolean check(ValidationContext ctx, LinearGradient gradient) {
                        return !gradient.isSetX1() || gradient.getX1().isSetAbsoluteValue() || gradient.getX1().isSetRelativeValue();
                    }
                };
                break;
            }
            case 1321405: {
                func = new ValidationFunction<LinearGradient>(){

                    public boolean check(ValidationContext ctx, LinearGradient gradient) {
                        return !gradient.isSetY1() || gradient.getY1().isSetAbsoluteValue() || gradient.getY1().isSetRelativeValue();
                    }
                };
                break;
            }
            case 1321406: {
                func = new ValidationFunction<LinearGradient>(){

                    public boolean check(ValidationContext ctx, LinearGradient gradient) {
                        return !gradient.isSetZ1() || gradient.getZ1().isSetAbsoluteValue() || gradient.getZ1().isSetRelativeValue();
                    }
                };
                break;
            }
            case 1321407: {
                func = new ValidationFunction<LinearGradient>(){

                    public boolean check(ValidationContext ctx, LinearGradient gradient) {
                        return !gradient.isSetX2() || gradient.getX2().isSetAbsoluteValue() || gradient.getX2().isSetRelativeValue();
                    }
                };
                break;
            }
            case 1321408: {
                func = new ValidationFunction<LinearGradient>(){

                    public boolean check(ValidationContext ctx, LinearGradient gradient) {
                        return !gradient.isSetY2() || gradient.getY2().isSetAbsoluteValue() || gradient.getY2().isSetRelativeValue();
                    }
                };
                break;
            }
            case 1321409: {
                func = new ValidationFunction<LinearGradient>(){

                    public boolean check(ValidationContext ctx, LinearGradient gradient) {
                        return !gradient.isSetZ2() || gradient.getZ2().isSetAbsoluteValue() || gradient.getZ2().isSetRelativeValue();
                    }
                };
                break;
            }
            default: {
                func = null;
            }
        }
        return func;
    }
}

