/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.ext.render.Rectangle;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.InvalidAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;

public class RectangleConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                this.addRangeToSet(set, 1321901, 1321911);
                break;
            }
        }
    }

    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func;
        switch (errorCode) {
            case 1321901: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 1321902: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 1321903: {
                func = new UnknownPackageAttributeValidationFunction<Rectangle>("render"){

                    public boolean check(ValidationContext ctx, Rectangle r) {
                        return super.check(ctx, (TreeNodeWithChangeSupport)r) && r.isSetX() && r.isSetY() && r.isSetWidth() && r.isSetHeight();
                    }
                };
                break;
            }
            case 1321904: {
                func = new ValidationFunction<Rectangle>(){

                    public boolean check(ValidationContext ctx, Rectangle r) {
                        return r.isSetX() && (r.getX().isSetAbsoluteValue() || r.getX().isSetRelativeValue());
                    }
                };
                break;
            }
            case 1321905: {
                func = new ValidationFunction<Rectangle>(){

                    public boolean check(ValidationContext ctx, Rectangle r) {
                        return r.isSetY() && (r.getY().isSetAbsoluteValue() || r.getY().isSetRelativeValue());
                    }
                };
                break;
            }
            case 1321906: {
                func = new ValidationFunction<Rectangle>(){

                    public boolean check(ValidationContext ctx, Rectangle r) {
                        return r.isSetWidth() && (r.getWidth().isSetAbsoluteValue() || r.getWidth().isSetRelativeValue());
                    }
                };
                break;
            }
            case 1321907: {
                func = new ValidationFunction<Rectangle>(){

                    public boolean check(ValidationContext ctx, Rectangle r) {
                        return r.isSetHeight() && (r.getHeight().isSetAbsoluteValue() || r.getHeight().isSetRelativeValue());
                    }
                };
                break;
            }
            case 1321908: {
                func = new InvalidAttributeValidationFunction("ratio");
                break;
            }
            case 1321909: {
                func = new ValidationFunction<Rectangle>(){

                    public boolean check(ValidationContext ctx, Rectangle r) {
                        return !r.isSetZ() || r.getZ().isSetAbsoluteValue() || r.getZ().isSetRelativeValue();
                    }
                };
                break;
            }
            case 1321910: {
                func = new ValidationFunction<Rectangle>(){

                    public boolean check(ValidationContext ctx, Rectangle r) {
                        return !r.isSetRx() || r.getRx().isSetAbsoluteValue() || r.getRx().isSetRelativeValue();
                    }
                };
                break;
            }
            case 1321911: {
                func = new ValidationFunction<Rectangle>(){

                    public boolean check(ValidationContext ctx, Rectangle r) {
                        return !r.isSetRy() || r.getRy().isSetAbsoluteValue() || r.getRy().isSetRelativeValue();
                    }
                };
                break;
            }
            default: {
                func = null;
            }
        }
        return func;
    }
}

