/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.render.LineEnding;
import org.sbml.jsbml.ext.render.RenderGroup;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.DuplicatedElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.InvalidAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageElementValidationFunction;

public class RenderGroupConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                this.addRangeToSet(set, 1321101, 1321111);
                break;
            }
        }
    }

    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func;
        switch (errorCode) {
            case 1321101: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 1321102: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 1321103: {
                func = new UnknownPackageAttributeValidationFunction("render");
                break;
            }
            case 1321104: {
                func = new UnknownPackageElementValidationFunction<RenderGroup>("render"){

                    public boolean check(ValidationContext ctx, RenderGroup group) {
                        return super.check(ctx, (TreeNodeWithChangeSupport)group) && new DuplicatedElementValidationFunction("render:listOfElements").check(ctx, (TreeNodeWithChangeSupport)group);
                    }
                };
                break;
            }
            case 1321105: {
                func = new ValidationFunction<RenderGroup>(){

                    public boolean check(ValidationContext ctx, RenderGroup group) {
                        if (group.isSetStartHead()) {
                            SBase referenced = group.getModel().getSBaseById(group.getStartHead());
                            return referenced != null && referenced instanceof LineEnding;
                        }
                        return true;
                    }
                };
                break;
            }
            case 1321106: {
                func = new ValidationFunction<RenderGroup>(){

                    public boolean check(ValidationContext ctx, RenderGroup group) {
                        if (group.isSetEndHead()) {
                            SBase referenced = group.getModel().getSBaseById(group.getEndHead());
                            return referenced != null && referenced instanceof LineEnding;
                        }
                        return true;
                    }
                };
                break;
            }
            case 1321107: {
                func = new ValidationFunction<RenderGroup>(){

                    public boolean check(ValidationContext ctx, RenderGroup t) {
                        return true;
                    }
                };
                break;
            }
            case 1321108: {
                func = new InvalidAttributeValidationFunction("font-weight");
                break;
            }
            case 1321109: {
                func = new InvalidAttributeValidationFunction("font-style");
                break;
            }
            case 1321110: {
                func = new InvalidAttributeValidationFunction("text-anchor");
                break;
            }
            case 1321111: {
                func = new InvalidAttributeValidationFunction("vtext-anchor");
                break;
            }
            default: {
                func = null;
            }
        }
        return func;
    }
}

