/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.ext.layout.Layout;
import org.sbml.jsbml.ext.render.ListOfLocalRenderInformation;
import org.sbml.jsbml.ext.render.RenderLayoutPlugin;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.DuplicatedElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.InvalidAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageElementValidationFunction;

public class RenderLayoutPluginConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                this.addRangeToSet(set, 1320301, 1320307);
                break;
            }
        }
    }

    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func;
        switch (errorCode) {
            case 1320301: {
                func = new ValidationFunction<RenderLayoutPlugin>(){

                    public boolean check(ValidationContext ctx, RenderLayoutPlugin rlp) {
                        Layout extendedLayout = (Layout)rlp.getExtendedSBase();
                        return new DuplicatedElementValidationFunction("render:listOfRenderInformation").check(ctx, (TreeNodeWithChangeSupport)extendedLayout) && new UnknownPackageElementValidationFunction("render").check(ctx, (TreeNodeWithChangeSupport)extendedLayout);
                    }
                };
                break;
            }
            case 1320302: {
                func = new ValidationFunction<RenderLayoutPlugin>(){

                    public boolean check(ValidationContext ctx, RenderLayoutPlugin t) {
                        return !t.isListOfLocalRenderInformationEmpty();
                    }
                };
                break;
            }
            case 1320303: {
                func = new ValidationFunction<RenderLayoutPlugin>(){

                    public boolean check(ValidationContext ctx, RenderLayoutPlugin rlp) {
                        if (rlp.isSetListOfLocalRenderInformation()) {
                            return new UnknownElementValidationFunction().check(ctx, (TreeNodeWithChangeSupport)rlp.getListOfLocalRenderInformation());
                        }
                        return true;
                    }
                };
                break;
            }
            case 1320304: {
                func = new ValidationFunction<RenderLayoutPlugin>(){

                    public boolean check(ValidationContext ctx, RenderLayoutPlugin rlp) {
                        if (rlp.isSetListOfLocalRenderInformation()) {
                            return new UnknownCoreAttributeValidationFunction().check(ctx, (TreeNodeWithChangeSupport)rlp.getListOfLocalRenderInformation());
                        }
                        return true;
                    }
                };
                break;
            }
            case 1320305: {
                func = new ValidationFunction<RenderLayoutPlugin>(){

                    public boolean check(ValidationContext ctx, RenderLayoutPlugin rlp) {
                        if (rlp.isSetListOfLocalRenderInformation()) {
                            return new UnknownPackageAttributeValidationFunction("render").check(ctx, (TreeNodeWithChangeSupport)rlp.getListOfLocalRenderInformation());
                        }
                        return true;
                    }
                };
                break;
            }
            case 1320306: {
                func = new ValidationFunction<RenderLayoutPlugin>(){

                    public boolean check(ValidationContext ctx, RenderLayoutPlugin rlp) {
                        if (rlp.isSetListOfLocalRenderInformation()) {
                            ListOfLocalRenderInformation lris = rlp.getListOfLocalRenderInformation();
                            if (lris.isSetVersionMajor()) {
                                return lris.getVersionMajor() >= 0;
                            }
                            return new InvalidAttributeValidationFunction("versionMajor").check(ctx, (TreeNodeWithChangeSupport)lris);
                        }
                        return true;
                    }
                };
                break;
            }
            case 1320307: {
                func = new ValidationFunction<RenderLayoutPlugin>(){

                    public boolean check(ValidationContext ctx, RenderLayoutPlugin rlp) {
                        if (rlp.isSetListOfLocalRenderInformation()) {
                            ListOfLocalRenderInformation lris = rlp.getListOfLocalRenderInformation();
                            if (lris.isSetVersionMinor()) {
                                return lris.getVersionMinor() >= 0;
                            }
                            return new InvalidAttributeValidationFunction("versionMinor").check(ctx, (TreeNodeWithChangeSupport)lris);
                        }
                        return true;
                    }
                };
                break;
            }
            default: {
                func = null;
            }
        }
        return func;
    }
}

