/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.ext.render.Transformation;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.InvalidAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;

public class TransformationConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                this.addRangeToSet(set, 1322501, 1322505);
                break;
            }
        }
    }

    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func;
        switch (errorCode) {
            case 1322501: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 1322502: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 1322503: {
                func = new UnknownPackageAttributeValidationFunction("render");
                break;
            }
            case 1322504: {
                func = new InvalidAttributeValidationFunction("transform");
                break;
            }
            case 1322505: {
                func = new ValidationFunction<Transformation>(){

                    public boolean check(ValidationContext ctx, Transformation t) {
                        return true;
                    }
                };
                break;
            }
            default: {
                func = null;
            }
        }
        return func;
    }
}

