/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.spatial;

import java.text.MessageFormat;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.sbml.jsbml.AbstractMathContainer;
import org.sbml.jsbml.PropertyUndefinedError;
import org.sbml.jsbml.SBMLException;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.spatial.SpatialNamedSBase;
import org.sbml.jsbml.util.ResourceManager;
import org.sbml.jsbml.util.StringTools;

public class AnalyticVolume
extends AbstractMathContainer
implements SpatialNamedSBase {
    String spatialId;
    private String domainType;
    private FunctionKind functionType;
    private Integer ordinal;
    private static final long serialVersionUID = 1757917501241390228L;
    private static final ResourceBundle bundle = ResourceManager.getBundle((String)"org.sbml.jsbml.ext.spatial.Messages");

    public AnalyticVolume() {
    }

    public AnalyticVolume(AnalyticVolume node) {
        super((AbstractMathContainer)node);
        if (node.isSetSpatialId()) {
            this.spatialId = new String(node.getSpatialId());
        }
        if (node.isSetOrdinal()) {
            this.ordinal = new Integer(node.getOrdinal());
        }
        if (node.isSetFunctionType()) {
            this.functionType = node.getFunctionType();
        }
    }

    public AnalyticVolume(String id, int level, int version) {
        super(level, version);
        this.spatialId = id;
    }

    public AnalyticVolume clone() {
        return new AnalyticVolume(this);
    }

    public boolean equals(Object object) {
        boolean equal = super.equals(object);
        if (equal) {
            AnalyticVolume av = (AnalyticVolume)object;
            if ((equal &= av.isSetSpatialId() == this.isSetSpatialId()) && this.isSetSpatialId()) {
                equal &= av.getSpatialId().equals(this.getSpatialId());
            }
            if ((equal &= av.isSetOrdinal() == this.isSetOrdinal()) && this.isSetOrdinal()) {
                equal &= av.getOrdinal() == this.getOrdinal();
            }
            if ((equal &= av.isSetDomainType() == this.isSetDomainType()) && this.isSetDomainType()) {
                equal &= av.getDomainType() == this.getDomainType();
            }
            if ((equal &= av.isSetFunctionType() == this.isSetFunctionType()) && this.isSetFunctionType()) {
                equal &= av.getFunctionType() == this.getFunctionType();
            }
        }
        return equal;
    }

    public FunctionKind getFunctionType() {
        if (this.isSetFunctionType()) {
            return this.functionType;
        }
        throw new PropertyUndefinedError("functionType", (SBase)this);
    }

    public boolean isSetFunctionType() {
        return this.functionType != null;
    }

    public void setFunctionType(FunctionKind functionType) {
        FunctionKind oldFunctionType = this.functionType;
        this.functionType = functionType;
        this.firePropertyChange("functionType", (Object)oldFunctionType, (Object)this.functionType);
    }

    public boolean unsetFunctionType() {
        if (this.isSetFunctionType()) {
            FunctionKind oldFunctionType = this.functionType;
            this.functionType = null;
            this.firePropertyChange("functionType", (Object)oldFunctionType, (Object)this.functionType);
            return true;
        }
        return false;
    }

    public String getDomainType() {
        if (this.isSetDomainType()) {
            return this.domainType;
        }
        throw new PropertyUndefinedError("domainType", (SBase)this);
    }

    public boolean isSetDomainType() {
        return this.domainType != null;
    }

    public void setDomainType(String domainType) {
        String oldDomainType = this.domainType;
        this.domainType = domainType;
        this.firePropertyChange("domainType", oldDomainType, this.domainType);
    }

    public boolean unsetDomainType() {
        if (this.isSetDomainType()) {
            String oldDomainType = this.domainType;
            this.domainType = null;
            this.firePropertyChange("domainType", oldDomainType, this.domainType);
            return true;
        }
        return false;
    }

    public Integer getOrdinal() {
        if (this.isSetOrdinal()) {
            return this.ordinal;
        }
        return null;
    }

    public boolean isSetOrdinal() {
        return this.ordinal != null;
    }

    public void setOrdinal(int ordinal) {
        int oldOrdinal = this.ordinal;
        this.ordinal = ordinal;
        this.firePropertyChange("ordinal", oldOrdinal, this.ordinal);
    }

    public boolean unsetOrdinal() {
        if (this.isSetOrdinal()) {
            int oldOrdinal = this.ordinal;
            this.ordinal = null;
            this.firePropertyChange("ordinal", oldOrdinal, this.ordinal);
            return true;
        }
        return false;
    }

    @Override
    public boolean unsetSpatialId() {
        if (this.isSetSpatialId()) {
            String oldSpatialId = this.spatialId;
            this.spatialId = null;
            this.firePropertyChange("spatialId", oldSpatialId, this.spatialId);
            return true;
        }
        return false;
    }

    @Override
    public void setSpatialId(String spatialId) {
        String oldSpatialId = this.spatialId;
        this.spatialId = spatialId;
        this.firePropertyChange("spatialId", oldSpatialId, this.spatialId);
    }

    @Override
    public boolean isSetSpatialId() {
        return this.spatialId != null;
    }

    @Override
    public String getSpatialId() {
        if (this.isSetSpatialId()) {
            return this.spatialId;
        }
        throw new PropertyUndefinedError("spatialId", (SBase)this);
    }

    public int hashCode() {
        int prime = 431;
        int hashCode = super.hashCode();
        if (this.isSetSpatialId()) {
            hashCode += 431 * this.getSpatialId().hashCode();
        }
        if (this.isSetFunctionType()) {
            hashCode += 431 * this.getFunctionType().hashCode();
        }
        if (this.isSetDomainType()) {
            hashCode += 431 * this.getDomainType().hashCode();
        }
        if (this.isSetOrdinal()) {
            hashCode += 431 * this.getOrdinal().hashCode();
        }
        return hashCode;
    }

    public Map<String, String> writeXMLAttributes() {
        Map attributes = super.writeXMLAttributes();
        if (this.isSetSpatialId()) {
            attributes.remove("spatialId");
            attributes.put("spatial:spatialId", this.getSpatialId());
        }
        if (this.isSetDomainType()) {
            attributes.remove("domainType");
            attributes.put("spatial:domainType", this.getDomainType());
        }
        if (this.isSetOrdinal()) {
            attributes.remove("ordinal");
            attributes.put("spatial:ordinal", String.valueOf(this.getOrdinal()));
        }
        if (this.isSetFunctionType()) {
            attributes.remove("functionType");
            attributes.put("spatial:functionType", this.getFunctionType().toString());
        }
        if (this.isSetSBOTerm()) {
            attributes.remove("sboTerm");
            attributes.put("spatial:sboTerm", this.getSBOTermID());
        }
        if (this.isSetMetaId()) {
            attributes.remove("metaId");
            attributes.put("spatial:metaId", this.getMetaId());
        }
        return attributes;
    }

    public boolean readAttribute(String attributeName, String prefix, String value) {
        boolean isAttributeRead;
        boolean bl = isAttributeRead = super.readAttribute(attributeName, prefix, value) && "spatial" == prefix;
        if (!isAttributeRead) {
            isAttributeRead = true;
            if (attributeName.equals("spatialId")) {
                try {
                    this.setSpatialId(value);
                }
                catch (Exception e) {
                    MessageFormat.format(bundle.getString("COULD_NOT_READ"), value, "spatialId");
                }
            } else if (attributeName.equals("ordinal")) {
                try {
                    this.setOrdinal(StringTools.parseSBMLInt((String)value));
                }
                catch (Exception e) {
                    MessageFormat.format(bundle.getString("COULD_NOT_READ"), value, "ordinal");
                }
            } else if (attributeName.equals("domainType")) {
                try {
                    this.setDomainType(value);
                }
                catch (Exception e) {
                    MessageFormat.format(bundle.getString("COULD_NOT_READ"), value, "domainType");
                }
            } else if (attributeName.equals("functionType")) {
                if (!Pattern.matches("[a-z]*", value)) {
                    throw new SBMLException("The value is not all lower-case.");
                }
                this.setFunctionType(FunctionKind.valueOf(value.toUpperCase()));
            } else {
                isAttributeRead = false;
            }
        }
        return isAttributeRead;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AnalyticVolume [spatialId=");
        builder.append(this.spatialId);
        builder.append(", domainType=");
        builder.append(this.domainType);
        builder.append(", functionType=");
        builder.append((Object)this.functionType);
        builder.append(", ordinal=");
        builder.append(this.ordinal);
        builder.append("]");
        return builder.toString();
    }

    public static enum FunctionKind {
        LAYERED;

    }
}

