/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.spatial;

import java.text.MessageFormat;
import java.util.Map;
import org.sbml.jsbml.PropertyUndefinedError;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.spatial.CSGTransformation;
import org.sbml.jsbml.ext.spatial.SpatialConstants;
import org.sbml.jsbml.util.StringTools;

public class CSGRotation
extends CSGTransformation {
    private static final long serialVersionUID = -4799604235135248586L;
    private Double rotateAxisX;
    private Double rotateAxisY;
    private Double rotateAxisZ;
    private Double rotateAngleInRadians;

    public CSGRotation() {
    }

    public CSGRotation(CSGRotation csgt) {
        super(csgt);
        if (csgt.isSetRotateAxisX()) {
            this.rotateAxisX = new Double(csgt.getRotateAxisX());
        }
        if (csgt.isSetRotateAxisY()) {
            this.rotateAxisY = new Double(csgt.getRotateAxisY());
        }
        if (csgt.isSetRotateAxisZ()) {
            this.rotateAxisZ = new Double(csgt.getRotateAxisZ());
        }
    }

    public CSGRotation(int level, int version) {
        super(level, version);
    }

    public CSGRotation(String id, int level, int version) {
        super(id, level, version);
    }

    public CSGRotation clone() {
        return new CSGRotation(this);
    }

    @Override
    public boolean equals(Object object) {
        boolean equal = super.equals(object);
        if (equal) {
            CSGRotation csgt = (CSGRotation)object;
            if ((equal &= csgt.isSetRotateAxisX() == this.isSetRotateAxisX()) && this.isSetRotateAxisX()) {
                equal &= csgt.getRotateAxisX() == this.getRotateAxisX();
            }
            if ((equal &= csgt.isSetRotateAxisY() == this.isSetRotateAxisY()) && this.isSetRotateAxisY()) {
                equal &= csgt.getRotateAxisY() == this.getRotateAxisY();
            }
            if ((equal &= csgt.isSetRotateAxisZ() == this.isSetRotateAxisZ()) && this.isSetRotateAxisZ()) {
                equal &= csgt.getRotateAxisZ() == this.getRotateAxisZ();
            }
            if ((equal &= csgt.isSetRotateAngleInRadians() == this.isSetRotateAngleInRadians()) && this.isSetRotateAngleInRadians()) {
                equal &= csgt.getRotateAngleInRadians() == this.getRotateAngleInRadians();
            }
        }
        return equal;
    }

    public double getRotateAxisX() {
        if (this.isSetRotateAxisX()) {
            return this.rotateAxisX;
        }
        throw new PropertyUndefinedError("rotateAxisX", (SBase)this);
    }

    public boolean isSetRotateAxisX() {
        return this.rotateAxisX != null;
    }

    public void setRotateAxisX(double rotateAxisX) {
        double oldRotateAxisX = this.rotateAxisX;
        this.rotateAxisX = rotateAxisX;
        this.firePropertyChange("rotateAxisX", oldRotateAxisX, this.rotateAxisX);
    }

    public boolean unsetRotateAxisX() {
        if (this.isSetRotateAxisX()) {
            double oldRotateAxisX = this.rotateAxisX;
            this.rotateAxisX = null;
            this.firePropertyChange("rotateAxisX", oldRotateAxisX, this.rotateAxisX);
            return true;
        }
        return false;
    }

    public double getRotateAxisY() {
        if (this.isSetRotateAxisY()) {
            return this.rotateAxisY;
        }
        throw new PropertyUndefinedError("rotateAxisY", (SBase)this);
    }

    public boolean isSetRotateAxisY() {
        return this.rotateAxisY != null;
    }

    public void setRotateAxisY(double rotateAxisY) {
        double oldRotateAxisY = this.rotateAxisY;
        this.rotateAxisY = rotateAxisY;
        this.firePropertyChange("rotateAxisY", oldRotateAxisY, this.rotateAxisY);
    }

    public boolean unsetRotateAxisY() {
        if (this.isSetRotateAxisY()) {
            double oldRotateAxisY = this.rotateAxisY;
            this.rotateAxisY = null;
            this.firePropertyChange("rotateAxisY", oldRotateAxisY, this.rotateAxisY);
            return true;
        }
        return false;
    }

    public double getRotateAxisZ() {
        if (this.isSetRotateAxisZ()) {
            return this.rotateAxisZ;
        }
        throw new PropertyUndefinedError("rotateAxisZ", (SBase)this);
    }

    public boolean isSetRotateAxisZ() {
        return this.rotateAxisZ != null;
    }

    public void setRotateAxisZ(double rotateAxisZ) {
        double oldRotateAxisZ = this.rotateAxisZ;
        this.rotateAxisZ = rotateAxisZ;
        this.firePropertyChange("rotateAxisZ", oldRotateAxisZ, this.rotateAxisZ);
    }

    public boolean unsetRotateAxisZ() {
        if (this.isSetRotateAxisZ()) {
            double oldRotateAxisZ = this.rotateAxisZ;
            this.rotateAxisZ = null;
            this.firePropertyChange("rotateAxisZ", oldRotateAxisZ, this.rotateAxisZ);
            return true;
        }
        return false;
    }

    public double getRotateAngleInRadians() {
        if (this.isSetRotateAngleInRadians()) {
            return this.rotateAngleInRadians;
        }
        throw new PropertyUndefinedError("rotateAngleInRadians", (SBase)this);
    }

    public boolean isSetRotateAngleInRadians() {
        return this.rotateAngleInRadians != null;
    }

    public void setRotateAngleInRadians(double rotateAngleInRadians) {
        double oldRotateAngleInRadians = this.rotateAngleInRadians;
        this.rotateAngleInRadians = rotateAngleInRadians;
        this.firePropertyChange("rotateAngleInRadians", oldRotateAngleInRadians, this.rotateAngleInRadians);
    }

    public boolean unsetRotateAngleInRadians() {
        if (this.isSetRotateAngleInRadians()) {
            double oldRotateAngleInRadians = this.rotateAngleInRadians;
            this.rotateAngleInRadians = null;
            this.firePropertyChange("rotateAngleInRadians", oldRotateAngleInRadians, this.rotateAngleInRadians);
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int prime = 313;
        int hashCode = super.hashCode();
        if (this.isSetRotateAxisX()) {
            hashCode = (int)((double)hashCode + 313.0 * this.getRotateAxisX());
        }
        if (this.isSetRotateAxisY()) {
            hashCode = (int)((double)hashCode + 313.0 * this.getRotateAxisY());
        }
        if (this.isSetRotateAxisZ()) {
            hashCode = (int)((double)hashCode + 313.0 * this.getRotateAxisZ());
        }
        if (this.isSetRotateAngleInRadians()) {
            hashCode = (int)((double)hashCode + 313.0 * this.getRotateAngleInRadians());
        }
        return hashCode;
    }

    @Override
    public Map<String, String> writeXMLAttributes() {
        Map<String, String> attributes = super.writeXMLAttributes();
        if (this.isSetRotateAxisX()) {
            attributes.remove("rotateAxisX");
            attributes.put("spatial:rotateAxisX", String.valueOf(this.getRotateAxisX()));
        }
        if (this.isSetRotateAxisY()) {
            attributes.remove("rotateAxisY");
            attributes.put("spatial:rotateAxisY", String.valueOf(this.getRotateAxisY()));
        }
        if (this.isSetRotateAxisZ()) {
            attributes.remove("rotateAxisZ");
            attributes.put("spatial:rotateAxisZ", String.valueOf(this.getRotateAxisZ()));
        }
        if (this.isSetRotateAngleInRadians()) {
            attributes.remove("rotateAngleInRadians");
            attributes.put("spatial:rotateAngleInRadians", String.valueOf(this.getRotateAngleInRadians()));
        }
        return attributes;
    }

    @Override
    public boolean readAttribute(String attributeName, String prefix, String value) {
        boolean isAttributeRead;
        boolean bl = isAttributeRead = super.readAttribute(attributeName, prefix, value) && "spatial" == prefix;
        if (!isAttributeRead) {
            isAttributeRead = true;
            if (attributeName.equals("rotateAxisX")) {
                try {
                    this.setRotateAxisX(StringTools.parseSBMLDouble((String)value));
                }
                catch (Exception e) {
                    MessageFormat.format(SpatialConstants.bundle.getString("COULD_NOT_READ"), value, "rotateAxisX");
                }
            } else if (attributeName.equals("rotateAxisY")) {
                try {
                    this.setRotateAxisY(StringTools.parseSBMLDouble((String)value));
                }
                catch (Exception e) {
                    MessageFormat.format(SpatialConstants.bundle.getString("COULD_NOT_READ"), value, "rotateAxisY");
                }
            } else if (attributeName.equals("rotateAxisZ")) {
                try {
                    this.setRotateAxisZ(StringTools.parseSBMLDouble((String)value));
                }
                catch (Exception e) {
                    MessageFormat.format(SpatialConstants.bundle.getString("COULD_NOT_READ"), value, "rotateAxisZ");
                }
            } else if (attributeName.equals("rotateAngleInRadians")) {
                try {
                    this.setRotateAngleInRadians(StringTools.parseSBMLDouble((String)value));
                }
                catch (Exception e) {
                    MessageFormat.format(SpatialConstants.bundle.getString("COULD_NOT_READ"), value, "rotateAngleInRadians");
                }
            } else {
                isAttributeRead = false;
            }
        }
        return isAttributeRead;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CSGRotation [rotateAxisX=");
        builder.append(this.rotateAxisX);
        builder.append(", rotateAxisY=");
        builder.append(this.rotateAxisY);
        builder.append(", rotateAxisZ=");
        builder.append(this.rotateAxisZ);
        builder.append(", rotateAngleInRadians=");
        builder.append(this.rotateAngleInRadians);
        builder.append("]");
        return builder.toString();
    }
}

