/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.spatial;

import java.text.MessageFormat;
import java.util.Map;
import org.sbml.jsbml.PropertyUndefinedError;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.spatial.CSGTransformation;
import org.sbml.jsbml.ext.spatial.SpatialConstants;
import org.sbml.jsbml.util.StringTools;

public class CSGScale
extends CSGTransformation {
    private static final long serialVersionUID = 7021488698800177528L;
    private Double scaleX;
    private Double scaleY;
    private Double scaleZ;

    public CSGScale() {
    }

    public CSGScale(CSGScale csgt) {
        super(csgt);
        if (csgt.isSetScaleX()) {
            this.scaleX = new Double(csgt.getScaleX());
        }
        if (csgt.isSetScaleY()) {
            this.scaleY = new Double(csgt.getScaleY());
        }
        if (csgt.isSetScaleZ()) {
            this.scaleZ = new Double(csgt.getScaleZ());
        }
    }

    public CSGScale(int level, int version) {
        super(level, version);
    }

    public CSGScale(String id, int level, int version) {
        super(id, level, version);
    }

    public CSGScale clone() {
        return new CSGScale(this);
    }

    @Override
    public boolean equals(Object object) {
        boolean equal = super.equals(object);
        if (equal) {
            CSGScale csgt = (CSGScale)object;
            if ((equal &= csgt.isSetScaleX() == this.isSetScaleX()) && this.isSetScaleX()) {
                equal &= csgt.getScaleX() == this.getScaleX();
            }
            if ((equal &= csgt.isSetScaleY() == this.isSetScaleY()) && this.isSetScaleY()) {
                equal &= csgt.getScaleY() == this.getScaleY();
            }
            if ((equal &= csgt.isSetScaleZ() == this.isSetScaleZ()) && this.isSetScaleZ()) {
                equal &= csgt.getScaleZ() == this.getScaleZ();
            }
        }
        return equal;
    }

    public double getScaleX() {
        if (this.isSetScaleX()) {
            return this.scaleX;
        }
        throw new PropertyUndefinedError("scaleX", (SBase)this);
    }

    public boolean isSetScaleX() {
        return this.scaleX != null;
    }

    public void setScaleX(double scaleX) {
        double oldScaleX = this.scaleX;
        this.scaleX = scaleX;
        this.firePropertyChange("scaleX", oldScaleX, this.scaleX);
    }

    public boolean unsetScaleX() {
        if (this.isSetScaleX()) {
            double oldScaleX = this.scaleX;
            this.scaleX = null;
            this.firePropertyChange("scaleX", oldScaleX, this.scaleX);
            return true;
        }
        return false;
    }

    public double getScaleY() {
        if (this.isSetScaleY()) {
            return this.scaleY;
        }
        throw new PropertyUndefinedError("scaleY", (SBase)this);
    }

    public boolean isSetScaleY() {
        return this.scaleY != null;
    }

    public void setScaleY(double scaleY) {
        double oldScaleY = this.scaleY;
        this.scaleY = scaleY;
        this.firePropertyChange("scaleY", oldScaleY, this.scaleY);
    }

    public boolean unsetScaleY() {
        if (this.isSetScaleY()) {
            double oldScaleY = this.scaleY;
            this.scaleY = null;
            this.firePropertyChange("scaleY", oldScaleY, this.scaleY);
            return true;
        }
        return false;
    }

    public double getScaleZ() {
        if (this.isSetScaleZ()) {
            return this.scaleZ;
        }
        throw new PropertyUndefinedError("scaleZ", (SBase)this);
    }

    public boolean isSetScaleZ() {
        return this.scaleZ != null;
    }

    public void setScaleZ(double scaleZ) {
        double oldScaleZ = this.scaleZ;
        this.scaleZ = scaleZ;
        this.firePropertyChange("scaleZ", oldScaleZ, this.scaleZ);
    }

    public boolean unsetScaleZ() {
        if (this.isSetScaleZ()) {
            double oldScaleZ = this.scaleZ;
            this.scaleZ = null;
            this.firePropertyChange("scaleZ", oldScaleZ, this.scaleZ);
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int prime = 313;
        int hashCode = super.hashCode();
        if (this.isSetScaleX()) {
            hashCode = (int)((double)hashCode + 313.0 * this.getScaleX());
        }
        if (this.isSetScaleY()) {
            hashCode = (int)((double)hashCode + 313.0 * this.getScaleY());
        }
        if (this.isSetScaleZ()) {
            hashCode = (int)((double)hashCode + 313.0 * this.getScaleZ());
        }
        return hashCode;
    }

    @Override
    public Map<String, String> writeXMLAttributes() {
        Map<String, String> attributes = super.writeXMLAttributes();
        if (this.isSetScaleX()) {
            attributes.remove("scaleX");
            attributes.put("spatial:scaleX", String.valueOf(this.getScaleX()));
        }
        if (this.isSetScaleY()) {
            attributes.remove("scaleY");
            attributes.put("spatial:scaleY", String.valueOf(this.getScaleY()));
        }
        if (this.isSetScaleZ()) {
            attributes.remove("scaleZ");
            attributes.put("spatial:scaleZ", String.valueOf(this.getScaleZ()));
        }
        return attributes;
    }

    @Override
    public boolean readAttribute(String attributeName, String prefix, String value) {
        boolean isAttributeRead;
        boolean bl = isAttributeRead = super.readAttribute(attributeName, prefix, value) && "spatial" == prefix;
        if (!isAttributeRead) {
            isAttributeRead = true;
            if (attributeName.equals("scaleX")) {
                try {
                    this.setScaleX(StringTools.parseSBMLInt((String)value));
                }
                catch (Exception e) {
                    MessageFormat.format(SpatialConstants.bundle.getString("COULD_NOT_READ"), value, "scaleX");
                }
            } else if (attributeName.equals("scaleY")) {
                try {
                    this.setScaleY(StringTools.parseSBMLInt((String)value));
                }
                catch (Exception e) {
                    MessageFormat.format(SpatialConstants.bundle.getString("COULD_NOT_READ"), value, "scaleY");
                }
            } else if (attributeName.equals("scaleZ")) {
                try {
                    this.setScaleZ(StringTools.parseSBMLInt((String)value));
                }
                catch (Exception e) {
                    MessageFormat.format(SpatialConstants.bundle.getString("COULD_NOT_READ"), value, "scaleZ");
                }
            } else {
                isAttributeRead = false;
            }
        }
        return isAttributeRead;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CSGScale [scaleX=");
        builder.append(this.scaleX);
        builder.append(", scaleY=");
        builder.append(this.scaleY);
        builder.append(", scaleZ=");
        builder.append(this.scaleZ);
        builder.append("]");
        return builder.toString();
    }
}

