/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.spatial;

import java.text.MessageFormat;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.tree.TreeNode;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.PropertyUndefinedError;
import org.sbml.jsbml.SBMLException;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.spatial.CSGHomogeneousTransformation;
import org.sbml.jsbml.ext.spatial.CSGNode;
import org.sbml.jsbml.ext.spatial.CSGPrimitive;
import org.sbml.jsbml.ext.spatial.CSGPseudoPrimitive;
import org.sbml.jsbml.ext.spatial.CSGRotation;
import org.sbml.jsbml.ext.spatial.CSGScale;
import org.sbml.jsbml.ext.spatial.CSGTranslation;
import org.sbml.jsbml.ext.spatial.SpatialConstants;
import org.sbml.jsbml.util.filters.Filter;
import org.sbml.jsbml.util.filters.NameFilter;

public class CSGSetOperator
extends CSGNode {
    private static final long serialVersionUID = 3448308755493169761L;
    private SetOperation operationType;
    private String complementA;
    private String complementB;
    private ListOf<CSGNode> listOfCSGNodes;

    public CSGSetOperator() {
    }

    public CSGSetOperator(CSGSetOperator csgso) {
        super(csgso);
        if (csgso.isSetListOfCSGNodes()) {
            this.setListOfCSGNodes((ListOf<CSGNode>)csgso.getListOfCSGNodes().clone());
        }
        if (csgso.isSetOperationType()) {
            this.operationType = csgso.getOperationType();
        }
        if (csgso.isSetComplementA()) {
            this.complementA = new String(csgso.getComplementA());
        }
        if (csgso.isSetComplementB()) {
            this.complementB = new String(csgso.getComplementB());
        }
    }

    public CSGSetOperator(int level, int version) {
        super(level, version);
    }

    public CSGSetOperator(String id, int level, int version) {
        super(id, level, version);
    }

    public CSGSetOperator clone() {
        return new CSGSetOperator(this);
    }

    @Override
    public boolean equals(Object object) {
        boolean equal = super.equals(object);
        if (equal) {
            CSGSetOperator csgso = (CSGSetOperator)object;
            if ((equal &= csgso.isSetOperationType() == this.isSetOperationType()) && this.isSetOperationType()) {
                equal &= csgso.getOperationType().equals((Object)this.getOperationType());
            }
            if ((equal &= csgso.isSetListOfCSGNodes() == this.isSetListOfCSGNodes()) && this.isSetListOfCSGNodes()) {
                equal &= csgso.getListOfCSGNodes().equals(this.getListOfCSGNodes());
            }
            if ((equal &= csgso.isSetComplementA() == this.isSetComplementA()) && this.isSetComplementA()) {
                equal &= csgso.getComplementA().equals(this.getComplementA());
            }
            if ((equal &= csgso.isSetComplementB() == this.isSetComplementB()) && this.isSetComplementB()) {
                equal &= csgso.getComplementB().equals(this.getComplementB());
            }
        }
        return equal;
    }

    public String getComplementA() {
        if (this.isSetComplementA()) {
            return this.complementA;
        }
        throw new PropertyUndefinedError("complementA", (SBase)this);
    }

    public boolean isSetComplementA() {
        return this.complementA != null;
    }

    public void setComplementA(String complementA) {
        String oldComplementA = this.complementA;
        this.complementA = complementA;
        this.firePropertyChange("complementA", oldComplementA, this.complementA);
    }

    public boolean unsetComplementA() {
        if (this.isSetComplementA()) {
            String oldComplementA = this.complementA;
            this.complementA = null;
            this.firePropertyChange("complementA", oldComplementA, this.complementA);
            return true;
        }
        return false;
    }

    public String getComplementB() {
        if (this.isSetComplementB()) {
            return this.complementB;
        }
        throw new PropertyUndefinedError("complementB", (SBase)this);
    }

    public boolean isSetComplementB() {
        return this.complementB != null;
    }

    public void setComplementB(String complementB) {
        String oldComplementB = this.complementB;
        this.complementB = complementB;
        this.firePropertyChange("complementB", oldComplementB, this.complementB);
    }

    public boolean unsetComplementB() {
        if (this.isSetComplementB()) {
            String oldComplementB = this.complementB;
            this.complementB = null;
            this.firePropertyChange("complementB", oldComplementB, this.complementB);
            return true;
        }
        return false;
    }

    public SetOperation getOperationType() {
        if (this.isSetOperationType()) {
            return this.operationType;
        }
        throw new PropertyUndefinedError("operationType", (SBase)this);
    }

    public boolean isSetOperationType() {
        return this.operationType != null;
    }

    public void setOperationType(SetOperation operationType) {
        SetOperation oldOperationType = this.operationType;
        this.operationType = operationType;
        this.firePropertyChange("operationType", (Object)oldOperationType, (Object)this.operationType);
    }

    public boolean unsetOperationType() {
        if (this.isSetOperationType()) {
            SetOperation oldOperationType = this.operationType;
            this.operationType = null;
            this.firePropertyChange("operationType", (Object)oldOperationType, (Object)this.operationType);
            return true;
        }
        return false;
    }

    public boolean isSetListOfCSGNodes() {
        return this.listOfCSGNodes != null && !this.listOfCSGNodes.isEmpty();
    }

    public ListOf<CSGNode> getListOfCSGNodes() {
        if (!this.isSetListOfCSGNodes()) {
            this.listOfCSGNodes = new ListOf(this.getLevel(), this.getVersion());
            this.listOfCSGNodes.setNamespace("http://www.sbml.org/sbml/level3/version1/spatial/version1");
            this.listOfCSGNodes.setSBaseListType(ListOf.Type.other);
            this.registerChild((SBase)this.listOfCSGNodes);
        }
        return this.listOfCSGNodes;
    }

    public void setListOfCSGNodes(ListOf<CSGNode> listOfCSGNodes) {
        this.unsetListOfCSGNodes();
        this.listOfCSGNodes = listOfCSGNodes;
        this.registerChild((SBase)this.listOfCSGNodes);
    }

    public boolean unsetListOfCSGNodes() {
        if (this.isSetListOfCSGNodes()) {
            ListOf<CSGNode> oldCSGNodes = this.listOfCSGNodes;
            this.listOfCSGNodes = null;
            oldCSGNodes.fireNodeRemovedEvent();
            return true;
        }
        return false;
    }

    public boolean addCSGNode(CSGNode csgNode) {
        return this.getListOfCSGNodes().add((SBase)csgNode);
    }

    public boolean removeCSGNode(CSGNode csgNode) {
        if (this.isSetListOfCSGNodes()) {
            return this.getListOfCSGNodes().remove((Object)csgNode);
        }
        return false;
    }

    public void removeCSGNode(int i) {
        if (!this.isSetListOfCSGNodes()) {
            throw new IndexOutOfBoundsException(Integer.toString(i));
        }
        this.getListOfCSGNodes().remove(i);
    }

    public void removeCSGNode(String id) {
        this.getListOfCSGNodes().removeFirst((Filter)new NameFilter(id));
    }

    public CSGPrimitive createCSGPrimitive() {
        return this.createCSGPrimitive(null);
    }

    public CSGPseudoPrimitive createCSGPseudoPrimitive() {
        return this.createCSGPseudoPrimitive(null);
    }

    public CSGSetOperator createCSGSetOperator() {
        return this.createCSGSetOperator(null);
    }

    public CSGTranslation createCSGTranslation() {
        return this.createCSGTranslation(null);
    }

    public CSGRotation createCSGRotation() {
        return this.createCSGRotation(null);
    }

    public CSGScale createCSGScale() {
        return this.createCSGScale(null);
    }

    public CSGHomogeneousTransformation createCSGHomogeneousTransformation() {
        return this.createCSGHomogeneousTransformation(null);
    }

    public CSGHomogeneousTransformation createCSGHomogeneousTransformation(String id) {
        CSGHomogeneousTransformation csgNode = new CSGHomogeneousTransformation(id, this.getLevel(), this.getVersion());
        this.addCSGNode(csgNode);
        return csgNode;
    }

    public CSGScale createCSGScale(String id) {
        CSGScale csgNode = new CSGScale(id, this.getLevel(), this.getVersion());
        this.addCSGNode(csgNode);
        return csgNode;
    }

    public CSGRotation createCSGRotation(String id) {
        CSGRotation csgNode = new CSGRotation(id, this.getLevel(), this.getVersion());
        this.addCSGNode(csgNode);
        return csgNode;
    }

    public CSGTranslation createCSGTranslation(String id) {
        CSGTranslation csgNode = new CSGTranslation(id, this.getLevel(), this.getVersion());
        this.addCSGNode(csgNode);
        return csgNode;
    }

    public CSGSetOperator createCSGSetOperator(String id) {
        CSGSetOperator csgNode = new CSGSetOperator(id, this.getLevel(), this.getVersion());
        this.addCSGNode(csgNode);
        return csgNode;
    }

    public CSGPseudoPrimitive createCSGPseudoPrimitive(String id) {
        CSGPseudoPrimitive csgNode = new CSGPseudoPrimitive(id, this.getLevel(), this.getVersion());
        this.addCSGNode(csgNode);
        return csgNode;
    }

    public CSGPrimitive createCSGPrimitive(String id) {
        CSGPrimitive csgNode = new CSGPrimitive(id, this.getLevel(), this.getVersion());
        this.addCSGNode(csgNode);
        return csgNode;
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public int getChildCount() {
        int count = super.getChildCount();
        if (this.isSetListOfCSGNodes()) {
            ++count;
        }
        return count;
    }

    @Override
    public TreeNode getChildAt(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException(index + " < 0");
        }
        int count = super.getChildCount();
        int pos = 0;
        if (index < count) {
            return super.getChildAt(index);
        }
        index -= count;
        if (this.isSetListOfCSGNodes()) {
            if (pos == index) {
                return this.getListOfCSGNodes();
            }
            ++pos;
        }
        throw new IndexOutOfBoundsException(MessageFormat.format("Index {0,number,integer} >= {1,number,integer}", index, Math.min(pos, 0)));
    }

    @Override
    public int hashCode() {
        int prime = 983;
        int hashCode = super.hashCode();
        if (this.isSetOperationType()) {
            hashCode += 983 * this.getOperationType().hashCode();
        }
        return hashCode;
    }

    @Override
    public Map<String, String> writeXMLAttributes() {
        Map<String, String> attributes = super.writeXMLAttributes();
        if (this.isSetOperationType()) {
            attributes.remove("operationType");
            attributes.put("spatial:operationType", this.getOperationType().toString());
        }
        if (this.isSetComplementA()) {
            attributes.remove("complementA");
            attributes.put("spatial:complementA", this.getComplementA());
        }
        if (this.isSetComplementB()) {
            attributes.remove("complementB");
            attributes.put("spatial:complementB", this.getComplementB());
        }
        return attributes;
    }

    @Override
    public boolean readAttribute(String attributeName, String prefix, String value) {
        boolean isAttributeRead;
        boolean bl = isAttributeRead = super.readAttribute(attributeName, prefix, value) && "spatial" == prefix;
        if (!isAttributeRead) {
            isAttributeRead = true;
            if (attributeName.equals("operationType")) {
                if (!Pattern.matches("[a-z]*", value)) {
                    throw new SBMLException("The value is not all lower-case.");
                }
                this.setOperationType(SetOperation.valueOf(value.toUpperCase()));
            } else if (attributeName.equals("complementA")) {
                try {
                    this.setComplementA(value);
                }
                catch (Exception e) {
                    MessageFormat.format(SpatialConstants.bundle.getString("COULD_NOT_READ"), value, "complementA");
                }
            } else if (attributeName.equals("complementB")) {
                try {
                    this.setComplementB(value);
                }
                catch (Exception e) {
                    MessageFormat.format(SpatialConstants.bundle.getString("COULD_NOT_READ"), value, "complementB");
                }
            } else {
                isAttributeRead = false;
            }
        }
        return isAttributeRead;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CSGSetOperator [operationType=");
        builder.append((Object)this.operationType);
        builder.append(", complementA=");
        builder.append(this.complementA);
        builder.append(", complementB=");
        builder.append(this.complementB);
        builder.append(", listOfCSGNodes=");
        builder.append(this.listOfCSGNodes);
        builder.append("]");
        return builder.toString();
    }

    public static enum SetOperation {
        UNION,
        INTERSECTION,
        RELATIVECOMPONENT;

    }
}

