/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.spatial;

import java.text.MessageFormat;
import java.util.Map;
import org.sbml.jsbml.PropertyUndefinedError;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.spatial.CSGTransformation;
import org.sbml.jsbml.ext.spatial.SpatialConstants;
import org.sbml.jsbml.util.StringTools;

public class CSGTranslation
extends CSGTransformation {
    private static final long serialVersionUID = 7030963917812170311L;
    private Double translateX;
    private Double translateY;
    private Double translateZ;

    public CSGTranslation() {
    }

    public CSGTranslation(CSGTranslation csgt) {
        super(csgt);
        if (csgt.isSetTranslateX()) {
            this.translateX = new Double(csgt.getTranslateX());
        }
        if (csgt.isSetTranslateY()) {
            this.translateY = new Double(csgt.getTranslateY());
        }
        if (csgt.isSetTranslateZ()) {
            this.translateZ = new Double(csgt.getTranslateZ());
        }
    }

    public CSGTranslation(int level, int version) {
        super(level, version);
    }

    public CSGTranslation(String id, int level, int version) {
        super(id, level, version);
    }

    public CSGTranslation clone() {
        return new CSGTranslation(this);
    }

    @Override
    public boolean equals(Object object) {
        boolean equal = super.equals(object);
        if (equal) {
            CSGTranslation csgt = (CSGTranslation)object;
            if ((equal &= csgt.isSetTranslateX() == this.isSetTranslateX()) && this.isSetTranslateX()) {
                equal &= csgt.getTranslateX() == this.getTranslateX();
            }
            if ((equal &= csgt.isSetTranslateY() == this.isSetTranslateY()) && this.isSetTranslateY()) {
                equal &= csgt.getTranslateY() == this.getTranslateY();
            }
            if ((equal &= csgt.isSetTranslateZ() == this.isSetTranslateZ()) && this.isSetTranslateZ()) {
                equal &= csgt.getTranslateZ() == this.getTranslateZ();
            }
        }
        return equal;
    }

    public double getTranslateX() {
        if (this.isSetTranslateX()) {
            return this.translateX;
        }
        throw new PropertyUndefinedError("translateX", (SBase)this);
    }

    public boolean isSetTranslateX() {
        return this.translateX != null;
    }

    public void setTranslateX(double translateX) {
        double oldTranslateX = this.translateX;
        this.translateX = translateX;
        this.firePropertyChange("translateX", oldTranslateX, this.translateX);
    }

    public boolean unsetTranslateX() {
        if (this.isSetTranslateX()) {
            double oldTranslateX = this.translateX;
            this.translateX = null;
            this.firePropertyChange("translateX", oldTranslateX, this.translateX);
            return true;
        }
        return false;
    }

    public double getTranslateY() {
        if (this.isSetTranslateY()) {
            return this.translateY;
        }
        throw new PropertyUndefinedError("translateY", (SBase)this);
    }

    public boolean isSetTranslateY() {
        return this.translateY != null;
    }

    public void setTranslateY(double translateY) {
        double oldTranslateY = this.translateY;
        this.translateY = translateY;
        this.firePropertyChange("translateY", oldTranslateY, this.translateY);
    }

    public boolean unsetTranslateY() {
        if (this.isSetTranslateY()) {
            double oldTranslateY = this.translateY;
            this.translateY = null;
            this.firePropertyChange("translateY", oldTranslateY, this.translateY);
            return true;
        }
        return false;
    }

    public double getTranslateZ() {
        if (this.isSetTranslateZ()) {
            return this.translateZ;
        }
        throw new PropertyUndefinedError("translateZ", (SBase)this);
    }

    public boolean isSetTranslateZ() {
        return this.translateZ != null;
    }

    public void setTranslateZ(double translateZ) {
        double oldTranslateZ = this.translateZ;
        this.translateZ = translateZ;
        this.firePropertyChange("translateZ", oldTranslateZ, this.translateZ);
    }

    public boolean unsetTranslateZ() {
        if (this.isSetTranslateZ()) {
            double oldTranslateZ = this.translateZ;
            this.translateZ = null;
            this.firePropertyChange("translateZ", oldTranslateZ, this.translateZ);
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int prime = 313;
        int hashCode = super.hashCode();
        if (this.isSetTranslateX()) {
            hashCode = (int)((double)hashCode + 313.0 * this.getTranslateX());
        }
        if (this.isSetTranslateY()) {
            hashCode = (int)((double)hashCode + 313.0 * this.getTranslateY());
        }
        if (this.isSetTranslateZ()) {
            hashCode = (int)((double)hashCode + 313.0 * this.getTranslateZ());
        }
        return hashCode;
    }

    @Override
    public Map<String, String> writeXMLAttributes() {
        Map<String, String> attributes = super.writeXMLAttributes();
        if (this.isSetTranslateX()) {
            attributes.remove("translateX");
            attributes.put("spatial:translateX", String.valueOf(this.getTranslateX()));
        }
        if (this.isSetTranslateY()) {
            attributes.remove("translateY");
            attributes.put("spatial:translateY", String.valueOf(this.getTranslateY()));
        }
        if (this.isSetTranslateZ()) {
            attributes.remove("translateZ");
            attributes.put("spatial:translateZ", String.valueOf(this.getTranslateZ()));
        }
        return attributes;
    }

    @Override
    public boolean readAttribute(String attributeName, String prefix, String value) {
        boolean isAttributeRead;
        boolean bl = isAttributeRead = super.readAttribute(attributeName, prefix, value) && "spatial" == prefix;
        if (!isAttributeRead) {
            isAttributeRead = true;
            if (attributeName.equals("translateX")) {
                try {
                    this.setTranslateX(StringTools.parseSBMLInt((String)value));
                }
                catch (Exception e) {
                    MessageFormat.format(SpatialConstants.bundle.getString("COULD_NOT_READ"), value, "translateX");
                }
            } else if (attributeName.equals("translateY")) {
                try {
                    this.setTranslateY(StringTools.parseSBMLInt((String)value));
                }
                catch (Exception e) {
                    MessageFormat.format(SpatialConstants.bundle.getString("COULD_NOT_READ"), value, "translateY");
                }
            } else if (attributeName.equals("translateZ")) {
                try {
                    this.setTranslateZ(StringTools.parseSBMLInt((String)value));
                }
                catch (Exception e) {
                    MessageFormat.format(SpatialConstants.bundle.getString("COULD_NOT_READ"), value, "translateZ");
                }
            } else {
                isAttributeRead = false;
            }
        }
        return isAttributeRead;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CSGTranslation [translateX=");
        builder.append(this.translateX);
        builder.append(", translateY=");
        builder.append(this.translateY);
        builder.append(", translateZ=");
        builder.append(this.translateZ);
        builder.append("]");
        return builder.toString();
    }
}

