/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.spatial;

import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.SBMLException;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.spatial.CSGObject;
import org.sbml.jsbml.ext.spatial.GeometryDefinition;

public class CSGeometry
extends GeometryDefinition {
    private static final long serialVersionUID = -3162376343741365280L;
    private ListOf<CSGObject> listOfCSGObjects;

    public CSGeometry() {
    }

    public CSGeometry(CSGeometry csg) {
        super(csg);
        if (csg.isSetListOfCSGObjects()) {
            this.setListOfCSGObjects((ListOf<CSGObject>)csg.getListOfCSGObjects().clone());
        }
    }

    public CSGeometry(int level, int version) {
        super(level, version);
    }

    public CSGeometry(String id, int level, int version) {
        super(id, level, version);
    }

    public CSGeometry clone() {
        return new CSGeometry(this);
    }

    @Override
    public boolean equals(Object object) {
        CSGeometry csg;
        boolean equal = super.equals(object);
        if (equal && (equal &= (csg = (CSGeometry)object).isSetListOfCSGObjects() == this.isSetListOfCSGObjects()) && this.isSetListOfCSGObjects()) {
            equal &= csg.getListOfCSGObjects().equals(this.getListOfCSGObjects());
        }
        return equal;
    }

    public boolean isSetListOfCSGObjects() {
        return this.listOfCSGObjects != null && !this.listOfCSGObjects.isEmpty();
    }

    public ListOf<CSGObject> getListOfCSGObjects() {
        if (!this.isSetListOfCSGObjects()) {
            this.listOfCSGObjects = new ListOf(this.getLevel(), this.getVersion());
            this.listOfCSGObjects.setNamespace("http://www.sbml.org/sbml/level3/version1/spatial/version1");
            this.listOfCSGObjects.setSBaseListType(ListOf.Type.other);
            this.registerChild((SBase)this.listOfCSGObjects);
        }
        return this.listOfCSGObjects;
    }

    public void setListOfCSGObjects(ListOf<CSGObject> listOfCSGObjects) {
        this.unsetListOfCSGObjects();
        this.listOfCSGObjects = listOfCSGObjects;
        this.registerChild((SBase)this.listOfCSGObjects);
    }

    public boolean unsetListOfCSGObjects() {
        if (this.isSetListOfCSGObjects()) {
            ListOf<CSGObject> oldCSGObjects = this.listOfCSGObjects;
            this.listOfCSGObjects = null;
            oldCSGObjects.fireNodeRemovedEvent();
            return true;
        }
        return false;
    }

    public boolean addCSGObject(CSGObject csgo) {
        return this.getListOfCSGObjects().add((SBase)csgo);
    }

    public boolean removeCSGObject(CSGObject csgo) {
        if (this.isSetListOfCSGObjects()) {
            if (this.getListOfCSGObjects().size() == 1) {
                return false;
            }
            return this.getListOfCSGObjects().remove((Object)csgo);
        }
        return false;
    }

    public void removeCSGObject(int i) {
        if (!this.isSetListOfCSGObjects()) {
            throw new IndexOutOfBoundsException(Integer.toString(i));
        }
        if (this.getListOfCSGObjects().size() == 1) {
            throw new SBMLException("There must be at least one AnalyticVolume defined for this list");
        }
        this.getListOfCSGObjects().remove(i);
    }

    public CSGObject createCSGObject() {
        return this.createCSGObject(null);
    }

    public CSGObject createCSGObject(String id) {
        CSGObject csgo = new CSGObject(id, this.getLevel(), this.getVersion());
        this.addCSGObject(csgo);
        return csgo;
    }
}

