/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.spatial;

import java.util.Map;
import org.sbml.jsbml.Compartment;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.PropertyUndefinedError;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.spatial.AbstractSpatialNamedSBase;
import org.sbml.jsbml.ext.spatial.DomainType;
import org.sbml.jsbml.ext.spatial.SpatialModelPlugin;
import org.sbml.jsbml.util.StringTools;

public class CompartmentMapping
extends AbstractSpatialNamedSBase {
    private static final long serialVersionUID = -4623759168043277022L;
    private String compartment;
    private String domainType;
    private Double unitSize;

    public CompartmentMapping() {
    }

    public CompartmentMapping(CompartmentMapping cm) {
        super(cm);
        if (cm.isSetCompartment()) {
            this.compartment = new String(cm.getCompartment());
        }
        if (cm.isSetDomainType()) {
            this.domainType = new String(cm.getDomainType());
        }
        if (cm.isSetUnitSize()) {
            this.unitSize = new Double(cm.getUnitSize());
        }
    }

    public CompartmentMapping(int level, int version) {
        super(level, version);
    }

    public CompartmentMapping(String id, int level, int version) {
        super(id, level, version);
    }

    public CompartmentMapping clone() {
        return new CompartmentMapping(this);
    }

    @Override
    public boolean equals(Object object) {
        boolean equal = super.equals(object);
        if (equal) {
            CompartmentMapping cm = (CompartmentMapping)object;
            if ((equal &= cm.isSetCompartment() == this.isSetCompartment()) && this.isSetCompartment()) {
                equal &= cm.getCompartment().equals(this.getCompartment());
            }
            if ((equal &= cm.isSetDomainType() == this.isSetDomainType()) && this.isSetDomainType()) {
                equal &= cm.getDomainType().equals(this.getDomainType());
            }
            if ((equal &= cm.isSetUnitSize() == this.isSetUnitSize()) && this.isSetUnitSize()) {
                equal &= cm.getUnitSize() == this.getUnitSize();
            }
        }
        return equal;
    }

    public String getCompartment() {
        if (this.isSetCompartment()) {
            return this.compartment;
        }
        throw new PropertyUndefinedError("compartment", (SBase)this);
    }

    public boolean isSetCompartment() {
        return this.compartment != null;
    }

    public void setCompartment(String compartment) {
        String oldCompartment = this.compartment;
        this.compartment = compartment;
        this.firePropertyChange("compartment", oldCompartment, this.compartment);
    }

    public boolean unsetCompartment() {
        if (this.isSetCompartment()) {
            String oldCompartment = this.compartment;
            this.compartment = null;
            this.firePropertyChange("compartment", oldCompartment, this.compartment);
            return true;
        }
        return false;
    }

    public String getDomainType() {
        if (this.isSetDomainType()) {
            return this.domainType;
        }
        throw new PropertyUndefinedError("domainType", (SBase)this);
    }

    public boolean isSetDomainType() {
        return this.domainType != null;
    }

    public void setDomainType(String domainType) {
        String oldDomainType = this.domainType;
        this.domainType = domainType;
        this.firePropertyChange("domainType", oldDomainType, this.domainType);
    }

    public boolean unsetDomainType() {
        if (this.isSetDomainType()) {
            String oldDomainType = this.domainType;
            this.domainType = null;
            this.firePropertyChange("domainType", oldDomainType, this.domainType);
            return true;
        }
        return false;
    }

    public double getUnitSize() {
        if (this.isSetUnitSize()) {
            return this.unitSize;
        }
        throw new PropertyUndefinedError("unitSize", (SBase)this);
    }

    public boolean isSetUnitSize() {
        return this.unitSize != null;
    }

    public void setUnitSize(double unitSize) {
        Double oldUnitSize = this.unitSize;
        this.unitSize = unitSize;
        this.firePropertyChange("unitSize", oldUnitSize, this.unitSize);
    }

    public boolean unsetUnitSize() {
        if (this.isSetUnitSize()) {
            double oldUnitSize = this.unitSize;
            this.unitSize = null;
            this.firePropertyChange("unitSize", oldUnitSize, this.unitSize);
            return true;
        }
        return false;
    }

    public Compartment getCompartmentInstance() {
        Model m = this.getModel();
        return m != null ? m.getCompartment(this.getCompartment()) : null;
    }

    public DomainType getDomainTypeInstance() {
        Model m = this.getModel();
        if (m != null) {
            SpatialModelPlugin sm = (SpatialModelPlugin)m.getExtension(this.getCompartmentInstance().getElementName());
            sm.getGeometry().getListOfDomainTypes().get(this.getDomainType());
        }
        return null;
    }

    @Override
    public int hashCode() {
        int prime = 983;
        int hashCode = super.hashCode();
        if (this.isSetCompartment()) {
            hashCode += 983 * this.getCompartment().hashCode();
        }
        if (this.isSetDomainType()) {
            hashCode += 983 * this.getDomainType().hashCode();
        }
        if (this.isSetUnitSize()) {
            hashCode = (int)((double)hashCode + 983.0 * this.getUnitSize());
        }
        return hashCode;
    }

    @Override
    public Map<String, String> writeXMLAttributes() {
        Map<String, String> attributes = super.writeXMLAttributes();
        if (this.isSetCompartment()) {
            attributes.remove("compartment");
            attributes.put("spatial:compartment", this.getCompartment());
        }
        if (this.isSetDomainType()) {
            attributes.remove("domainType");
            attributes.put("spatial:domainType", this.getDomainType());
        }
        if (this.isSetUnitSize()) {
            attributes.remove("unitSize");
            attributes.put("spatial:unitSize", String.valueOf(this.getUnitSize()));
        }
        return attributes;
    }

    @Override
    public boolean readAttribute(String attributeName, String prefix, String value) {
        boolean isAttributeRead;
        boolean bl = isAttributeRead = super.readAttribute(attributeName, prefix, value) && "spatial" == prefix;
        if (!isAttributeRead) {
            isAttributeRead = true;
            if (attributeName.equals("compartment")) {
                this.setCompartment(value);
            } else if (attributeName.equals("domainType")) {
                this.setDomainType(value);
            } else if (attributeName.equals("unitSize")) {
                this.setUnitSize(StringTools.parseSBMLDouble((String)value));
            } else {
                isAttributeRead = false;
            }
        }
        return isAttributeRead;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CompartmentMapping [compartment=");
        builder.append(this.compartment);
        builder.append(", domainType=");
        builder.append(this.domainType);
        builder.append(", unitSize=");
        builder.append(this.unitSize);
        builder.append("]");
        return builder.toString();
    }
}

