/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.spatial;

import java.text.MessageFormat;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.tree.TreeNode;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.PropertyUndefinedError;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.SBaseWithUnit;
import org.sbml.jsbml.Unit;
import org.sbml.jsbml.UnitDefinition;
import org.sbml.jsbml.ext.spatial.AbstractSpatialNamedSBase;
import org.sbml.jsbml.ext.spatial.Boundary;
import org.sbml.jsbml.ext.spatial.CoordinateKind;
import org.sbml.jsbml.util.ResourceManager;

public class CoordinateComponent
extends AbstractSpatialNamedSBase
implements SBaseWithUnit {
    private static final long serialVersionUID = -3561130269969678307L;
    private CoordinateKind type;
    private Boundary boundaryMaximum;
    private Boundary boundaryMinimum;
    private String unit;
    private static final ResourceBundle bundle = ResourceManager.getBundle((String)"org.sbml.jsbml.ext.spatial.Messages");

    public CoordinateComponent() {
    }

    public CoordinateComponent(CoordinateComponent coordComp) {
        super(coordComp);
        if (coordComp.isSetType()) {
            this.type = coordComp.getType();
        }
        if (coordComp.isSetUnits()) {
            this.unit = new String(coordComp.getUnits());
        }
        if (coordComp.isSetBoundaryMinimum()) {
            this.setBoundaryMinimum(coordComp.getBoundaryMinimum().clone());
        }
        if (coordComp.isSetBoundaryMaximum()) {
            this.setBoundaryMaximum(coordComp.getBoundaryMaximum().clone());
        }
    }

    public CoordinateComponent(int level, int version) {
        super(level, version);
    }

    public CoordinateComponent(String id, int level, int version) {
        super(id, level, version);
    }

    public CoordinateComponent clone() {
        return new CoordinateComponent(this);
    }

    public Boundary getBoundaryMinimum() {
        if (this.isSetBoundaryMinimum()) {
            return this.boundaryMinimum;
        }
        throw new PropertyUndefinedError("boundaryMin", (SBase)this);
    }

    public boolean isSetBoundaryMinimum() {
        return this.boundaryMinimum != null;
    }

    public void setBoundaryMinimum(Boundary boundaryMinimum) {
        Boundary oldMinimum = this.boundaryMinimum;
        this.boundaryMinimum = boundaryMinimum;
        this.firePropertyChange("boundaryMin", oldMinimum, this.boundaryMinimum);
    }

    public boolean unsetBoundaryMinimum() {
        if (this.isSetBoundaryMinimum()) {
            Boundary oldMinimum = this.boundaryMinimum;
            this.boundaryMinimum = null;
            this.firePropertyChange("boundaryMin", oldMinimum, this.boundaryMinimum);
            return true;
        }
        return false;
    }

    public Boundary getBoundaryMaximum() {
        if (this.isSetBoundaryMaximum()) {
            return this.boundaryMaximum;
        }
        throw new PropertyUndefinedError("boundaryMax", (SBase)this);
    }

    public boolean isSetBoundaryMaximum() {
        return this.boundaryMaximum != null;
    }

    public void setBoundaryMaximum(Boundary boundaryMaximum) {
        Boundary oldMaximum = boundaryMaximum;
        this.boundaryMaximum = boundaryMaximum;
        this.firePropertyChange("boundaryMax", oldMaximum, boundaryMaximum);
    }

    public boolean unsetBoundaryMaximum() {
        if (this.isSetBoundaryMaximum()) {
            Boundary oldMaximum = this.boundaryMaximum;
            this.boundaryMaximum = null;
            this.firePropertyChange("boundaryMax", oldMaximum, this.boundaryMaximum);
            return true;
        }
        return false;
    }

    public CoordinateKind getType() {
        if (this.isSetType()) {
            return this.type;
        }
        throw new PropertyUndefinedError("type", (SBase)this);
    }

    public boolean isSetType() {
        return this.type != null;
    }

    public void setType(CoordinateKind type) {
        CoordinateKind oldType = this.type;
        this.type = type;
        this.firePropertyChange("type", (Object)oldType, (Object)this.type);
    }

    public boolean unsetType() {
        if (this.isSetType()) {
            CoordinateKind oldType = this.type;
            this.type = null;
            this.firePropertyChange("type", (Object)oldType, (Object)this.type);
            return true;
        }
        return false;
    }

    public boolean containsUndeclaredUnits() {
        return !this.isSetUnits();
    }

    @Override
    public boolean equals(Object object) {
        boolean equal = super.equals(object);
        if (equal) {
            CoordinateComponent cc = (CoordinateComponent)object;
            if ((equal &= cc.isSetType() == this.isSetType()) && this.isSetType()) {
                equal &= cc.getType().equals((Object)this.getType());
            }
            if ((equal &= cc.isSetBoundaryMinimum() == this.isSetBoundaryMinimum()) && this.isSetBoundaryMinimum()) {
                equal &= cc.getBoundaryMinimum().equals(this.getBoundaryMinimum());
            }
            if ((equal &= cc.isSetBoundaryMaximum() == this.isSetBoundaryMaximum()) && this.isSetBoundaryMaximum()) {
                equal &= cc.getBoundaryMaximum().equals(this.getBoundaryMaximum());
            }
            if ((equal &= cc.isSetUnits() == this.isSetUnits()) && this.isSetUnits()) {
                equal &= cc.getUnits().equals(this.getUnits());
            }
        }
        return equal;
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        if (childIndex < 0) {
            throw new IndexOutOfBoundsException(childIndex + " < 0");
        }
        int pos = 0;
        if (this.isSetBoundaryMinimum()) {
            if (childIndex == pos) {
                return this.getBoundaryMinimum();
            }
            ++pos;
        }
        if (this.isSetBoundaryMaximum()) {
            if (childIndex == pos) {
                return this.getBoundaryMaximum();
            }
            ++pos;
        }
        throw new IndexOutOfBoundsException(this.isLeaf() ? MessageFormat.format("Node {0} has no children.", this.getElementName()) : MessageFormat.format("Index {0,number,integer} >= {1,number,integer}", childIndex, Math.min(pos, 0)));
    }

    @Override
    public int getChildCount() {
        int childCount = super.getChildCount();
        if (this.isSetBoundaryMinimum()) {
            ++childCount;
        }
        if (this.isSetBoundaryMaximum()) {
            ++childCount;
        }
        return childCount;
    }

    public String getUnits() {
        if (this.isSetUnits()) {
            return this.unit;
        }
        Model model = this.getModel();
        if (model.isSetLengthUnits()) {
            this.unit = model.getLengthUnits();
        }
        throw new PropertyUndefinedError("unit", (SBase)this);
    }

    public boolean isSetUnits() {
        return this.unit != null;
    }

    public void setUnits(String unit) {
        String oldUnits = this.unit;
        this.unit = unit;
        this.firePropertyChange("unit", oldUnits, this.unit);
    }

    public void unsetUnits() {
        if (this.isSetUnits()) {
            String oldUnits = this.unit;
            this.unit = null;
            this.firePropertyChange("unit", oldUnits, this.unit);
        }
    }

    public UnitDefinition getDerivedUnitDefinition() {
        if (this.isSetUnits()) {
            return this.getUnitsInstance();
        }
        return null;
    }

    public String getDerivedUnits() {
        return this.getUnits();
    }

    public UnitDefinition getUnitsInstance() {
        Model model = this.getModel();
        return model != null ? model.getUnitDefinition(this.getUnits()) : null;
    }

    @Override
    public int hashCode() {
        int prime = 947;
        int hashCode = super.hashCode();
        if (this.isSetType()) {
            hashCode += 947 * this.getType().hashCode();
        }
        if (this.isSetUnits()) {
            hashCode += 947 * this.getUnits().hashCode();
        }
        return hashCode;
    }

    public boolean isSetUnitsInstance() {
        Model model = this.getModel();
        return model != null ? model.containsUnitDefinition(this.getUnits()) : false;
    }

    public void setUnits(Unit.Kind unitKind) {
        this.setUnits(unitKind.toString());
    }

    public void setUnits(Unit unit) {
        this.unit = unit.toString();
    }

    public void setUnits(UnitDefinition units) {
        if (units.isSetId()) {
            this.setUnits(units.getId());
        }
    }

    @Override
    public Map<String, String> writeXMLAttributes() {
        Map<String, String> attributes = super.writeXMLAttributes();
        if (this.isSetType()) {
            attributes.remove("type");
            attributes.put("spatial:type", String.valueOf((Object)this.getType()));
        }
        if (this.isSetUnits()) {
            attributes.remove("unit");
            attributes.put("spatial:unit", this.getUnits());
        }
        return attributes;
    }

    @Override
    public boolean readAttribute(String attributeName, String prefix, String value) {
        boolean isAttributeRead = super.readAttribute(attributeName, prefix, value);
        if (!isAttributeRead) {
            isAttributeRead = true;
            if (attributeName.equals("type")) {
                try {
                    this.setType(CoordinateKind.valueOf(value));
                }
                catch (Exception e) {
                    MessageFormat.format(bundle.getString("COULD_NOT_READ"), value, "type");
                }
            } else if (attributeName.equals("unit")) {
                try {
                    this.setUnits(value);
                }
                catch (Exception e) {
                    MessageFormat.format(bundle.getString("COULD_NOT_READ"), value, "unit");
                }
            } else {
                isAttributeRead = false;
            }
        }
        return isAttributeRead;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CoordinateComponent [componentType=");
        builder.append((Object)this.type);
        builder.append(", type=");
        builder.append((Object)this.type);
        builder.append(", boundaryMaximum=");
        builder.append(this.boundaryMaximum);
        builder.append(", boundaryMinimum=");
        builder.append(this.boundaryMinimum);
        builder.append(", unit=");
        builder.append(this.unit);
        builder.append("]");
        return builder.toString();
    }
}

