/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.spatial;

import java.text.MessageFormat;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.tree.TreeNode;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.PropertyUndefinedError;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.spatial.AbstractSpatialNamedSBase;
import org.sbml.jsbml.ext.spatial.AdjacentDomains;
import org.sbml.jsbml.ext.spatial.AnalyticGeometry;
import org.sbml.jsbml.ext.spatial.CSGeometry;
import org.sbml.jsbml.ext.spatial.CoordinateComponent;
import org.sbml.jsbml.ext.spatial.Domain;
import org.sbml.jsbml.ext.spatial.DomainType;
import org.sbml.jsbml.ext.spatial.GeometryDefinition;
import org.sbml.jsbml.ext.spatial.MixedGeometry;
import org.sbml.jsbml.ext.spatial.ParametricGeometry;
import org.sbml.jsbml.ext.spatial.SampledField;
import org.sbml.jsbml.ext.spatial.SampledFieldGeometry;
import org.sbml.jsbml.util.ResourceManager;
import org.sbml.jsbml.util.filters.Filter;
import org.sbml.jsbml.util.filters.NameFilter;

public class Geometry
extends AbstractSpatialNamedSBase {
    private static final long serialVersionUID = 9115597691155572976L;
    private ListOf<CoordinateComponent> listOfCoordinateComponents;
    private ListOf<DomainType> listOfDomainTypes;
    private ListOf<Domain> listOfDomains;
    private ListOf<AdjacentDomains> listOfAdjacentDomains;
    private ListOf<GeometryDefinition> listOfGeometryDefinitions;
    private ListOf<SampledField> listOfSampledFields;
    private GeometryKind coordinateSystem;
    private static final ResourceBundle bundle = ResourceManager.getBundle((String)"org.sbml.jsbml.ext.spatial.Messages");

    public Geometry() {
    }

    public Geometry(Geometry sb) {
        super(sb);
        if (sb.isSetCoordinateSystem()) {
            this.setCoordinateSystem(sb.getCoordinateSystem());
        }
        if (sb.isSetListOfAdjacentDomains()) {
            this.setListOfAdjacentDomains((ListOf<AdjacentDomains>)sb.getListOfAdjacentDomains().clone());
        }
        if (sb.isSetListOfDomains()) {
            this.setListOfDomains((ListOf<Domain>)sb.getListOfDomains().clone());
        }
        if (sb.isSetListOfDomainTypes()) {
            this.setListOfDomainTypes((ListOf<DomainType>)sb.getListOfDomainTypes().clone());
        }
        if (sb.isSetListOfGeometryDefinitions()) {
            this.setListOfGeometryDefinitions((ListOf<GeometryDefinition>)sb.getListOfGeometryDefinitions().clone());
        }
        if (sb.isSetListOfSampledFields()) {
            this.setListOfSampledFields((ListOf<SampledField>)sb.getListOfSampledFields().clone());
        }
    }

    public Geometry(String id, int level, int version) {
        super(id, level, version);
    }

    public Geometry(int level, int version) {
        super(level, version);
    }

    public Geometry clone() {
        return new Geometry(this);
    }

    @Override
    public boolean equals(Object object) {
        boolean equal = super.equals(object);
        if (equal) {
            Geometry gm = (Geometry)object;
            if ((equal &= gm.isSetCoordinateSystem() == this.isSetCoordinateSystem()) && this.isSetCoordinateSystem()) {
                equal &= gm.getCoordinateSystem().equals((Object)this.getCoordinateSystem());
            }
            if ((equal &= gm.isSetListOfAdjacentDomains() == this.isSetListOfAdjacentDomains()) && this.isSetListOfAdjacentDomains()) {
                equal &= gm.getListOfAdjacentDomains().equals(this.getListOfAdjacentDomains());
            }
            if ((equal &= gm.isSetListOfCoordinateComponents() == this.isSetListOfCoordinateComponents()) && this.isSetListOfCoordinateComponents()) {
                equal &= gm.getListOfCoordinateComponents().equals(this.getListOfCoordinateComponents());
            }
            if ((equal &= gm.isSetListOfDomains() == this.isSetListOfDomains()) && this.isSetListOfDomains()) {
                equal &= gm.getListOfDomains().equals(this.getListOfDomains());
            }
            if ((equal &= gm.isSetListOfDomainTypes() == this.isSetListOfDomainTypes()) && this.isSetListOfDomainTypes()) {
                equal &= gm.getListOfDomainTypes().equals(this.getListOfDomainTypes());
            }
            if ((equal &= gm.isSetListOfGeometryDefinitions() == this.isSetListOfGeometryDefinitions()) && this.isSetListOfGeometryDefinitions()) {
                equal &= gm.getListOfGeometryDefinitions().equals(this.getListOfGeometryDefinitions());
            }
            if ((equal &= gm.isSetListOfSampledFields() == this.isSetListOfSampledFields()) && this.isSetListOfSampledFields()) {
                equal &= gm.getListOfSampledFields() == this.getListOfSampledFields();
            }
        }
        return equal;
    }

    public GeometryKind getCoordinateSystem() {
        if (this.isSetCoordinateSystem()) {
            return this.coordinateSystem;
        }
        throw new PropertyUndefinedError("coordinateSystem", (SBase)this);
    }

    public boolean isSetCoordinateSystem() {
        return this.coordinateSystem != null;
    }

    public void setCoordinateSystem(GeometryKind coordinateSystem) {
        GeometryKind oldCoordinateSystem = this.coordinateSystem;
        this.coordinateSystem = coordinateSystem;
        this.firePropertyChange("coordinateSystem", (Object)oldCoordinateSystem, (Object)this.coordinateSystem);
    }

    public boolean unsetCoordinateSystem() {
        if (this.isSetCoordinateSystem()) {
            GeometryKind oldCoordinateSystem = this.coordinateSystem;
            this.coordinateSystem = null;
            this.firePropertyChange("coordinateSystem", (Object)oldCoordinateSystem, (Object)this.coordinateSystem);
            return true;
        }
        return false;
    }

    public boolean isSetListOfSampledFields() {
        return this.listOfSampledFields != null && !this.listOfSampledFields.isEmpty();
    }

    public ListOf<SampledField> getListOfSampledFields() {
        if (!this.isSetListOfSampledFields()) {
            this.listOfSampledFields = new ListOf(this.getLevel(), this.getVersion());
            this.listOfSampledFields.setNamespace("http://www.sbml.org/sbml/level3/version1/spatial/version1");
            this.listOfSampledFields.setSBaseListType(ListOf.Type.other);
            this.registerChild((SBase)this.listOfSampledFields);
        }
        return this.listOfSampledFields;
    }

    public void setListOfSampledFields(ListOf<SampledField> listOfSampledFields) {
        this.unsetListOfSampledFields();
        this.listOfSampledFields = listOfSampledFields;
        this.registerChild((SBase)this.listOfSampledFields);
    }

    public boolean unsetListOfSampledFields() {
        if (this.isSetListOfSampledFields()) {
            ListOf<SampledField> oldSampledFields = this.listOfSampledFields;
            this.listOfSampledFields = null;
            oldSampledFields.fireNodeRemovedEvent();
            return true;
        }
        return false;
    }

    public boolean addSampledField(SampledField sampledField) {
        return this.getListOfSampledFields().add((SBase)sampledField);
    }

    public boolean removeSampledField(SampledField sampledField) {
        if (this.isSetListOfSampledFields()) {
            return this.getListOfSampledFields().remove((Object)sampledField);
        }
        return false;
    }

    public void removeSampledField(int i) {
        if (!this.isSetListOfSampledFields()) {
            throw new IndexOutOfBoundsException(Integer.toString(i));
        }
        this.getListOfSampledFields().remove(i);
    }

    public void removeSampledField(String id) {
        this.getListOfSampledFields().removeFirst((Filter)new NameFilter(id));
    }

    public SampledField createSampledField() {
        return this.createSampledField(null);
    }

    public SampledField createSampledField(String id) {
        SampledField sampledField = new SampledField(id, this.getLevel(), this.getVersion());
        this.addSampledField(sampledField);
        return sampledField;
    }

    public boolean isSetListOfGeometryDefinitions() {
        return this.listOfGeometryDefinitions != null && !this.listOfGeometryDefinitions.isEmpty();
    }

    public ListOf<GeometryDefinition> getListOfGeometryDefinitions() {
        if (!this.isSetListOfGeometryDefinitions()) {
            this.listOfGeometryDefinitions = new ListOf();
            this.listOfGeometryDefinitions.setNamespace("http://www.sbml.org/sbml/level3/version1/spatial/version1");
            this.listOfGeometryDefinitions.setSBaseListType(ListOf.Type.other);
            this.registerChild((SBase)this.listOfGeometryDefinitions);
        }
        return this.listOfGeometryDefinitions;
    }

    public void setListOfGeometryDefinitions(ListOf<GeometryDefinition> listOfGeometryDefinitions) {
        this.unsetListOfGeometryDefinitions();
        this.listOfGeometryDefinitions = listOfGeometryDefinitions;
        this.registerChild((SBase)this.listOfGeometryDefinitions);
    }

    public boolean unsetListOfGeometryDefinitions() {
        if (this.isSetListOfGeometryDefinitions()) {
            ListOf<GeometryDefinition> oldGeometryDefinitions = this.listOfGeometryDefinitions;
            this.listOfGeometryDefinitions = null;
            oldGeometryDefinitions.fireNodeRemovedEvent();
            return true;
        }
        return false;
    }

    public boolean addGeometryDefinition(GeometryDefinition geometryDefinition) {
        return this.getListOfGeometryDefinitions().add((SBase)geometryDefinition);
    }

    public boolean removeGeometryDefinition(GeometryDefinition geometryDefinition) {
        if (this.isSetListOfGeometryDefinitions()) {
            return this.getListOfGeometryDefinitions().remove((Object)geometryDefinition);
        }
        return false;
    }

    public void removeGeometryDefinition(int i) {
        if (!this.isSetListOfGeometryDefinitions()) {
            throw new IndexOutOfBoundsException(Integer.toString(i));
        }
        this.getListOfGeometryDefinitions().remove(i);
    }

    public void removeGeometryDefinition(String id) {
        this.getListOfGeometryDefinitions().removeFirst((Filter)new NameFilter(id));
    }

    public SampledFieldGeometry createSampledFieldGeometryn() {
        return this.createSampledFieldGeometry(null);
    }

    public AnalyticGeometry createAnalyticGeometry() {
        return this.createAnalyticGeometry(null);
    }

    public CSGeometry createCSGeometry() {
        return this.createCSGeometry(null);
    }

    public ParametricGeometry createParametricGeometry() {
        return this.createParametricGeometry(null);
    }

    public MixedGeometry createMixedGeometry() {
        return this.createMixedGeometry(null);
    }

    public MixedGeometry createMixedGeometry(String id) {
        MixedGeometry def = new MixedGeometry(id, this.getLevel(), this.getVersion());
        this.addGeometryDefinition(def);
        return def;
    }

    public SampledFieldGeometry createSampledFieldGeometry(String id) {
        SampledFieldGeometry def = new SampledFieldGeometry(id, this.getLevel(), this.getVersion());
        this.addGeometryDefinition(def);
        return def;
    }

    public AnalyticGeometry createAnalyticGeometry(String id) {
        AnalyticGeometry def = new AnalyticGeometry(id, this.getLevel(), this.getVersion());
        this.addGeometryDefinition(def);
        return def;
    }

    public CSGeometry createCSGeometry(String id) {
        CSGeometry def = new CSGeometry(id, this.getLevel(), this.getVersion());
        this.addGeometryDefinition(def);
        return def;
    }

    public ParametricGeometry createParametricGeometry(String id) {
        ParametricGeometry def = new ParametricGeometry(id, this.getLevel(), this.getVersion());
        this.addGeometryDefinition(def);
        return def;
    }

    public boolean isSetListOfAdjacentDomains() {
        return this.listOfAdjacentDomains != null && !this.listOfAdjacentDomains.isEmpty();
    }

    public ListOf<AdjacentDomains> getListOfAdjacentDomains() {
        if (!this.isSetListOfAdjacentDomains()) {
            this.listOfAdjacentDomains = new ListOf();
            this.listOfAdjacentDomains.setNamespace("http://www.sbml.org/sbml/level3/version1/spatial/version1");
            this.listOfAdjacentDomains.setSBaseListType(ListOf.Type.other);
            this.registerChild((SBase)this.listOfAdjacentDomains);
        }
        return this.listOfAdjacentDomains;
    }

    public void setListOfAdjacentDomains(ListOf<AdjacentDomains> listOfAdjacentDomains) {
        this.unsetListOfAdjacentDomains();
        this.listOfAdjacentDomains = listOfAdjacentDomains;
        this.registerChild((SBase)this.listOfAdjacentDomains);
    }

    public boolean unsetListOfAdjacentDomains() {
        if (this.isSetListOfAdjacentDomains()) {
            ListOf<AdjacentDomains> oldAdjacentDomains = this.listOfAdjacentDomains;
            this.listOfAdjacentDomains = null;
            oldAdjacentDomains.fireNodeRemovedEvent();
            return true;
        }
        return false;
    }

    public boolean addAdjacentDomain(AdjacentDomains adjacentDomains) {
        return this.getListOfAdjacentDomains().add((SBase)adjacentDomains);
    }

    public boolean removeAdjacentDomain(AdjacentDomains adjacentDomains) {
        if (this.isSetListOfAdjacentDomains()) {
            return this.getListOfAdjacentDomains().remove((Object)adjacentDomains);
        }
        return false;
    }

    public void removeAdjacentDomain(int i) {
        if (!this.isSetListOfAdjacentDomains()) {
            throw new IndexOutOfBoundsException(Integer.toString(i));
        }
        this.getListOfAdjacentDomains().remove(i);
    }

    public void removeAdjacentDomain(String id) {
        this.getListOfAdjacentDomains().removeFirst((Filter)new NameFilter(id));
    }

    public AdjacentDomains createAdjacentDomain() {
        return this.createAdjacentDomain(null);
    }

    public AdjacentDomains createAdjacentDomain(String id) {
        AdjacentDomains adjacentDomains = new AdjacentDomains(id, this.getLevel(), this.getVersion());
        this.addAdjacentDomain(adjacentDomains);
        return adjacentDomains;
    }

    public boolean isSetListOfDomainTypes() {
        return this.listOfDomainTypes != null && !this.listOfDomainTypes.isEmpty();
    }

    public ListOf<DomainType> getListOfDomainTypes() {
        if (!this.isSetListOfDomainTypes()) {
            this.listOfDomainTypes = new ListOf();
            this.listOfDomainTypes.setNamespace("http://www.sbml.org/sbml/level3/version1/spatial/version1");
            this.listOfDomainTypes.setSBaseListType(ListOf.Type.other);
            this.registerChild((SBase)this.listOfDomainTypes);
        }
        return this.listOfDomainTypes;
    }

    public void setListOfDomainTypes(ListOf<DomainType> listOfDomainTypes) {
        this.unsetListOfDomainTypes();
        this.listOfDomainTypes = listOfDomainTypes;
        this.registerChild((SBase)this.listOfDomainTypes);
    }

    public boolean unsetListOfDomainTypes() {
        if (this.isSetListOfDomainTypes()) {
            ListOf<DomainType> oldDomainTypes = this.listOfDomainTypes;
            this.listOfDomainTypes = null;
            oldDomainTypes.fireNodeRemovedEvent();
            return true;
        }
        return false;
    }

    public boolean addDomainType(DomainType domainType) {
        return this.getListOfDomainTypes().add((SBase)domainType);
    }

    public boolean removeDomainType(DomainType domainType) {
        if (this.isSetListOfDomainTypes()) {
            return this.getListOfDomainTypes().remove((Object)domainType);
        }
        return false;
    }

    public void removeDomainType(int i) {
        if (!this.isSetListOfDomainTypes()) {
            throw new IndexOutOfBoundsException(Integer.toString(i));
        }
        this.getListOfDomainTypes().remove(i);
    }

    public void removeDomainType(String id) {
        this.getListOfDomainTypes().removeFirst((Filter)new NameFilter(id));
    }

    public DomainType createDomainType() {
        return this.createDomainType(null);
    }

    public DomainType createDomainType(String id) {
        DomainType domainType = new DomainType(id, this.getLevel(), this.getVersion());
        this.addDomainType(domainType);
        return domainType;
    }

    public boolean isSetListOfDomains() {
        return this.listOfDomains != null && !this.listOfDomains.isEmpty();
    }

    public ListOf<Domain> getListOfDomains() {
        if (!this.isSetListOfDomains()) {
            this.listOfDomains = new ListOf();
            this.listOfDomains.setNamespace("http://www.sbml.org/sbml/level3/version1/spatial/version1");
            this.listOfDomains.setSBaseListType(ListOf.Type.other);
            this.registerChild((SBase)this.listOfDomains);
        }
        return this.listOfDomains;
    }

    public void setListOfDomains(ListOf<Domain> listOfDomains) {
        this.unsetListOfDomains();
        this.listOfDomains = listOfDomains;
        this.registerChild((SBase)this.listOfDomains);
    }

    public boolean unsetListOfDomains() {
        if (this.isSetListOfDomains()) {
            ListOf<Domain> oldDomains = this.listOfDomains;
            this.listOfDomains = null;
            oldDomains.fireNodeRemovedEvent();
            return true;
        }
        return false;
    }

    public boolean addDomain(Domain domain) {
        return this.getListOfDomains().add((SBase)domain);
    }

    public boolean removeDomain(Domain domain) {
        if (this.isSetListOfDomains()) {
            return this.getListOfDomains().remove((Object)domain);
        }
        return false;
    }

    public void removeDomain(int i) {
        if (!this.isSetListOfDomains()) {
            throw new IndexOutOfBoundsException(Integer.toString(i));
        }
        this.getListOfDomains().remove(i);
    }

    public void removeDomain(String id) {
        this.getListOfDomains().removeFirst((Filter)new NameFilter(id));
    }

    public Domain createDomain() {
        return this.createDomain(null);
    }

    public Domain createDomain(String id) {
        Domain domain = new Domain(id, this.getLevel(), this.getVersion());
        this.addDomain(domain);
        return domain;
    }

    public boolean isSetListOfCoordinateComponents() {
        return this.listOfCoordinateComponents != null && !this.listOfCoordinateComponents.isEmpty();
    }

    public ListOf<CoordinateComponent> getListOfCoordinateComponents() {
        if (!this.isSetListOfCoordinateComponents()) {
            this.listOfCoordinateComponents = new ListOf();
            this.listOfCoordinateComponents.setNamespace("http://www.sbml.org/sbml/level3/version1/spatial/version1");
            this.listOfCoordinateComponents.setSBaseListType(ListOf.Type.other);
            this.registerChild((SBase)this.listOfCoordinateComponents);
        }
        return this.listOfCoordinateComponents;
    }

    public void setListOfCoordinateComponents(ListOf<CoordinateComponent> listOfCoordinateComponents) {
        this.unsetListOfCoordinateComponents();
        this.listOfCoordinateComponents = listOfCoordinateComponents;
        this.registerChild((SBase)this.listOfCoordinateComponents);
    }

    public boolean unsetListOfCoordinateComponents() {
        if (this.isSetListOfCoordinateComponents()) {
            ListOf<CoordinateComponent> oldCoordinateComponents = this.listOfCoordinateComponents;
            this.listOfCoordinateComponents = null;
            oldCoordinateComponents.fireNodeRemovedEvent();
            return true;
        }
        return false;
    }

    public boolean addCoordinateComponent(CoordinateComponent coordinateComponents) {
        return this.getListOfCoordinateComponents().add((SBase)coordinateComponents);
    }

    public boolean removeCoordinateComponent(CoordinateComponent coordinateComponents) {
        if (this.isSetListOfCoordinateComponents()) {
            return this.getListOfCoordinateComponents().remove((Object)coordinateComponents);
        }
        return false;
    }

    public void removeCoordinateComponent(int i) {
        if (!this.isSetListOfCoordinateComponents()) {
            throw new IndexOutOfBoundsException(Integer.toString(i));
        }
        this.getListOfCoordinateComponents().remove(i);
    }

    public void removeCoordinateComponent(String id) {
        this.getListOfCoordinateComponents().removeFirst((Filter)new NameFilter(id));
    }

    public CoordinateComponent createCoordinateComponent() {
        return this.createCoordinateComponent(null);
    }

    public CoordinateComponent createCoordinateComponent(String id) {
        CoordinateComponent coordinateComponents = new CoordinateComponent(id, this.getLevel(), this.getVersion());
        this.addCoordinateComponent(coordinateComponents);
        return coordinateComponents;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Geometry [coordinateSystem=");
        builder.append((Object)this.coordinateSystem);
        builder.append("]");
        return builder.toString();
    }

    @Override
    public boolean readAttribute(String attributeName, String prefix, String value) {
        boolean isAttributeRead = super.readAttribute(attributeName, prefix, value);
        if (!isAttributeRead) {
            isAttributeRead = true;
            if (attributeName.equals("coordinateSystem")) {
                try {
                    this.setCoordinateSystem(GeometryKind.valueOf(value));
                }
                catch (Exception e) {
                    MessageFormat.format(bundle.getString("COULD_NOT_READ"), value, "coordinateSystem");
                }
            } else {
                isAttributeRead = false;
            }
        }
        return isAttributeRead;
    }

    @Override
    public Map<String, String> writeXMLAttributes() {
        Map<String, String> attributes = super.writeXMLAttributes();
        if (this.isSetCoordinateSystem()) {
            attributes.remove("coordinateSystem");
            attributes.put("spatial:coordinateSystem", this.coordinateSystem.toString());
        }
        if (this.isSetSBOTerm()) {
            attributes.remove("sboTerm");
            attributes.put("spatial:sboTerm", this.getSBOTermID());
        }
        if (this.isSetMetaId()) {
            attributes.remove("metaId");
            attributes.put("spatial:metaId", this.getMetaId());
        }
        return attributes;
    }

    @Override
    public int hashCode() {
        int prime = 1103;
        int hashCode = super.hashCode();
        if (this.isSetCoordinateSystem()) {
            hashCode += 1103 * this.coordinateSystem.hashCode();
        }
        return hashCode;
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public int getChildCount() {
        int count = super.getChildCount();
        if (this.isSetListOfAdjacentDomains()) {
            ++count;
        }
        if (this.isSetListOfCoordinateComponents()) {
            ++count;
        }
        if (this.isSetListOfDomains()) {
            ++count;
        }
        if (this.isSetListOfDomainTypes()) {
            ++count;
        }
        if (this.isSetListOfGeometryDefinitions()) {
            ++count;
        }
        if (this.isSetListOfSampledFields()) {
            ++count;
        }
        return count;
    }

    @Override
    public TreeNode getChildAt(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException(index + " < 0");
        }
        int count = super.getChildCount();
        int pos = 0;
        if (index < count) {
            return super.getChildAt(index);
        }
        index -= count;
        if (this.isSetListOfAdjacentDomains()) {
            if (pos == index) {
                return this.getListOfAdjacentDomains();
            }
            ++pos;
        }
        if (this.isSetListOfCoordinateComponents()) {
            if (pos == index) {
                return this.getListOfCoordinateComponents();
            }
            ++pos;
        }
        if (this.isSetListOfDomains()) {
            if (pos == index) {
                return this.getListOfDomains();
            }
            ++pos;
        }
        if (this.isSetListOfDomainTypes()) {
            if (pos == index) {
                return this.getListOfDomainTypes();
            }
            ++pos;
        }
        if (this.isSetListOfGeometryDefinitions()) {
            if (pos == index) {
                return this.getListOfGeometryDefinitions();
            }
            ++pos;
        }
        if (this.isSetListOfSampledFields() && pos == index) {
            return this.getListOfSampledFields();
        }
        throw new IndexOutOfBoundsException(MessageFormat.format("Index {0,number,integer} >= {1,number,integer}", index, Math.min(pos, 0)));
    }

    public static enum GeometryKind {
        CARTESIAN;

    }
}

