/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.spatial;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Map;
import java.util.StringTokenizer;
import org.sbml.jsbml.AbstractSBase;
import org.sbml.jsbml.PropertyUndefinedError;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.spatial.SpatialConstants;
import org.sbml.jsbml.util.StringTools;

public class ImageData
extends AbstractSBase {
    private static final long serialVersionUID = 1872012239027099782L;
    private Integer samplesLength;
    private Integer[] samples;
    private String dataType;

    public ImageData() {
    }

    public ImageData(ImageData im) {
        super((SBase)im);
        if (im.isSetSamples()) {
            this.samples = (Integer[])im.getSamples().clone();
            this.samplesLength = this.samples.length;
        }
        if (im.isSetDataType()) {
            this.dataType = new String(im.getDataType());
        }
    }

    public ImageData(int level, int version) {
        super(level, version);
    }

    public ImageData clone() {
        return new ImageData(this);
    }

    public boolean equals(Object object) {
        boolean equal = super.equals(object);
        if (equal) {
            ImageData im = (ImageData)((Object)object);
            if ((equal &= im.isSetSamples() == this.isSetSamples()) && this.isSetSamples()) {
                equal &= im.getSamples().equals(this.getSamples());
            }
            if ((equal &= im.isSetDataType() == this.isSetDataType()) && this.isSetDataType()) {
                equal &= im.getDataType().equals(this.getDataType());
            }
        }
        return equal;
    }

    public Integer[] getSamples() {
        if (this.isSetSamples()) {
            return this.samples;
        }
        throw new PropertyUndefinedError("samples", (SBase)this);
    }

    public boolean isSetSamples() {
        return this.samples != null;
    }

    public void setSamples(Integer[] samples) {
        Integer[] oldSamples = this.samples;
        this.samples = samples;
        this.samplesLength = samples.length;
        this.firePropertyChange("samples", oldSamples, this.samples);
        this.firePropertyChange("samples", oldSamples.length, this.samplesLength);
    }

    public boolean unsetSamples() {
        if (this.isSetSamples()) {
            Integer[] oldSamples = this.samples;
            this.samples = null;
            this.samplesLength = null;
            this.firePropertyChange("samples", oldSamples, this.samples);
            this.firePropertyChange("samplesLength", oldSamples.length, this.samplesLength);
            return true;
        }
        return false;
    }

    public int getSamplesLength() {
        if (this.isSetSamplesLength()) {
            return this.samplesLength;
        }
        throw new PropertyUndefinedError("samplesLength", (SBase)this);
    }

    public boolean isSetSamplesLength() {
        return this.samplesLength != null;
    }

    public String getDataType() {
        if (this.isSetDataType()) {
            return this.dataType;
        }
        return null;
    }

    public boolean isSetDataType() {
        return this.dataType != null;
    }

    public void setDataType(String dataType) {
        String oldDataType = this.dataType;
        this.dataType = dataType;
        this.firePropertyChange("dataType", oldDataType, this.dataType);
    }

    public boolean unsetDataType() {
        if (this.isSetDataType()) {
            String oldDataType = this.dataType;
            this.dataType = null;
            this.firePropertyChange("dataType", oldDataType, this.dataType);
            return true;
        }
        return false;
    }

    public int hashCode() {
        int prime = 983;
        int hashCode = super.hashCode();
        if (this.isSetSamples()) {
            hashCode += 983 * this.getSamples().hashCode();
        }
        if (this.isSetDataType()) {
            hashCode += 983 * this.getDataType().hashCode();
        }
        return hashCode;
    }

    public Map<String, String> writeXMLAttributes() {
        Map attributes = super.writeXMLAttributes();
        if (this.isSetSamples()) {
            attributes.remove("samples");
            attributes.put("spatial:samples", Arrays.toString((Object[])this.getSamples()));
        }
        if (this.isSetSamplesLength()) {
            attributes.remove("samplesLength");
            attributes.put("spatial:samplesLength", String.valueOf(this.getSamplesLength()));
        }
        if (this.isSetDataType()) {
            attributes.remove("dataType");
            attributes.put("spatial:dataType", this.getDataType());
        }
        return attributes;
    }

    public boolean readAttribute(String attributeName, String prefix, String value) {
        boolean isAttributeRead;
        boolean bl = isAttributeRead = super.readAttribute(attributeName, prefix, value) && "spatial" == prefix;
        if (!isAttributeRead) {
            isAttributeRead = true;
            if (attributeName.equals("samples")) {
                StringTokenizer test = new StringTokenizer(value);
                Integer[] samplesTemp = new Integer[test.countTokens()];
                int i = 0;
                while (test.hasMoreTokens()) {
                    try {
                        samplesTemp[i] = StringTools.parseSBMLInt((String)test.nextToken());
                        ++i;
                    }
                    catch (Exception e) {
                        MessageFormat.format(SpatialConstants.bundle.getString("COULD_NOT_READ"), value, "pointIndex");
                    }
                }
                if (samplesTemp.length > 0) {
                    this.unsetSamples();
                    this.setSamples(samplesTemp);
                }
            } else if (attributeName.equals("dataType")) {
                try {
                    this.setDataType(value);
                }
                catch (Exception e) {
                    MessageFormat.format(SpatialConstants.bundle.getString("COULD_NOT_READ"), value, "dataType");
                }
            } else {
                isAttributeRead = false;
            }
        }
        return isAttributeRead;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ImageData [samplesLength=");
        builder.append(this.samplesLength);
        builder.append(", dataType=");
        builder.append(this.dataType);
        builder.append(", samples=");
        builder.append(Arrays.toString((Object[])this.samples));
        builder.append("]");
        return builder.toString();
    }
}

