/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.spatial;

import java.text.MessageFormat;
import java.util.Map;
import javax.swing.tree.TreeNode;
import org.sbml.jsbml.AbstractSBase;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.SBMLException;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.Species;
import org.sbml.jsbml.ext.spatial.Geometry;
import org.sbml.jsbml.ext.spatial.SpatialConstants;
import org.sbml.jsbml.ext.spatial.SpatialModelPlugin;

public class ParameterType
extends AbstractSBase {
    private static final long serialVersionUID = 1359841900912406174L;
    private String spId;
    private String speciesRef;

    public ParameterType() {
    }

    public ParameterType(int level, int version) {
        super(level, version);
    }

    public ParameterType(ParameterType ref) {
        super((SBase)ref);
        if (ref.isSetSpId()) {
            this.spId = new String(ref.getSpId());
        }
        if (ref.isSetSpeciesReference()) {
            this.speciesRef = new String(ref.getSpeciesReference());
        }
    }

    public Species getSpeciesInstance() {
        Model model = this.getModel();
        return model != null ? model.getSpecies(this.getSpeciesReference()) : null;
    }

    public Species getVariableInstance() {
        return this.getSpeciesInstance();
    }

    public Geometry getGeometryInstance() {
        Model model = this.getModel();
        SpatialModelPlugin m = (SpatialModelPlugin)model.getExtension("Spatial");
        return m.getGeometry();
    }

    public String getSpId() {
        return this.isSetSpId() ? this.spId : "";
    }

    public String getSpeciesReference() {
        return this.isSetSpeciesReference() ? this.speciesRef : "";
    }

    public String getVariable() {
        return this.getSpeciesReference();
    }

    public boolean isSetSpeciesReference() {
        return this.speciesRef != null;
    }

    public boolean isSetVariable() {
        return this.isSetSpeciesReference();
    }

    public boolean isSetSpId() {
        return this.spId != null;
    }

    public boolean isSetSpatialRef() {
        return this.spId != null;
    }

    public void setSpId(String spId) {
        this.spId = spId;
        this.speciesRef = null;
    }

    public void setSpeciesReference(String speciesRef) {
        this.speciesRef = speciesRef;
    }

    public void setVariable(String speciesRef) {
        this.setSpeciesReference(speciesRef);
    }

    public ParameterType clone() {
        return new ParameterType(this);
    }

    public boolean getAllowsChildren() {
        return false;
    }

    public TreeNode getChildAt(int childIndex) {
        return null;
    }

    public int getChildCount() {
        return 0;
    }

    public boolean equals(Object object) {
        boolean equal = super.equals(object);
        if (equal) {
            ParameterType param = (ParameterType)((Object)object);
            if (param.isSetSpId() && param.isSetSpeciesReference()) {
                throw new SBMLException("Both SpId and SpIdRef cannot be set");
            }
            if (param.isSetSpId()) {
                equal &= param.getSpId().equals(this.getSpId());
            } else if (param.isSetSpeciesReference()) {
                equal &= param.getSpeciesReference().equals(this.getSpeciesReference());
            }
        }
        return equal;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ParameterType [spId=");
        builder.append(this.spId);
        builder.append(", speciesRef=");
        builder.append(this.speciesRef);
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        int prime = 983;
        int hashCode = super.hashCode();
        if (this.isSetSpId()) {
            hashCode += 983 * this.getSpId().hashCode();
        }
        if (this.isSetSpeciesReference()) {
            hashCode += 983 * this.getSpeciesReference().hashCode();
        }
        return hashCode;
    }

    public Map<String, String> writeXMLAttributes() {
        Map attributes = super.writeXMLAttributes();
        if (this.isSetSpId()) {
            attributes.remove("spatialRef");
            attributes.put("spatial:spatialRef", this.getSpId());
        }
        if (this.isSetSpeciesReference()) {
            attributes.remove("variable");
            attributes.put("spatial:variable", String.valueOf(this.getSpeciesReference()));
        }
        return attributes;
    }

    public boolean readAttribute(String attributeName, String prefix, String value) {
        boolean isAttributeRead;
        boolean bl = isAttributeRead = super.readAttribute(attributeName, prefix, value) && "spatial" == prefix;
        if (!isAttributeRead) {
            isAttributeRead = true;
            if (attributeName.equals("spatialId")) {
                try {
                    this.setSpId(value);
                }
                catch (Exception e) {
                    MessageFormat.format(SpatialConstants.bundle.getString("COULD_NOT_READ"), value, "spatialId");
                }
            } else if (attributeName.equals("variable")) {
                try {
                    this.setSpeciesReference(value);
                }
                catch (Exception e) {
                    MessageFormat.format(SpatialConstants.bundle.getString("COULD_NOT_READ"), value, "variable");
                }
            } else {
                isAttributeRead = false;
            }
        }
        return isAttributeRead;
    }
}

