/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.spatial;

import java.text.MessageFormat;
import javax.swing.tree.TreeNode;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.spatial.GeometryDefinition;
import org.sbml.jsbml.ext.spatial.ParametricObject;
import org.sbml.jsbml.ext.spatial.SpatialPoint;

public class ParametricGeometry
extends GeometryDefinition {
    ListOf<SpatialPoint> listOfSpatialPoints;
    ListOf<ParametricObject> listOfParametricObjects;
    private static final long serialVersionUID = 5947368889263003716L;

    public ParametricGeometry() {
    }

    public ParametricGeometry(ParametricGeometry pg) {
        super(pg);
        if (pg.isSetListOfParametricObjects()) {
            this.setListOfParametricObjects((ListOf<ParametricObject>)pg.getListOfParametricObjects().clone());
        }
        if (pg.isSetListOfSpatialPoints()) {
            this.setListOfSpatialPoints((ListOf<SpatialPoint>)pg.getListOfSpatialPoints().clone());
        }
    }

    public ParametricGeometry(int level, int version) {
        super(level, version);
    }

    public ParametricGeometry(String id, int level, int version) {
        super(id, level, version);
    }

    public ParametricGeometry clone() {
        return new ParametricGeometry(this);
    }

    @Override
    public boolean equals(Object object) {
        boolean equal = super.equals(object);
        if (equal) {
            ParametricGeometry pg = (ParametricGeometry)object;
            if ((equal &= pg.isSetListOfParametricObjects() == this.isSetListOfParametricObjects()) && this.isSetListOfParametricObjects()) {
                equal &= pg.getListOfParametricObjects().equals(this.getListOfParametricObjects());
            }
            if ((equal &= pg.isSetListOfSpatialPoints() == this.isSetListOfSpatialPoints()) && this.isSetListOfSpatialPoints()) {
                equal &= pg.getListOfSpatialPoints().equals(this.getListOfSpatialPoints());
            }
        }
        return equal;
    }

    public boolean isSetListOfParametricObjects() {
        return this.listOfParametricObjects != null && !this.listOfParametricObjects.isEmpty();
    }

    public ListOf<ParametricObject> getListOfParametricObjects() {
        if (!this.isSetListOfParametricObjects()) {
            this.listOfParametricObjects = new ListOf(this.getLevel(), this.getVersion());
            this.listOfParametricObjects.setNamespace("http://www.sbml.org/sbml/level3/version1/spatial/version1");
            this.listOfParametricObjects.setSBaseListType(ListOf.Type.other);
            this.registerChild((SBase)this.listOfParametricObjects);
        }
        return this.listOfParametricObjects;
    }

    public void setListOfParametricObjects(ListOf<ParametricObject> listOfParametricObjects) {
        this.unsetListOfParametricObjects();
        this.listOfParametricObjects = listOfParametricObjects;
        this.registerChild((SBase)this.listOfParametricObjects);
    }

    public boolean unsetListOfParametricObjects() {
        if (this.isSetListOfParametricObjects()) {
            ListOf<ParametricObject> oldParametricObjects = this.listOfParametricObjects;
            this.listOfParametricObjects = null;
            oldParametricObjects.fireNodeRemovedEvent();
            return true;
        }
        return false;
    }

    public boolean addParametricObject(ParametricObject parametricObject) {
        return this.getListOfParametricObjects().add((SBase)parametricObject);
    }

    public boolean removeParametricObject(ParametricObject parametricObject) {
        if (this.isSetListOfParametricObjects()) {
            return this.getListOfParametricObjects().remove((Object)parametricObject);
        }
        return false;
    }

    public void removeParametricObject(int i) {
        if (!this.isSetListOfParametricObjects()) {
            throw new IndexOutOfBoundsException(Integer.toString(i));
        }
        this.getListOfParametricObjects().remove(i);
    }

    public ParametricObject createParametricObject() {
        return this.createParametricObject(null);
    }

    public ParametricObject createParametricObject(String id) {
        ParametricObject parametricObject = new ParametricObject(id, this.getLevel(), this.getVersion());
        this.addParametricObject(parametricObject);
        return parametricObject;
    }

    public boolean isSetListOfSpatialPoints() {
        return this.listOfSpatialPoints != null && !this.listOfSpatialPoints.isEmpty();
    }

    public ListOf<SpatialPoint> getListOfSpatialPoints() {
        if (!this.isSetListOfSpatialPoints()) {
            this.listOfSpatialPoints = new ListOf(this.getLevel(), this.getVersion());
            this.listOfSpatialPoints.setNamespace("http://www.sbml.org/sbml/level3/version1/spatial/version1");
            this.listOfSpatialPoints.setSBaseListType(ListOf.Type.other);
            this.registerChild((SBase)this.listOfSpatialPoints);
        }
        return this.listOfSpatialPoints;
    }

    public void setListOfSpatialPoints(ListOf<SpatialPoint> listOfSpatialPoints) {
        this.unsetListOfSpatialPoints();
        this.listOfSpatialPoints = listOfSpatialPoints;
        this.registerChild((SBase)this.listOfSpatialPoints);
    }

    public boolean unsetListOfSpatialPoints() {
        if (this.isSetListOfSpatialPoints()) {
            ListOf<SpatialPoint> oldSpatialPoints = this.listOfSpatialPoints;
            this.listOfSpatialPoints = null;
            oldSpatialPoints.fireNodeRemovedEvent();
            return true;
        }
        return false;
    }

    public boolean addSpatialPoint(SpatialPoint spatialPoint) {
        return this.getListOfSpatialPoints().add((SBase)spatialPoint);
    }

    public boolean removeSpatialPoint(SpatialPoint spatialPoint) {
        if (this.isSetListOfSpatialPoints()) {
            return this.getListOfSpatialPoints().remove((Object)spatialPoint);
        }
        return false;
    }

    public void removeSpatialPoint(int i) {
        if (!this.isSetListOfSpatialPoints()) {
            throw new IndexOutOfBoundsException(Integer.toString(i));
        }
        this.getListOfSpatialPoints().remove(i);
    }

    public SpatialPoint createSpatialPoint() {
        return this.createSpatialPoint(null);
    }

    public SpatialPoint createSpatialPoint(String id) {
        SpatialPoint spatialPoint = new SpatialPoint(id, this.getLevel(), this.getVersion());
        this.addSpatialPoint(spatialPoint);
        return spatialPoint;
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public int getChildCount() {
        int count = super.getChildCount();
        if (this.isSetListOfParametricObjects()) {
            ++count;
        }
        if (this.isSetListOfSpatialPoints()) {
            ++count;
        }
        return count;
    }

    @Override
    public TreeNode getChildAt(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException(index + " < 0");
        }
        int count = super.getChildCount();
        int pos = 0;
        if (index < count) {
            return super.getChildAt(index);
        }
        index -= count;
        if (this.isSetListOfParametricObjects()) {
            if (pos == index) {
                return this.getListOfParametricObjects();
            }
            ++pos;
        }
        if (this.isSetListOfSpatialPoints()) {
            if (pos == index) {
                return this.getListOfSpatialPoints();
            }
            ++pos;
        }
        throw new IndexOutOfBoundsException(MessageFormat.format("Index {0,number,integer} >= {1,number,integer}", index, Math.min(pos, 0)));
    }
}

