/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.spatial;

import java.text.MessageFormat;
import java.util.Map;
import javax.swing.tree.TreeNode;
import org.sbml.jsbml.PropertyUndefinedError;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.spatial.AbstractSpatialNamedSBase;
import org.sbml.jsbml.ext.spatial.PolygonObject;
import org.sbml.jsbml.ext.spatial.SpatialConstants;

public class ParametricObject
extends AbstractSpatialNamedSBase {
    private PolygonKind polygonType;
    private String domainType;
    private PolygonObject polygonObject;
    private static final long serialVersionUID = -8093810090391511545L;

    public ParametricObject() {
    }

    public ParametricObject(ParametricObject po) {
        super(po);
        if (po.isSetDomainType()) {
            this.domainType = new String(po.getDomainType());
        }
        if (po.isSetPolygonType()) {
            this.setPolygonType(po.getPolygonType());
        }
        if (po.isSetPolygonObject()) {
            this.setPolygonObject(po.getPolygonObject().clone());
        }
    }

    public ParametricObject(int level, int version) {
        super(level, version);
    }

    public ParametricObject(String id, int level, int version) {
        super(id, level, version);
    }

    public ParametricObject clone() {
        return new ParametricObject(this);
    }

    @Override
    public boolean equals(Object object) {
        boolean equal = super.equals(object);
        if (equal) {
            ParametricObject po = (ParametricObject)object;
            if ((equal &= po.isSetDomainType() == this.isSetDomainType()) && this.isSetDomainType()) {
                equal &= po.getDomainType().equals(this.getDomainType());
            }
            if ((equal &= po.isSetPolygonType() == this.isSetPolygonType()) && this.isSetPolygonType()) {
                equal &= po.getPolygonType().equals((Object)this.getPolygonType());
            }
            if ((equal &= po.isSetPolygonObject() == this.isSetPolygonObject()) && this.isSetPolygonObject()) {
                equal &= po.getPolygonObject().equals((Object)this.getPolygonObject());
            }
        }
        return equal;
    }

    public PolygonKind getPolygonType() {
        if (this.isSetPolygonType()) {
            return this.polygonType;
        }
        throw new PropertyUndefinedError("polygonType", (SBase)this);
    }

    public boolean isSetPolygonType() {
        return this.polygonType != null;
    }

    public void setPolygonType(String polygonType) {
        this.setPolygonType(PolygonKind.valueOf(polygonType));
    }

    public void setPolygonType(PolygonKind polygonType) {
        PolygonKind oldPolygonType = this.polygonType;
        this.polygonType = polygonType;
        this.firePropertyChange("polygonType", (Object)oldPolygonType, (Object)this.polygonType);
    }

    public boolean unsetPolygonType() {
        if (this.isSetPolygonType()) {
            PolygonKind oldPolygonType = this.polygonType;
            this.polygonType = null;
            this.firePropertyChange("polygonType", (Object)oldPolygonType, (Object)this.polygonType);
            return true;
        }
        return false;
    }

    public String getDomainType() {
        if (this.isSetDomainType()) {
            return this.domainType;
        }
        throw new PropertyUndefinedError("domain", (SBase)this);
    }

    public boolean isSetDomainType() {
        return this.domainType != null;
    }

    public void setDomainType(String domain) {
        String oldDomain = this.domainType;
        this.domainType = domain;
        this.firePropertyChange("domain", oldDomain, this.domainType);
    }

    public boolean unsetDomain() {
        if (this.isSetDomainType()) {
            String oldDomain = this.domainType;
            this.domainType = null;
            this.firePropertyChange("domain", oldDomain, this.domainType);
            return true;
        }
        return false;
    }

    public PolygonObject getPolygonObject() {
        if (this.isSetPolygonObject()) {
            return this.polygonObject;
        }
        throw new PropertyUndefinedError("polygonObject", (SBase)this);
    }

    public boolean isSetPolygonObject() {
        return this.polygonObject != null;
    }

    public void setPolygonObject(PolygonObject polygonObject) {
        PolygonObject oldPolygonObject = this.polygonObject;
        this.polygonObject = polygonObject;
        this.firePropertyChange("polygonObject", (Object)oldPolygonObject, (Object)this.polygonObject);
    }

    public boolean unsetPolygonObject() {
        if (this.isSetPolygonObject()) {
            PolygonObject oldPolygonObject = this.polygonObject;
            this.polygonObject = null;
            this.firePropertyChange("polygonObject", (Object)oldPolygonObject, (Object)this.polygonObject);
            return true;
        }
        return false;
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public int getChildCount() {
        int count = super.getChildCount();
        if (this.isSetPolygonObject()) {
            ++count;
        }
        return count;
    }

    @Override
    public TreeNode getChildAt(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException(index + " < 0");
        }
        int count = super.getChildCount();
        int pos = 0;
        if (index < count) {
            return super.getChildAt(index);
        }
        index -= count;
        if (this.isSetPolygonObject()) {
            if (pos == index) {
                return this.getPolygonObject();
            }
            ++pos;
        }
        throw new IndexOutOfBoundsException(MessageFormat.format("Index {0,number,integer} >= {1,number,integer}", index, Math.min(pos, 0)));
    }

    @Override
    public int hashCode() {
        int prime = 983;
        int hashCode = super.hashCode();
        if (this.isSetDomainType()) {
            hashCode += 983 * this.getDomainType().hashCode();
        }
        if (this.isSetPolygonType()) {
            hashCode += 983 * this.getPolygonType().hashCode();
        }
        return hashCode;
    }

    @Override
    public Map<String, String> writeXMLAttributes() {
        Map<String, String> attributes = super.writeXMLAttributes();
        if (this.isSetDomainType()) {
            attributes.remove("domainType");
            attributes.put("spatial:domainType", this.getDomainType());
        }
        if (this.isSetPolygonType()) {
            attributes.remove("polygonType");
            attributes.put("spatial:polygonType", this.getPolygonType().toString());
        }
        return attributes;
    }

    @Override
    public boolean readAttribute(String attributeName, String prefix, String value) {
        boolean isAttributeRead;
        boolean bl = isAttributeRead = super.readAttribute(attributeName, prefix, value) && "spatial" == prefix;
        if (!isAttributeRead) {
            isAttributeRead = true;
            if (attributeName.equals("domainType")) {
                try {
                    this.setDomainType(value);
                }
                catch (Exception e) {
                    MessageFormat.format(SpatialConstants.bundle.getString("COULD_NOT_READ"), value, "domainType");
                }
            } else if (attributeName.equals("polygonType")) {
                try {
                    this.setPolygonType(value);
                }
                catch (Exception e) {
                    MessageFormat.format(SpatialConstants.bundle.getString("COULD_NOT_READ"), value, "polygonType");
                }
            } else {
                isAttributeRead = false;
            }
        }
        return isAttributeRead;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ParametricObject [polygonType=");
        builder.append((Object)this.polygonType);
        builder.append(", domain=");
        builder.append(this.domainType);
        builder.append("]");
        return builder.toString();
    }

    public static enum PolygonKind {
        TRIANGLE,
        QUADRILATERAL;

    }
}

