/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.spatial;

import java.text.MessageFormat;
import java.util.Map;
import javax.swing.tree.TreeNode;
import javax.xml.stream.XMLStreamException;
import org.sbml.jsbml.PropertyUndefinedError;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.spatial.AbstractSpatialNamedSBase;
import org.sbml.jsbml.ext.spatial.SpatialConstants;
import org.sbml.jsbml.util.StringTools;
import org.sbml.jsbml.xml.XMLNode;

public class SampledField
extends AbstractSpatialNamedSBase {
    private static final long serialVersionUID = 4345673559248715940L;
    private DataKind dataType;
    private Integer numSamples1;
    private Integer numSamples2;
    private Integer numSamples3;
    private InterpolationKind interpolation;
    private CompressionKind compression;
    private XMLNode data;

    public SampledField() {
    }

    public SampledField(SampledField sf) {
        super(sf);
        if (sf.isSetNumSamples1()) {
            this.numSamples1 = sf.getNumSamples1();
        }
        if (sf.isSetNumSamples2()) {
            this.numSamples2 = sf.getNumSamples2();
        }
        if (sf.isSetNumSamples3()) {
            this.numSamples3 = sf.getNumSamples3();
        }
        if (sf.isSetDataType()) {
            this.setDataType(sf.getDataType());
        }
        if (sf.isSetCompression()) {
            this.setCompression(sf.getCompression());
        }
        if (sf.isSetInterpolation()) {
            this.setInterpolation(sf.getInterpolation());
        }
    }

    public SampledField(int level, int version) {
        super(level, version);
    }

    public SampledField(String id, int level, int version) {
        super(id, level, version);
    }

    public SampledField clone() {
        return new SampledField(this);
    }

    @Override
    public boolean equals(Object object) {
        boolean equal = super.equals(object);
        if (equal) {
            SampledField sf = (SampledField)object;
            if ((equal &= sf.isSetNumSamples1() == this.isSetNumSamples1()) && this.isSetNumSamples1()) {
                equal &= sf.getNumSamples1() == this.getNumSamples1();
            }
            if ((equal &= sf.isSetNumSamples2() == this.isSetNumSamples2()) && this.isSetNumSamples2()) {
                equal &= sf.getNumSamples2() == this.getNumSamples2();
            }
            if ((equal &= sf.isSetNumSamples3() == this.isSetNumSamples3()) && this.isSetNumSamples3()) {
                equal &= sf.getNumSamples3() == this.getNumSamples3();
            }
            if ((equal &= sf.isSetCompression() == this.isSetCompression()) && this.isSetCompression()) {
                equal &= sf.getCompression().equals((Object)this.getCompression());
            }
            if ((equal &= sf.isSetInterpolation() == this.isSetInterpolation()) && this.isSetInterpolation()) {
                equal &= sf.getInterpolation().equals((Object)this.getInterpolation());
            }
            if ((equal &= sf.isSetDataType() == this.isSetDataType()) && this.isSetDataType()) {
                equal &= sf.getDataType().equals((Object)this.getDataType());
            }
        }
        return equal;
    }

    public int getNumSamples1() {
        if (this.isSetNumSamples1()) {
            return this.numSamples1;
        }
        throw new PropertyUndefinedError("numSamples1", (SBase)this);
    }

    public boolean isSetNumSamples1() {
        return this.numSamples1 != null;
    }

    public void setNumSamples1(int numSamples1) {
        int oldNumSamples1 = this.numSamples1;
        this.numSamples1 = numSamples1;
        this.firePropertyChange("numSamples1", oldNumSamples1, this.numSamples1);
    }

    public boolean unsetNumSamples1() {
        if (this.isSetNumSamples1()) {
            int oldNumSamples1 = this.numSamples1;
            this.numSamples1 = null;
            this.firePropertyChange("numSamples1", oldNumSamples1, this.numSamples1);
            return true;
        }
        return false;
    }

    public int getNumSamples2() {
        if (this.isSetNumSamples2()) {
            return this.numSamples2;
        }
        throw new PropertyUndefinedError("numSamples2", (SBase)this);
    }

    public boolean isSetNumSamples2() {
        return this.numSamples2 != null;
    }

    public void setNumSamples2(int numSamples2) {
        int oldNumSamples2 = this.numSamples2;
        this.numSamples2 = numSamples2;
        this.firePropertyChange("numSamples2", oldNumSamples2, this.numSamples2);
    }

    public boolean unsetNumSamples2() {
        if (this.isSetNumSamples2()) {
            int oldNumSamples2 = this.numSamples2;
            this.numSamples2 = null;
            this.firePropertyChange("numSamples2", oldNumSamples2, this.numSamples2);
            return true;
        }
        return false;
    }

    public int getNumSamples3() {
        if (this.isSetNumSamples3()) {
            return this.numSamples3;
        }
        throw new PropertyUndefinedError("numSamples3", (SBase)this);
    }

    public boolean isSetNumSamples3() {
        return this.numSamples3 != null;
    }

    public void setNumSamples3(int numSamples3) {
        int oldNumSamples3 = this.numSamples3;
        this.numSamples3 = numSamples3;
        this.firePropertyChange("numSamples3", oldNumSamples3, this.numSamples3);
    }

    public boolean unsetNumSamples3() {
        if (this.isSetNumSamples3()) {
            int oldNumSamples3 = this.numSamples3;
            this.numSamples3 = null;
            this.firePropertyChange("numSamples3", oldNumSamples3, this.numSamples3);
            return true;
        }
        return false;
    }

    public DataKind getDataType() {
        if (this.isSetDataType()) {
            return this.dataType;
        }
        throw new PropertyUndefinedError("dataType", (SBase)this);
    }

    public boolean isSetDataType() {
        return this.dataType != null;
    }

    public void setDataType(DataKind dataType) {
        DataKind oldDataType = this.dataType;
        this.dataType = dataType;
        this.firePropertyChange("dataType", (Object)oldDataType, (Object)this.dataType);
    }

    public boolean unsetDataType() {
        if (this.isSetDataType()) {
            DataKind oldDataType = this.dataType;
            this.dataType = null;
            this.firePropertyChange("dataType", (Object)oldDataType, (Object)this.dataType);
            return true;
        }
        return false;
    }

    public CompressionKind getCompression() {
        if (this.isSetCompression()) {
            return this.compression;
        }
        throw new PropertyUndefinedError("compression", (SBase)this);
    }

    public boolean isSetCompression() {
        return this.compression != null;
    }

    public void setCompression(CompressionKind compression) {
        CompressionKind oldCompression = this.compression;
        this.compression = compression;
        this.firePropertyChange("compression", (Object)oldCompression, (Object)this.compression);
    }

    public boolean unsetCompression() {
        if (this.isSetCompression()) {
            CompressionKind oldCompression = this.compression;
            this.compression = null;
            this.firePropertyChange("compression", (Object)oldCompression, (Object)this.compression);
            return true;
        }
        return false;
    }

    public InterpolationKind getInterpolation() {
        if (this.isSetInterpolation()) {
            return this.interpolation;
        }
        throw new PropertyUndefinedError("interpolation", (SBase)this);
    }

    public boolean isSetInterpolation() {
        return this.interpolation != null;
    }

    public void setInterpolation(InterpolationKind interpolation) {
        InterpolationKind oldInterpolation = this.interpolation;
        this.interpolation = interpolation;
        this.firePropertyChange("interpolation", (Object)oldInterpolation, (Object)this.interpolation);
    }

    public boolean unsetInterpolation() {
        if (this.isSetInterpolation()) {
            InterpolationKind oldInterpolation = this.interpolation;
            this.interpolation = null;
            this.firePropertyChange("interpolation", (Object)oldInterpolation, (Object)this.interpolation);
            return true;
        }
        return false;
    }

    public String getDataString() {
        if (this.isSetData()) {
            return this.data.getCharacters();
        }
        throw new PropertyUndefinedError("data", (SBase)this);
    }

    public XMLNode getData() {
        if (this.isSetData()) {
            return this.data;
        }
        throw new PropertyUndefinedError("data", (SBase)this);
    }

    public boolean isSetData() {
        return this.data != null;
    }

    public void setData(String data) throws XMLStreamException {
        this.setData(XMLNode.convertStringToXMLNode((String)data));
    }

    public void setData(XMLNode data) {
        XMLNode oldData = this.data;
        this.data = data;
        this.firePropertyChange("data", oldData, this.data);
    }

    public boolean unsetData() {
        if (this.isSetData()) {
            XMLNode oldData = this.data;
            this.data = null;
            this.firePropertyChange("data", oldData, this.data);
            return true;
        }
        return false;
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public int getChildCount() {
        int count = super.getChildCount();
        if (this.isSetData()) {
            ++count;
        }
        return count;
    }

    @Override
    public TreeNode getChildAt(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException(index + " < 0");
        }
        int count = super.getChildCount();
        int pos = 0;
        if (index < count) {
            return super.getChildAt(index);
        }
        index -= count;
        if (this.isSetData()) {
            if (pos == index) {
                return this.getData();
            }
            ++pos;
        }
        throw new IndexOutOfBoundsException(MessageFormat.format("Index {0,number,integer} >= {1,number,integer}", index, Math.min(pos, 0)));
    }

    @Override
    public int hashCode() {
        int prime = 983;
        int hashCode = super.hashCode();
        if (this.isSetNumSamples1()) {
            hashCode += 983 * this.getNumSamples1();
        }
        if (this.isSetNumSamples2()) {
            hashCode += 983 * this.getNumSamples2();
        }
        if (this.isSetNumSamples3()) {
            hashCode += 983 * this.getNumSamples3();
        }
        if (this.isSetDataType()) {
            hashCode += 983 * this.getDataType().hashCode();
        }
        if (this.isSetCompression()) {
            hashCode += 983 * this.getCompression().hashCode();
        }
        if (this.isSetInterpolation()) {
            hashCode += 983 * this.getInterpolation().hashCode();
        }
        return hashCode;
    }

    @Override
    public Map<String, String> writeXMLAttributes() {
        Map<String, String> attributes = super.writeXMLAttributes();
        if (this.isSetNumSamples1()) {
            attributes.remove("numSamples1");
            attributes.put("spatial:numSamples1", String.valueOf(this.getNumSamples1()));
        }
        if (this.isSetNumSamples2()) {
            attributes.remove("numSamples2");
            attributes.put("spatial:numSamples2", String.valueOf(this.getNumSamples2()));
        }
        if (this.isSetNumSamples3()) {
            attributes.remove("numSamples3");
            attributes.put("spatial:numSamples3", String.valueOf(this.getNumSamples3()));
        }
        if (this.isSetDataType()) {
            attributes.remove("dataType");
            attributes.put("spatial:dataType", this.getDataType().toString());
        }
        if (this.isSetCompression()) {
            attributes.remove("compression");
            attributes.put("spatial:compression", this.getCompression().toString());
        }
        if (this.isSetInterpolation()) {
            attributes.remove("interpolation");
            attributes.put("spatial:interpolation", this.getInterpolation().toString());
        }
        return attributes;
    }

    @Override
    public boolean readAttribute(String attributeName, String prefix, String value) {
        boolean isAttributeRead;
        boolean bl = isAttributeRead = super.readAttribute(attributeName, prefix, value) && "spatial" == prefix;
        if (!isAttributeRead) {
            isAttributeRead = true;
            if (attributeName.equals("numSamples1")) {
                try {
                    this.setNumSamples1(StringTools.parseSBMLInt((String)value));
                }
                catch (Exception e) {
                    MessageFormat.format(SpatialConstants.bundle.getString("COULD_NOT_READ"), value, "numSamples1");
                }
            } else if (attributeName.equals("numSamples2")) {
                try {
                    this.setNumSamples2(StringTools.parseSBMLInt((String)value));
                }
                catch (Exception e) {
                    MessageFormat.format(SpatialConstants.bundle.getString("COULD_NOT_READ"), value, "numSamples2");
                }
            } else if (attributeName.equals("numSamples3")) {
                try {
                    this.setNumSamples3(StringTools.parseSBMLInt((String)value));
                }
                catch (Exception e) {
                    MessageFormat.format(SpatialConstants.bundle.getString("COULD_NOT_READ"), value, "numSamples3");
                }
            } else if (attributeName.equals("interpolation")) {
                try {
                    this.setInterpolation(InterpolationKind.valueOf(value));
                }
                catch (Exception e) {
                    MessageFormat.format(SpatialConstants.bundle.getString("COULD_NOT_READ"), value, "interpolation");
                }
            } else if (attributeName.equals("compression")) {
                try {
                    this.setCompression(CompressionKind.valueOf(value));
                }
                catch (Exception e) {
                    MessageFormat.format(SpatialConstants.bundle.getString("COULD_NOT_READ"), value, "compression");
                }
            } else if (attributeName.equals("dataType")) {
                try {
                    this.setDataType(DataKind.valueOf(value));
                }
                catch (Exception e) {
                    MessageFormat.format(SpatialConstants.bundle.getString("COULD_NOT_READ"), value, "dataType");
                }
            } else {
                isAttributeRead = false;
            }
        }
        return isAttributeRead;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SampledField [dataType=");
        builder.append((Object)this.dataType);
        builder.append(", numSamples1=");
        builder.append(this.numSamples1);
        builder.append(", numSamples2=");
        builder.append(this.numSamples2);
        builder.append(", numSamples3=");
        builder.append(this.numSamples3);
        builder.append(", interpolation=");
        builder.append((Object)this.interpolation);
        builder.append(", compression=");
        builder.append((Object)this.compression);
        builder.append(", data=");
        builder.append(this.data);
        builder.append("]");
        return builder.toString();
    }

    public static enum InterpolationKind {
        NEARESTNEIGHBOR,
        LINEAR;

    }

    public static enum CompressionKind {
        UNCOMPRESSED,
        DEFLATED;

    }

    public static enum DataKind {
        DOUBLE,
        FLOAT,
        UINT8,
        UINT16,
        UINT32;

    }
}

