/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.spatial;

import java.text.MessageFormat;
import java.util.Map;
import javax.swing.tree.TreeNode;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.PropertyUndefinedError;
import org.sbml.jsbml.SBMLException;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.spatial.GeometryDefinition;
import org.sbml.jsbml.ext.spatial.SampledVolume;
import org.sbml.jsbml.ext.spatial.SpatialConstants;
import org.sbml.jsbml.util.filters.Filter;
import org.sbml.jsbml.util.filters.NameFilter;

public class SampledFieldGeometry
extends GeometryDefinition {
    private static final long serialVersionUID = -1541677165317653439L;
    private ListOf<SampledVolume> listOfSampledVolumes;
    private String sampledField;

    public SampledFieldGeometry() {
    }

    public SampledFieldGeometry(SampledFieldGeometry sampledFieldGeometry) {
        super(sampledFieldGeometry);
        if (sampledFieldGeometry.isSetSampledField()) {
            this.sampledField = new String(sampledFieldGeometry.getSampledField());
        }
        if (this.isSetListOfSampledVolumes()) {
            this.setListOfSampledVolumes((ListOf<SampledVolume>)sampledFieldGeometry.getListOfSampledVolumes().clone());
        }
    }

    public SampledFieldGeometry(String id, int level, int version) {
        super(id, level, version);
    }

    public SampledFieldGeometry clone() {
        return new SampledFieldGeometry(this);
    }

    @Override
    public boolean equals(Object object) {
        boolean equal = super.equals(object);
        if (equal) {
            SampledFieldGeometry sfg = (SampledFieldGeometry)object;
            if ((equal &= sfg.isSetListOfSampledVolumes() == this.isSetListOfSampledVolumes()) && this.isSetListOfSampledVolumes()) {
                equal &= sfg.getListOfSampledVolumes().equals(this.getListOfSampledVolumes());
            }
            if ((equal &= sfg.isSetSampledField() == this.isSetSampledField()) && this.isSetSampledField()) {
                equal &= sfg.getSampledField().equals(this.getSampledField());
            }
        }
        return equal;
    }

    public String getSampledField() {
        if (this.isSetSampledField()) {
            return this.sampledField;
        }
        throw new PropertyUndefinedError("sampledField", (SBase)this);
    }

    public boolean isSetSampledField() {
        return this.sampledField != null;
    }

    public void setSampledField(String sampledField) {
        String oldSampledField = this.sampledField;
        this.sampledField = sampledField;
        this.firePropertyChange("sampledField", oldSampledField, this.sampledField);
    }

    public boolean unsetSampledField() {
        if (this.isSetSampledField()) {
            String oldSampledField = this.sampledField;
            this.sampledField = null;
            this.firePropertyChange("sampledField", oldSampledField, this.sampledField);
            return true;
        }
        return false;
    }

    public boolean isSetListOfSampledVolumes() {
        return this.listOfSampledVolumes != null && !this.listOfSampledVolumes.isEmpty();
    }

    public ListOf<SampledVolume> getListOfSampledVolumes() {
        if (!this.isSetListOfSampledVolumes()) {
            this.listOfSampledVolumes = new ListOf(this.getLevel(), this.getVersion());
            this.listOfSampledVolumes.setNamespace("http://www.sbml.org/sbml/level3/version1/spatial/version1");
            this.listOfSampledVolumes.setSBaseListType(ListOf.Type.other);
            this.registerChild((SBase)this.listOfSampledVolumes);
        }
        return this.listOfSampledVolumes;
    }

    public void setListOfSampledVolumes(ListOf<SampledVolume> listOfSampledVolumes) {
        this.unsetListOfSampledVolumes();
        this.listOfSampledVolumes = listOfSampledVolumes;
        this.registerChild((SBase)this.listOfSampledVolumes);
    }

    public boolean unsetListOfSampledVolumes() {
        if (this.isSetListOfSampledVolumes()) {
            ListOf<SampledVolume> oldSampledVolumes = this.listOfSampledVolumes;
            this.listOfSampledVolumes = null;
            oldSampledVolumes.fireNodeRemovedEvent();
            return true;
        }
        return false;
    }

    public boolean addSampledVolume(SampledVolume sampledVolume) {
        return this.getListOfSampledVolumes().add((SBase)sampledVolume);
    }

    public boolean removeSampledVolume(SampledVolume sampledVolume) {
        if (this.isSetListOfSampledVolumes()) {
            if (this.getListOfSampledVolumes().size() <= 1) {
                return false;
            }
            return this.getListOfSampledVolumes().remove((Object)sampledVolume);
        }
        return false;
    }

    public void removeSampledVolume(int i) {
        if (!this.isSetListOfSampledVolumes()) {
            throw new IndexOutOfBoundsException(Integer.toString(i));
        }
        if (this.getListOfSampledVolumes().size() <= 1) {
            throw new SBMLException("There must be at least one SampledVolume defined for this list");
        }
        this.getListOfSampledVolumes().remove(i);
    }

    public void removeSampledVolume(String id) {
        this.getListOfSampledVolumes().removeFirst((Filter)new NameFilter(id));
    }

    public SampledVolume createSampledVolume() {
        return this.createSampledVolume(null);
    }

    public SampledVolume createSampledVolume(String id) {
        SampledVolume sampledVolume = new SampledVolume(id, this.getLevel(), this.getVersion());
        this.addSampledVolume(sampledVolume);
        return sampledVolume;
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public int getChildCount() {
        int count = super.getChildCount();
        if (this.isSetListOfSampledVolumes()) {
            ++count;
        }
        return count;
    }

    @Override
    public TreeNode getChildAt(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException(index + " < 0");
        }
        int count = super.getChildCount();
        int pos = 0;
        if (index < count) {
            return super.getChildAt(index);
        }
        index -= count;
        if (this.isSetListOfSampledVolumes()) {
            if (pos == index) {
                return this.getListOfSampledVolumes();
            }
            ++pos;
        }
        throw new IndexOutOfBoundsException(MessageFormat.format("Index {0,number,integer} >= {1,number,integer}", index, Math.min(pos, 0)));
    }

    @Override
    public int hashCode() {
        int prime = 983;
        int hashCode = super.hashCode();
        if (this.isSetSampledField()) {
            hashCode += 983 * this.getSampledField().hashCode();
        }
        return hashCode;
    }

    @Override
    public Map<String, String> writeXMLAttributes() {
        Map<String, String> attributes = super.writeXMLAttributes();
        if (this.isSetSampledField()) {
            attributes.put("spatial:sampledField", this.getSampledField());
        }
        return attributes;
    }

    @Override
    public boolean readAttribute(String attributeName, String prefix, String value) {
        boolean isAttributeRead;
        boolean bl = isAttributeRead = super.readAttribute(attributeName, prefix, value) && "spatial" == prefix;
        if (!isAttributeRead) {
            isAttributeRead = true;
            if (attributeName.equals("sampledField")) {
                try {
                    this.setSampledField(value);
                }
                catch (Exception e) {
                    MessageFormat.format(SpatialConstants.bundle.getString("COULD_NOT_READ"), value, "sampledField");
                }
            } else {
                isAttributeRead = false;
            }
        }
        return isAttributeRead;
    }
}

