/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.spatial;

import java.text.MessageFormat;
import java.util.Map;
import org.sbml.jsbml.PropertyUndefinedError;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.spatial.AbstractSpatialNamedSBase;
import org.sbml.jsbml.ext.spatial.SpatialConstants;
import org.sbml.jsbml.util.StringTools;

public class SpatialPoint
extends AbstractSpatialNamedSBase {
    private String domain;
    private Double coord1;
    private Double coord2;
    private Double coord3;
    private static final long serialVersionUID = -1171421071571874086L;

    public SpatialPoint() {
    }

    public SpatialPoint(SpatialPoint sp) {
        super(sp);
        if (sp.isSetDomain()) {
            this.domain = new String(sp.getDomain());
        }
        if (sp.isSetCoord1()) {
            this.coord1 = new Double(sp.getCoord1());
        }
        if (sp.isSetCoord2()) {
            this.coord2 = new Double(sp.getCoord2());
        }
        if (sp.isSetCoord3()) {
            this.coord3 = new Double(sp.getCoord3());
        }
    }

    public SpatialPoint(int level, int version) {
        super(level, version);
    }

    public SpatialPoint(String id, int level, int version) {
        super(id, level, version);
    }

    public SpatialPoint clone() {
        return new SpatialPoint(this);
    }

    @Override
    public boolean equals(Object object) {
        boolean equal = super.equals(object);
        if (equal) {
            SpatialPoint sp = (SpatialPoint)object;
            if ((equal &= sp.isSetDomain() == this.isSetDomain()) && this.isSetDomain()) {
                equal &= sp.getDomain().equals(this.getDomain());
            }
            if ((equal &= sp.isSetCoord1() == this.isSetCoord1()) && this.isSetCoord1()) {
                equal &= sp.getCoord1() == this.getCoord1();
            }
            if ((equal &= sp.isSetCoord2() == this.isSetCoord2()) && this.isSetCoord2()) {
                equal &= sp.getCoord2() == this.getCoord2();
            }
            if ((equal &= sp.isSetCoord3() == this.isSetCoord3()) && this.isSetCoord3()) {
                equal &= sp.getCoord3() == this.getCoord3();
            }
        }
        return equal;
    }

    public double getCoord1() {
        if (this.isSetCoord1()) {
            return this.coord1;
        }
        throw new PropertyUndefinedError("coord1", (SBase)this);
    }

    public boolean isSetCoord1() {
        return this.coord1 != null;
    }

    public void setCoord1(double coord1) {
        double oldCoord1 = this.coord1;
        this.coord1 = coord1;
        this.firePropertyChange("coord1", oldCoord1, this.coord1);
    }

    public boolean unsetCoord1() {
        if (this.isSetCoord1()) {
            double oldCoord1 = this.coord1;
            this.coord1 = null;
            this.firePropertyChange("coord1", oldCoord1, this.coord1);
            return true;
        }
        return false;
    }

    public double getCoord2() {
        if (this.isSetCoord2()) {
            return this.coord2;
        }
        throw new PropertyUndefinedError("coord2", (SBase)this);
    }

    public boolean isSetCoord2() {
        return this.coord2 != null;
    }

    public void setCoord2(double coord2) {
        double oldCoord2 = this.coord2;
        this.coord2 = coord2;
        this.firePropertyChange("coord2", oldCoord2, this.coord2);
    }

    public boolean unsetCoord2() {
        if (this.isSetCoord2()) {
            double oldCoord2 = this.coord2;
            this.coord2 = null;
            this.firePropertyChange("coord2", oldCoord2, this.coord2);
            return true;
        }
        return false;
    }

    public double getCoord3() {
        if (this.isSetCoord3()) {
            return this.coord3;
        }
        throw new PropertyUndefinedError("coord3", (SBase)this);
    }

    public boolean isSetCoord3() {
        return this.coord3 != null;
    }

    public void setCoord3(double coord3) {
        double oldCoord3 = this.coord3;
        this.coord3 = coord3;
        this.firePropertyChange("coord3", oldCoord3, this.coord3);
    }

    public boolean unsetCoord3() {
        if (this.isSetCoord3()) {
            double oldCoord3 = this.coord3;
            this.coord3 = null;
            this.firePropertyChange("coord3", oldCoord3, this.coord3);
            return true;
        }
        return false;
    }

    public String getDomain() {
        if (this.isSetDomain()) {
            return this.domain;
        }
        throw new PropertyUndefinedError("domain", (SBase)this);
    }

    public boolean isSetDomain() {
        return this.domain != null;
    }

    public void setDomain(String domain) {
        String oldDomain = this.domain;
        this.domain = domain;
        this.firePropertyChange("domain", oldDomain, this.domain);
    }

    public boolean unsetDomain() {
        if (this.isSetDomain()) {
            String oldDomain = this.domain;
            this.domain = null;
            this.firePropertyChange("domain", oldDomain, this.domain);
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int prime = 983;
        int hashCode = super.hashCode();
        if (this.isSetDomain()) {
            hashCode += 983 * this.getDomain().hashCode();
        }
        if (this.isSetCoord1()) {
            hashCode = (int)((double)hashCode + 983.0 * this.getCoord1());
        }
        if (this.isSetCoord2()) {
            hashCode = (int)((double)hashCode + 983.0 * this.getCoord2());
        }
        if (this.isSetCoord3()) {
            hashCode = (int)((double)hashCode + 983.0 * this.getCoord3());
        }
        return hashCode;
    }

    @Override
    public Map<String, String> writeXMLAttributes() {
        Map<String, String> attributes = super.writeXMLAttributes();
        if (this.isSetDomain()) {
            attributes.remove("domain");
            attributes.put("spatial:domain", this.getDomain());
        }
        if (this.isSetCoord1()) {
            attributes.remove("coord1");
            attributes.put("spatial:coord1", String.valueOf(this.getCoord1()));
        }
        if (this.isSetCoord2()) {
            attributes.remove("coord1");
            attributes.put("spatial:coord1", String.valueOf(this.getCoord2()));
        }
        if (this.isSetCoord3()) {
            attributes.remove("coord3");
            attributes.put("spatial:coord3", String.valueOf(this.getCoord3()));
        }
        return attributes;
    }

    @Override
    public boolean readAttribute(String attributeName, String prefix, String value) {
        boolean isAttributeRead;
        boolean bl = isAttributeRead = super.readAttribute(attributeName, prefix, value) && "spatial" == prefix;
        if (!isAttributeRead) {
            isAttributeRead = true;
            if (attributeName.equals("domain")) {
                try {
                    this.setDomain(value);
                }
                catch (Exception e) {
                    MessageFormat.format(SpatialConstants.bundle.getString("COULD_NOT_READ"), value, "domain");
                }
            } else if (attributeName.equals("coord1")) {
                try {
                    this.setCoord1(StringTools.parseSBMLDouble((String)value));
                }
                catch (Exception e) {
                    MessageFormat.format(SpatialConstants.bundle.getString("COULD_NOT_READ"), value, "coord1");
                }
            } else if (attributeName.equals("coord2")) {
                try {
                    this.setCoord2(StringTools.parseSBMLDouble((String)value));
                }
                catch (Exception e) {
                    MessageFormat.format(SpatialConstants.bundle.getString("COULD_NOT_READ"), value, "coord2");
                }
            } else if (attributeName.equals("coord3")) {
                try {
                    this.setCoord3(StringTools.parseSBMLDouble((String)value));
                }
                catch (Exception e) {
                    MessageFormat.format(SpatialConstants.bundle.getString("COULD_NOT_READ"), value, "coord3");
                }
            } else {
                isAttributeRead = false;
            }
        }
        return isAttributeRead;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SpatialPoint [domain=");
        builder.append(this.domain);
        builder.append(", coord1=");
        builder.append(this.coord1);
        builder.append(", coord2=");
        builder.append(this.coord2);
        builder.append(", coord3=");
        builder.append(this.coord3);
        builder.append("]");
        return builder.toString();
    }
}

