/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.spatial;

import java.text.MessageFormat;
import javax.swing.tree.TreeNode;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.SBMLException;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.spatial.AnalyticVolume;
import org.sbml.jsbml.ext.spatial.GeometryDefinition;
import org.sbml.jsbml.util.filters.Filter;
import org.sbml.jsbml.util.filters.NameFilter;

public class AnalyticGeometry
extends GeometryDefinition {
    private ListOf<AnalyticVolume> listOfAnalyticVolumes;
    private static final long serialVersionUID = -6680739495215471035L;

    public AnalyticGeometry() {
    }

    public AnalyticGeometry(AnalyticGeometry analyticGeometry) {
        super(analyticGeometry);
        if (analyticGeometry.isSetListOfAnalyticVolumes()) {
            this.setListOfAnalyticVolumes((ListOf<AnalyticVolume>)analyticGeometry.getListOfAnalyticVolumes().clone());
        }
    }

    public AnalyticGeometry(String id, int level, int version) {
        super(id, level, version);
    }

    @Override
    public AnalyticGeometry clone() {
        return new AnalyticGeometry(this);
    }

    public boolean isSetListOfAnalyticVolumes() {
        return this.listOfAnalyticVolumes != null && !this.listOfAnalyticVolumes.isEmpty();
    }

    public ListOf<AnalyticVolume> getListOfAnalyticVolumes() {
        if (!this.isSetListOfAnalyticVolumes()) {
            this.listOfAnalyticVolumes = new ListOf();
            this.listOfAnalyticVolumes.setNamespace("http://www.sbml.org/sbml/level3/version1/spatial/version1");
            this.listOfAnalyticVolumes.setSBaseListType(ListOf.Type.other);
            this.registerChild((SBase)this.listOfAnalyticVolumes);
        }
        return this.listOfAnalyticVolumes;
    }

    public void setListOfAnalyticVolumes(ListOf<AnalyticVolume> listOfAnalyticVolumes) {
        this.unsetListOfAnalyticVolumes();
        this.listOfAnalyticVolumes = listOfAnalyticVolumes;
        this.registerChild((SBase)this.listOfAnalyticVolumes);
    }

    public boolean unsetListOfAnalyticVolumes() {
        if (this.isSetListOfAnalyticVolumes()) {
            ListOf<AnalyticVolume> oldAnalyticVolumes = this.listOfAnalyticVolumes;
            this.listOfAnalyticVolumes = null;
            oldAnalyticVolumes.fireNodeRemovedEvent();
            return true;
        }
        return false;
    }

    public boolean addAnalyticVolume(AnalyticVolume analyticVolume) {
        return this.getListOfAnalyticVolumes().add((SBase)analyticVolume);
    }

    public boolean removeAnalyticVolume(AnalyticVolume analyticVolume) {
        if (this.isSetListOfAnalyticVolumes()) {
            if (this.getListOfAnalyticVolumes().size() <= 1) {
                return false;
            }
            return this.getListOfAnalyticVolumes().remove((Object)analyticVolume);
        }
        return false;
    }

    public void removeAnalyticVolume(int i) {
        if (!this.isSetListOfAnalyticVolumes()) {
            throw new IndexOutOfBoundsException(Integer.toString(i));
        }
        if (this.getListOfAnalyticVolumes().size() <= 1) {
            throw new SBMLException("There must be at least one AnalyticVolume defined for this list");
        }
        this.getListOfAnalyticVolumes().remove(i);
    }

    public void removeAnalyticVolume(String id) {
        this.getListOfAnalyticVolumes().removeFirst((Filter)new NameFilter(id));
    }

    public AnalyticVolume createAnalyticVolume() {
        return this.createAnalyticVolume(null);
    }

    public AnalyticVolume createAnalyticVolume(String id) {
        AnalyticVolume analyticVolume = new AnalyticVolume(id, this.getLevel(), this.getVersion());
        this.addAnalyticVolume(analyticVolume);
        return analyticVolume;
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public int getChildCount() {
        int count = super.getChildCount();
        if (this.isSetListOfAnalyticVolumes()) {
            ++count;
        }
        return count;
    }

    @Override
    public TreeNode getChildAt(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException(MessageFormat.format(resourceBundle.getString("IndexSurpassesBoundsException"), index, 0));
        }
        int count = super.getChildCount();
        int pos = 0;
        if (index < count) {
            return super.getChildAt(index);
        }
        index -= count;
        if (this.isSetListOfAnalyticVolumes()) {
            if (pos == index) {
                return this.getListOfAnalyticVolumes();
            }
            ++pos;
        }
        throw new IndexOutOfBoundsException(MessageFormat.format(resourceBundle.getString("IndexExceedsBoundsException"), index, Math.min(pos, 0)));
    }

    @Override
    public boolean equals(Object object) {
        AnalyticGeometry gm;
        boolean equal = super.equals(object);
        if (equal && (equal &= (gm = (AnalyticGeometry)object).isSetListOfAnalyticVolumes() == this.isSetListOfAnalyticVolumes()) && this.isSetListOfAnalyticVolumes()) {
            equal &= gm.getListOfAnalyticVolumes().equals(this.getListOfAnalyticVolumes());
        }
        return equal;
    }

    @Override
    public int hashCode() {
        int prime = 1039;
        int hashCode = super.hashCode();
        if (this.isSetListOfAnalyticVolumes()) {
            hashCode += 1039 * this.getListOfAnalyticVolumes().hashCode();
        }
        return hashCode;
    }
}

