/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.spatial;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.sbml.jsbml.AbstractSBase;
import org.sbml.jsbml.PropertyUndefinedError;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.spatial.SpatialConstants;
import org.sbml.jsbml.util.StringTools;

public class TransformationComponent
extends AbstractSBase {
    private static final transient Logger logger = Logger.getLogger(TransformationComponent.class);
    private static final long serialVersionUID = -2905551100912455549L;
    private Double[] components;
    private Integer componentsLength;

    public TransformationComponent() {
        this.initDefaults();
    }

    public TransformationComponent(TransformationComponent tc) {
        super((SBase)tc);
        if (tc.isSetComponents()) {
            this.setComponents((Double[])tc.getComponents().clone());
        }
    }

    public TransformationComponent(int level, int version) {
        super(level, version);
        this.initDefaults();
    }

    public TransformationComponent clone() {
        return new TransformationComponent(this);
    }

    public void initDefaults() {
        this.setPackageVersion(-1);
        this.packageName = "spatial";
    }

    public boolean equals(Object object) {
        boolean equal = super.equals(object);
        if (equal) {
            TransformationComponent tc = (TransformationComponent)((Object)object);
            if ((equal &= tc.isSetComponents() == this.isSetComponents()) && this.isSetComponents()) {
                equal &= tc.getComponents().equals(this.getComponents());
            }
            if (equal && this.isSetComponentsLength()) {
                equal &= tc.getComponentsLength() == this.getComponentsLength();
            }
        }
        return equal;
    }

    public Double[] getComponents() {
        if (this.isSetComponents()) {
            return this.components;
        }
        throw new PropertyUndefinedError("components", (SBase)this);
    }

    public boolean isSetComponents() {
        return this.components != null;
    }

    public void setComponents(Double ... components) {
        Double[] oldComponents = this.components;
        this.components = components;
        this.componentsLength = components.length;
        this.firePropertyChange("components", oldComponents, this.components);
        this.firePropertyChange("componentsLength", oldComponents.length, this.componentsLength);
    }

    public boolean unsetComponents() {
        if (this.isSetComponents()) {
            Double[] oldComponents = this.components;
            this.components = null;
            this.componentsLength = null;
            this.firePropertyChange("components", oldComponents, this.components);
            this.firePropertyChange("componentsLength", oldComponents.length, this.componentsLength);
            return true;
        }
        return false;
    }

    public int getComponentsLength() {
        if (this.isSetComponentsLength()) {
            return this.componentsLength;
        }
        throw new PropertyUndefinedError("componentsLength", (SBase)this);
    }

    public boolean isSetComponentsLength() {
        return this.componentsLength != null;
    }

    public int hashCode() {
        int prime = 983;
        int hashCode = super.hashCode();
        if (this.isSetComponents()) {
            hashCode += 983 * this.getComponents().hashCode();
        }
        if (this.isSetComponentsLength()) {
            hashCode += 983 * this.getComponentsLength();
        }
        return hashCode;
    }

    public Map<String, String> writeXMLAttributes() {
        Map attributes = super.writeXMLAttributes();
        if (this.isSetComponents()) {
            attributes.remove("components");
            attributes.put("spatial:components", Arrays.toString((Object[])this.getComponents()));
        }
        if (this.isSetComponentsLength()) {
            attributes.remove("componentsLength");
            attributes.put("spatial:componentsLength", String.valueOf(this.getComponentsLength()));
        }
        return attributes;
    }

    public boolean readAttribute(String attributeName, String prefix, String value) {
        boolean isAttributeRead;
        boolean bl = isAttributeRead = super.readAttribute(attributeName, prefix, value) && "spatial" == prefix;
        if (!isAttributeRead) {
            isAttributeRead = true;
            if (attributeName.equals("components")) {
                StringTokenizer test = new StringTokenizer(value);
                Double[] componentsTemp = new Double[test.countTokens()];
                int i = 0;
                while (test.hasMoreTokens()) {
                    try {
                        componentsTemp[i] = StringTools.parseSBMLDouble((String)test.nextToken());
                    }
                    catch (Exception e) {
                        logger.warn((Object)MessageFormat.format(SpatialConstants.bundle.getString("COULD_NOT_READ_ATTRIBUTE"), value, "components", this.getElementName()));
                    }
                    ++i;
                }
                if (componentsTemp.length > 0) {
                    this.unsetComponents();
                    this.setComponents(componentsTemp);
                }
            } else {
                isAttributeRead = false;
            }
        }
        return isAttributeRead;
    }
}

