/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.spatial;

import java.text.MessageFormat;
import java.util.Map;
import org.apache.log4j.Logger;
import org.sbml.jsbml.AbstractMathContainer;
import org.sbml.jsbml.PropertyUndefinedError;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.spatial.FunctionKind;
import org.sbml.jsbml.ext.spatial.SpatialConstants;
import org.sbml.jsbml.ext.spatial.SpatialNamedSBase;
import org.sbml.jsbml.util.StringTools;

public class AnalyticVolume
extends AbstractMathContainer
implements SpatialNamedSBase {
    private static final transient Logger logger = Logger.getLogger(AnalyticVolume.class);
    private String domainType;
    private FunctionKind functionType;
    private Integer ordinal;
    private static final long serialVersionUID = 1757917501241390228L;

    public AnalyticVolume() {
        this.initDefaults();
    }

    public AnalyticVolume(AnalyticVolume node) {
        super((AbstractMathContainer)node);
        if (node.isSetOrdinal()) {
            this.setOrdinal(node.getOrdinal());
        }
        if (node.isSetFunctionType()) {
            this.setFunctionType(node.getFunctionType());
        }
        if (node.isSetDomainType()) {
            this.setDomainType(node.getDomainType());
        }
    }

    public AnalyticVolume(String id, int level, int version) {
        super(id, level, version);
        this.initDefaults();
    }

    public void initDefaults() {
        this.setPackageVersion(-1);
        this.packageName = "spatial";
    }

    public AnalyticVolume clone() {
        return new AnalyticVolume(this);
    }

    public boolean equals(Object object) {
        boolean equal = super.equals(object);
        if (equal) {
            AnalyticVolume av = (AnalyticVolume)object;
            if ((equal &= av.isSetOrdinal() == this.isSetOrdinal()) && this.isSetOrdinal()) {
                equal &= av.getOrdinal() == this.getOrdinal();
            }
            if ((equal &= av.isSetDomainType() == this.isSetDomainType()) && this.isSetDomainType()) {
                equal &= av.getDomainType() == this.getDomainType();
            }
            if ((equal &= av.isSetFunctionType() == this.isSetFunctionType()) && this.isSetFunctionType()) {
                equal &= av.getFunctionType() == this.getFunctionType();
            }
        }
        return equal;
    }

    public FunctionKind getFunctionType() {
        if (this.isSetFunctionType()) {
            return this.functionType;
        }
        throw new PropertyUndefinedError("functionType", (SBase)this);
    }

    public boolean isSetFunctionType() {
        return this.functionType != null;
    }

    public void setFunctionType(FunctionKind functionType) {
        FunctionKind oldFunctionType = this.functionType;
        this.functionType = functionType;
        this.firePropertyChange("functionType", (Object)oldFunctionType, (Object)this.functionType);
    }

    public boolean unsetFunctionType() {
        if (this.isSetFunctionType()) {
            FunctionKind oldFunctionType = this.functionType;
            this.functionType = null;
            this.firePropertyChange("functionType", (Object)oldFunctionType, (Object)this.functionType);
            return true;
        }
        return false;
    }

    public String getDomainType() {
        if (this.isSetDomainType()) {
            return this.domainType;
        }
        throw new PropertyUndefinedError("domainType", (SBase)this);
    }

    public boolean isSetDomainType() {
        return this.domainType != null;
    }

    public void setDomainType(String domainType) {
        String oldDomainType = this.domainType;
        this.domainType = domainType;
        this.firePropertyChange("domainType", oldDomainType, this.domainType);
    }

    public boolean unsetDomainType() {
        if (this.isSetDomainType()) {
            String oldDomainType = this.domainType;
            this.domainType = null;
            this.firePropertyChange("domainType", oldDomainType, this.domainType);
            return true;
        }
        return false;
    }

    public Integer getOrdinal() {
        if (this.isSetOrdinal()) {
            return this.ordinal;
        }
        return null;
    }

    public boolean isSetOrdinal() {
        return this.ordinal != null;
    }

    public void setOrdinal(int ordinal) {
        Integer oldOrdinal = this.ordinal;
        this.ordinal = ordinal;
        this.firePropertyChange("ordinal", oldOrdinal, this.ordinal);
    }

    public boolean unsetOrdinal() {
        if (this.isSetOrdinal()) {
            Integer oldOrdinal = this.ordinal;
            this.ordinal = null;
            this.firePropertyChange("ordinal", oldOrdinal, this.ordinal);
            return true;
        }
        return false;
    }

    @Override
    public boolean unsetSpatialId() {
        this.unsetId();
        return true;
    }

    @Override
    public void setSpatialId(String spatialId) {
        this.setId(spatialId);
    }

    @Override
    public boolean isSetSpatialId() {
        return this.isSetId();
    }

    @Override
    public String getSpatialId() {
        return this.getId();
    }

    public int hashCode() {
        int prime = 1093;
        int hashCode = super.hashCode();
        if (this.isSetFunctionType()) {
            hashCode += 1093 * this.getFunctionType().hashCode();
        }
        if (this.isSetDomainType()) {
            hashCode += 1093 * this.getDomainType().hashCode();
        }
        if (this.isSetOrdinal()) {
            hashCode += 1093 * this.getOrdinal().hashCode();
        }
        return hashCode;
    }

    public Map<String, String> writeXMLAttributes() {
        Map attributes = super.writeXMLAttributes();
        if (this.isSetSpatialId()) {
            attributes.remove("id");
            attributes.put("spatial:id", this.getSpatialId());
        }
        if (this.isSetDomainType()) {
            attributes.remove("domainType");
            attributes.put("spatial:domainType", this.getDomainType());
        }
        if (this.isSetOrdinal()) {
            attributes.remove("ordinal");
            attributes.put("spatial:ordinal", String.valueOf(this.getOrdinal()));
        }
        if (this.isSetFunctionType()) {
            attributes.remove("functionType");
            attributes.put("spatial:functionType", this.getFunctionType().toString());
        }
        return attributes;
    }

    public boolean readAttribute(String attributeName, String prefix, String value) {
        boolean isAttributeRead;
        boolean bl = isAttributeRead = super.readAttribute(attributeName, prefix, value) && "spatial" == prefix;
        if (!isAttributeRead) {
            isAttributeRead = true;
            if (attributeName.equals("id")) {
                try {
                    this.setSpatialId(value);
                }
                catch (Exception e) {
                    logger.warn((Object)MessageFormat.format(SpatialConstants.bundle.getString("COULD_NOT_READ_ATTRIBUTE"), value, "id", this.getElementName()));
                }
            } else if (attributeName.equals("ordinal")) {
                try {
                    this.setOrdinal(StringTools.parseSBMLInt((String)value));
                }
                catch (Exception e) {
                    logger.warn((Object)MessageFormat.format(SpatialConstants.bundle.getString("COULD_NOT_READ_ATTRIBUTE"), value, "ordinal", this.getElementName()));
                }
            } else if (attributeName.equals("domainType")) {
                try {
                    this.setDomainType(value);
                }
                catch (Exception e) {
                    logger.warn((Object)MessageFormat.format(SpatialConstants.bundle.getString("COULD_NOT_READ_ATTRIBUTE"), value, "domainType", this.getElementName()));
                }
            } else if (attributeName.equals("functionType")) {
                try {
                    this.setFunctionType(FunctionKind.valueOf(value));
                }
                catch (Exception e) {
                    logger.warn((Object)MessageFormat.format(SpatialConstants.bundle.getString("COULD_NOT_READ_ATTRIBUTE"), value, "functionType", this.getElementName()));
                }
            } else {
                isAttributeRead = false;
            }
        }
        return isAttributeRead;
    }
}

