/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.spatial;

import java.text.MessageFormat;
import java.util.Map;
import org.apache.log4j.Logger;
import org.sbml.jsbml.PropertyUndefinedError;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.spatial.CSGTransformation;
import org.sbml.jsbml.ext.spatial.SpatialConstants;
import org.sbml.jsbml.util.StringTools;

public class CSGScale
extends CSGTransformation {
    private static final transient Logger logger = Logger.getLogger(CSGScale.class);
    private static final long serialVersionUID = 7021488698800177528L;
    private Double scaleX;
    private Double scaleY;
    private Double scaleZ;

    public CSGScale() {
    }

    public CSGScale(CSGScale csgt) {
        super(csgt);
        if (csgt.isSetScaleX()) {
            this.setScaleX(csgt.getScaleX());
        }
        if (csgt.isSetScaleY()) {
            this.setScaleY(csgt.getScaleY());
        }
        if (csgt.isSetScaleZ()) {
            this.setScaleZ(csgt.getScaleZ());
        }
    }

    public CSGScale(int level, int version) {
        super(level, version);
    }

    public CSGScale(String id, int level, int version) {
        super(id, level, version);
    }

    @Override
    public CSGScale clone() {
        return new CSGScale(this);
    }

    @Override
    public boolean equals(Object object) {
        boolean equal = super.equals(object);
        if (equal) {
            CSGScale csgt = (CSGScale)object;
            if ((equal &= csgt.isSetScaleX() == this.isSetScaleX()) && this.isSetScaleX()) {
                equal &= csgt.getScaleX() == this.getScaleX();
            }
            if ((equal &= csgt.isSetScaleY() == this.isSetScaleY()) && this.isSetScaleY()) {
                equal &= csgt.getScaleY() == this.getScaleY();
            }
            if ((equal &= csgt.isSetScaleZ() == this.isSetScaleZ()) && this.isSetScaleZ()) {
                equal &= csgt.getScaleZ() == this.getScaleZ();
            }
        }
        return equal;
    }

    public double getScaleX() {
        if (this.isSetScaleX()) {
            return this.scaleX;
        }
        throw new PropertyUndefinedError("scaleX", (SBase)this);
    }

    public boolean isSetScaleX() {
        return this.scaleX != null;
    }

    public void setScaleX(double scaleX) {
        Double oldScaleX = this.scaleX;
        this.scaleX = scaleX;
        this.firePropertyChange("scaleX", oldScaleX, this.scaleX);
    }

    public boolean unsetScaleX() {
        if (this.isSetScaleX()) {
            Double oldScaleX = this.scaleX;
            this.scaleX = null;
            this.firePropertyChange("scaleX", oldScaleX, this.scaleX);
            return true;
        }
        return false;
    }

    public double getScaleY() {
        if (this.isSetScaleY()) {
            return this.scaleY;
        }
        throw new PropertyUndefinedError("scaleY", (SBase)this);
    }

    public boolean isSetScaleY() {
        return this.scaleY != null;
    }

    public void setScaleY(double scaleY) {
        Double oldScaleY = this.scaleY;
        this.scaleY = scaleY;
        this.firePropertyChange("scaleY", oldScaleY, this.scaleY);
    }

    public boolean unsetScaleY() {
        if (this.isSetScaleY()) {
            Double oldScaleY = this.scaleY;
            this.scaleY = null;
            this.firePropertyChange("scaleY", oldScaleY, this.scaleY);
            return true;
        }
        return false;
    }

    public double getScaleZ() {
        if (this.isSetScaleZ()) {
            return this.scaleZ;
        }
        throw new PropertyUndefinedError("scaleZ", (SBase)this);
    }

    public boolean isSetScaleZ() {
        return this.scaleZ != null;
    }

    public void setScaleZ(double scaleZ) {
        Double oldScaleZ = this.scaleZ;
        this.scaleZ = scaleZ;
        this.firePropertyChange("scaleZ", oldScaleZ, this.scaleZ);
    }

    public boolean unsetScaleZ() {
        if (this.isSetScaleZ()) {
            Double oldScaleZ = this.scaleZ;
            this.scaleZ = null;
            this.firePropertyChange("scaleZ", oldScaleZ, this.scaleZ);
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int prime = 1777;
        int hashCode = super.hashCode();
        if (this.isSetScaleX()) {
            hashCode = (int)((double)hashCode + 1777.0 * this.getScaleX());
        }
        if (this.isSetScaleY()) {
            hashCode = (int)((double)hashCode + 1777.0 * this.getScaleY());
        }
        if (this.isSetScaleZ()) {
            hashCode = (int)((double)hashCode + 1777.0 * this.getScaleZ());
        }
        return hashCode;
    }

    @Override
    public Map<String, String> writeXMLAttributes() {
        Map<String, String> attributes = super.writeXMLAttributes();
        if (this.isSetScaleX()) {
            attributes.put("spatial:scaleX", this.scaleX.toString());
        }
        if (this.isSetScaleY()) {
            attributes.put("spatial:scaleY", this.scaleY.toString());
        }
        if (this.isSetScaleZ()) {
            attributes.put("spatial:scaleZ", this.scaleZ.toString());
        }
        return attributes;
    }

    @Override
    public boolean readAttribute(String attributeName, String prefix, String value) {
        boolean isAttributeRead;
        boolean bl = isAttributeRead = super.readAttribute(attributeName, prefix, value) && "spatial" == prefix;
        if (!isAttributeRead) {
            isAttributeRead = true;
            if (attributeName.equals("scaleX")) {
                try {
                    this.setScaleX(StringTools.parseSBMLDouble((String)value));
                }
                catch (Exception e) {
                    logger.warn((Object)MessageFormat.format(SpatialConstants.bundle.getString("COULD_NOT_READ_ATTRIBUTE"), value, "scaleX", this.getElementName()));
                }
            } else if (attributeName.equals("scaleY")) {
                try {
                    this.setScaleY(StringTools.parseSBMLDouble((String)value));
                }
                catch (Exception e) {
                    logger.warn((Object)MessageFormat.format(SpatialConstants.bundle.getString("COULD_NOT_READ_ATTRIBUTE"), value, "scaleY", this.getElementName()));
                }
            } else if (attributeName.equals("scaleZ")) {
                try {
                    this.setScaleZ(StringTools.parseSBMLDouble((String)value));
                }
                catch (Exception e) {
                    logger.warn((Object)MessageFormat.format(SpatialConstants.bundle.getString("COULD_NOT_READ_ATTRIBUTE"), value, "scaleZ", this.getElementName()));
                }
            } else {
                isAttributeRead = false;
            }
        }
        return isAttributeRead;
    }

    public String getElementName() {
        return "csgScale";
    }
}

