/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.spatial;

import java.text.MessageFormat;
import java.util.Map;
import org.apache.log4j.Logger;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.PropertyUndefinedError;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.spatial.AbstractSpatialNamedSBase;
import org.sbml.jsbml.ext.spatial.DomainType;
import org.sbml.jsbml.ext.spatial.SpatialConstants;
import org.sbml.jsbml.ext.spatial.SpatialModelPlugin;
import org.sbml.jsbml.util.StringTools;

public class CompartmentMapping
extends AbstractSpatialNamedSBase {
    private static final transient Logger logger = Logger.getLogger(CompartmentMapping.class);
    private static final long serialVersionUID = -4623759168043277022L;
    private String domainType;
    private Double unitSize;

    public CompartmentMapping() {
    }

    public CompartmentMapping(CompartmentMapping cm) {
        super(cm);
        if (cm.isSetDomainType()) {
            this.domainType = new String(cm.getDomainType());
        }
        if (cm.isSetUnitSize()) {
            this.unitSize = new Double(cm.getUnitSize());
        }
    }

    public CompartmentMapping(int level, int version) {
        super(level, version);
    }

    public CompartmentMapping(String id, int level, int version) {
        super(id, level, version);
    }

    @Override
    public CompartmentMapping clone() {
        return new CompartmentMapping(this);
    }

    @Override
    public boolean equals(Object object) {
        boolean equal = super.equals(object);
        if (equal) {
            CompartmentMapping cm = (CompartmentMapping)object;
            if ((equal &= cm.isSetDomainType() == this.isSetDomainType()) && this.isSetDomainType()) {
                equal &= cm.getDomainType().equals(this.getDomainType());
            }
            if ((equal &= cm.isSetUnitSize() == this.isSetUnitSize()) && this.isSetUnitSize()) {
                equal &= cm.getUnitSize() == this.getUnitSize();
            }
        }
        return equal;
    }

    public String getDomainType() {
        if (this.isSetDomainType()) {
            return this.domainType;
        }
        throw new PropertyUndefinedError("domainType", (SBase)this);
    }

    public boolean isSetDomainType() {
        return this.domainType != null;
    }

    public void setDomainType(String domainType) {
        String oldDomainType = this.domainType;
        this.domainType = domainType;
        this.firePropertyChange("domainType", oldDomainType, this.domainType);
    }

    public boolean unsetDomainType() {
        if (this.isSetDomainType()) {
            String oldDomainType = this.domainType;
            this.domainType = null;
            this.firePropertyChange("domainType", oldDomainType, this.domainType);
            return true;
        }
        return false;
    }

    public double getUnitSize() {
        if (this.isSetUnitSize()) {
            return this.unitSize;
        }
        throw new PropertyUndefinedError("unitSize", (SBase)this);
    }

    public boolean isSetUnitSize() {
        return this.unitSize != null;
    }

    public void setUnitSize(double unitSize) {
        Double oldUnitSize = this.unitSize;
        this.unitSize = unitSize;
        this.firePropertyChange("unitSize", oldUnitSize, this.unitSize);
    }

    public boolean unsetUnitSize() {
        if (this.isSetUnitSize()) {
            Double oldUnitSize = this.unitSize;
            this.unitSize = null;
            this.firePropertyChange("unitSize", oldUnitSize, this.unitSize);
            return true;
        }
        return false;
    }

    public DomainType getDomainTypeInstance() {
        Model m = this.getModel();
        if (m != null) {
            SpatialModelPlugin sm = (SpatialModelPlugin)m.getExtension(this.packageName);
            sm.getGeometry().getListOfDomainTypes().get(this.getDomainType());
        }
        return null;
    }

    @Override
    public int hashCode() {
        int prime = 1319;
        int hashCode = super.hashCode();
        if (this.isSetDomainType()) {
            hashCode += 1319 * this.getDomainType().hashCode();
        }
        if (this.isSetUnitSize()) {
            hashCode = (int)((double)hashCode + 1319.0 * this.getUnitSize());
        }
        return hashCode;
    }

    @Override
    public Map<String, String> writeXMLAttributes() {
        Map<String, String> attributes = super.writeXMLAttributes();
        if (this.isSetDomainType()) {
            attributes.remove("domainType");
            attributes.put("spatial:domainType", this.getDomainType());
        }
        if (this.isSetUnitSize()) {
            attributes.remove("unitSize");
            attributes.put("spatial:unitSize", String.valueOf(this.getUnitSize()));
        }
        return attributes;
    }

    @Override
    public boolean readAttribute(String attributeName, String prefix, String value) {
        boolean isAttributeRead = super.readAttribute(attributeName, prefix, value);
        if (!isAttributeRead) {
            isAttributeRead = true;
            if (attributeName.equals("domainType")) {
                try {
                    this.setDomainType(value);
                }
                catch (Exception e) {
                    logger.warn((Object)MessageFormat.format(SpatialConstants.bundle.getString("COULD_NOT_READ_ATTRIBUTE"), value, "domainType", this.getElementName()));
                }
            } else if (attributeName.equals("unitSize")) {
                try {
                    this.setUnitSize(StringTools.parseSBMLDouble((String)value));
                }
                catch (Exception e) {
                    logger.warn((Object)MessageFormat.format(SpatialConstants.bundle.getString("COULD_NOT_READ_ATTRIBUTE"), value, "unitSize", this.getElementName()));
                }
            } else {
                isAttributeRead = false;
            }
        }
        return isAttributeRead;
    }
}

