/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.spatial;

import java.text.MessageFormat;
import java.util.Map;
import javax.swing.tree.TreeNode;
import javax.xml.stream.XMLStreamException;
import org.apache.log4j.Logger;
import org.sbml.jsbml.PropertyUndefinedError;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.spatial.AbstractSpatialNamedSBase;
import org.sbml.jsbml.ext.spatial.CompressionKind;
import org.sbml.jsbml.ext.spatial.DataKind;
import org.sbml.jsbml.ext.spatial.InterpolationKind;
import org.sbml.jsbml.ext.spatial.SpatialConstants;
import org.sbml.jsbml.util.StringTools;
import org.sbml.jsbml.xml.XMLNode;

public class SampledField
extends AbstractSpatialNamedSBase {
    private static final transient Logger logger = Logger.getLogger(SampledField.class);
    private static final long serialVersionUID = 4345673559248715940L;
    private Integer numSamples1;
    private Integer numSamples2;
    private Integer numSamples3;
    private InterpolationKind interpolation;
    private CompressionKind compression;
    private String samples;
    private Integer samplesLength;
    private DataKind dataType;
    private XMLNode data;

    public SampledField() {
    }

    public SampledField(SampledField sf) {
        super(sf);
        if (sf.isSetNumSamples1()) {
            this.numSamples1 = sf.getNumSamples1();
        }
        if (sf.isSetNumSamples2()) {
            this.numSamples2 = sf.getNumSamples2();
        }
        if (sf.isSetNumSamples3()) {
            this.numSamples3 = sf.getNumSamples3();
        }
        if (sf.isSetDataType()) {
            this.setDataType(sf.getDataType());
        }
        if (sf.isSetCompression()) {
            this.setCompression(sf.getCompression());
        }
        if (sf.isSetSamples()) {
            this.setSamples(sf.getSamples());
        }
        if (sf.isSetSamplesLength()) {
            this.setSamplesLength(sf.getSamplesLength());
        }
        if (sf.isSetInterpolation()) {
            this.setInterpolation(sf.getInterpolation());
        }
    }

    public SampledField(int level, int version) {
        super(level, version);
    }

    public SampledField(String id, int level, int version) {
        super(id, level, version);
    }

    @Override
    public SampledField clone() {
        return new SampledField(this);
    }

    @Override
    public boolean equals(Object object) {
        boolean equal = super.equals(object);
        if (equal) {
            SampledField sf = (SampledField)object;
            if ((equal &= sf.isSetNumSamples1() == this.isSetNumSamples1()) && this.isSetNumSamples1()) {
                equal &= sf.getNumSamples1() == this.getNumSamples1();
            }
            if ((equal &= sf.isSetNumSamples2() == this.isSetNumSamples2()) && this.isSetNumSamples2()) {
                equal &= sf.getNumSamples2() == this.getNumSamples2();
            }
            if ((equal &= sf.isSetNumSamples3() == this.isSetNumSamples3()) && this.isSetNumSamples3()) {
                equal &= sf.getNumSamples3() == this.getNumSamples3();
            }
            if ((equal &= sf.isSetCompression() == this.isSetCompression()) && this.isSetCompression()) {
                equal &= sf.getCompression().equals((Object)this.getCompression());
            }
            if ((equal &= sf.isSetInterpolation() == this.isSetInterpolation()) && this.isSetInterpolation()) {
                equal &= sf.getInterpolation().equals((Object)this.getInterpolation());
            }
            if ((equal &= sf.isSetSamplesLength() == this.isSetSamplesLength()) && this.isSetSamplesLength()) {
                equal &= sf.getSamplesLength() == this.getSamplesLength();
            }
            if ((equal &= sf.isSetSamples() == this.isSetSamples()) && this.isSetSamples()) {
                equal &= sf.getSamples() == this.getSamples();
            }
            if ((equal &= sf.isSetDataType() == this.isSetDataType()) && this.isSetDataType()) {
                equal &= sf.getDataType().equals((Object)this.getDataType());
            }
        }
        return equal;
    }

    public int getNumSamples1() {
        if (this.isSetNumSamples1()) {
            return this.numSamples1;
        }
        throw new PropertyUndefinedError("numSamples1", (SBase)this);
    }

    public boolean isSetNumSamples1() {
        return this.numSamples1 != null;
    }

    public void setNumSamples1(int numSamples1) {
        Integer oldNumSamples1 = this.numSamples1;
        this.numSamples1 = numSamples1;
        this.firePropertyChange("numSamples1", oldNumSamples1, this.numSamples1);
    }

    public boolean unsetNumSamples1() {
        if (this.isSetNumSamples1()) {
            Integer oldNumSamples1 = this.numSamples1;
            this.numSamples1 = null;
            this.firePropertyChange("numSamples1", oldNumSamples1, this.numSamples1);
            return true;
        }
        return false;
    }

    public int getNumSamples2() {
        if (this.isSetNumSamples2()) {
            return this.numSamples2;
        }
        throw new PropertyUndefinedError("numSamples2", (SBase)this);
    }

    public boolean isSetNumSamples2() {
        return this.numSamples2 != null;
    }

    public void setNumSamples2(int numSamples2) {
        Integer oldNumSamples2 = this.numSamples2;
        this.numSamples2 = numSamples2;
        this.firePropertyChange("numSamples2", oldNumSamples2, this.numSamples2);
    }

    public boolean unsetNumSamples2() {
        if (this.isSetNumSamples2()) {
            Integer oldNumSamples2 = this.numSamples2;
            this.numSamples2 = null;
            this.firePropertyChange("numSamples2", oldNumSamples2, this.numSamples2);
            return true;
        }
        return false;
    }

    public int getNumSamples3() {
        if (this.isSetNumSamples3()) {
            return this.numSamples3;
        }
        throw new PropertyUndefinedError("numSamples3", (SBase)this);
    }

    public boolean isSetNumSamples3() {
        return this.numSamples3 != null;
    }

    public void setNumSamples3(int numSamples3) {
        Integer oldNumSamples3 = this.numSamples3;
        this.numSamples3 = numSamples3;
        this.firePropertyChange("numSamples3", oldNumSamples3, this.numSamples3);
    }

    public boolean unsetNumSamples3() {
        if (this.isSetNumSamples3()) {
            Integer oldNumSamples3 = this.numSamples3;
            this.numSamples3 = null;
            this.firePropertyChange("numSamples3", oldNumSamples3, this.numSamples3);
            return true;
        }
        return false;
    }

    public DataKind getDataType() {
        if (this.isSetDataType()) {
            return this.dataType;
        }
        throw new PropertyUndefinedError("dataType", (SBase)this);
    }

    public boolean isSetDataType() {
        return this.dataType != null;
    }

    public void setDataType(DataKind dataType) {
        DataKind oldDataType = this.dataType;
        this.dataType = dataType;
        this.firePropertyChange("dataType", (Object)oldDataType, (Object)this.dataType);
    }

    public boolean unsetDataType() {
        if (this.isSetDataType()) {
            DataKind oldDataType = this.dataType;
            this.dataType = null;
            this.firePropertyChange("dataType", (Object)oldDataType, (Object)this.dataType);
            return true;
        }
        return false;
    }

    public CompressionKind getCompression() {
        if (this.isSetCompression()) {
            return this.compression;
        }
        throw new PropertyUndefinedError("compression", (SBase)this);
    }

    public boolean isSetCompression() {
        return this.compression != null;
    }

    public void setCompression(CompressionKind compression) {
        CompressionKind oldCompression = this.compression;
        this.compression = compression;
        this.firePropertyChange("compression", (Object)oldCompression, (Object)this.compression);
    }

    public boolean unsetCompression() {
        if (this.isSetCompression()) {
            CompressionKind oldCompression = this.compression;
            this.compression = null;
            this.firePropertyChange("compression", (Object)oldCompression, (Object)this.compression);
            return true;
        }
        return false;
    }

    public InterpolationKind getInterpolationType() {
        if (this.isSetInterpolation()) {
            return this.interpolation;
        }
        throw new PropertyUndefinedError("interpolationType", (SBase)this);
    }

    public InterpolationKind getInterpolation() {
        return this.getInterpolationType();
    }

    public boolean isSetInterpolation() {
        return this.isSetInterpolationType();
    }

    public boolean isSetInterpolationType() {
        return this.interpolation != null;
    }

    public void setInterpolation(InterpolationKind interpolation) {
        this.setInterpolationType(interpolation);
    }

    public void setInterpolationType(InterpolationKind interpolation) {
        InterpolationKind oldInterpolation = this.interpolation;
        this.interpolation = interpolation;
        this.firePropertyChange("interpolationType", (Object)oldInterpolation, (Object)this.interpolation);
    }

    public boolean unsetInterpolation() {
        return this.unsetInterpolationType();
    }

    public boolean unsetInterpolationType() {
        if (this.isSetInterpolation()) {
            InterpolationKind oldInterpolation = this.interpolation;
            this.interpolation = null;
            this.firePropertyChange("interpolationType", (Object)oldInterpolation, (Object)this.interpolation);
            return true;
        }
        return false;
    }

    public String getSamples() {
        if (this.isSetSamples()) {
            return this.samples;
        }
        throw new PropertyUndefinedError("samples", (SBase)this);
    }

    public boolean isSetSamples() {
        return this.samples != null;
    }

    public void setSamples(String samples) {
        String oldSamples = this.samples;
        this.samples = samples;
        this.firePropertyChange("samples", oldSamples, this.samples);
    }

    public boolean unsetSamples() {
        if (this.isSetSamples()) {
            String oldSamples = this.samples;
            this.samples = null;
            this.samplesLength = null;
            this.firePropertyChange("samples", oldSamples, this.samples);
            return true;
        }
        return false;
    }

    public boolean append(String data) {
        if (data == null) {
            return false;
        }
        if (this.isSetSamples()) {
            String oldSamples = this.samples;
            this.samples = this.samples + data;
            this.firePropertyChange("samples", oldSamples, this.samples);
        } else {
            this.setSamples(data);
        }
        return true;
    }

    public int getSamplesLength() {
        if (this.isSetSamplesLength()) {
            return this.samplesLength;
        }
        throw new PropertyUndefinedError("samplesLength", (SBase)this);
    }

    public boolean isSetSamplesLength() {
        return this.samplesLength != null;
    }

    public void setSamplesLength(String samplesLength) {
        Integer oldSamplesLength = this.samplesLength;
        this.samplesLength = StringTools.parseSBMLInt((String)samplesLength);
        this.firePropertyChange("samplesLength", oldSamplesLength, this.samplesLength);
    }

    public void setSamplesLength(int samplesLength) {
        Integer oldSamplesLength = this.samplesLength;
        this.samplesLength = samplesLength;
        this.firePropertyChange("samplesLength", oldSamplesLength, this.samplesLength);
    }

    public boolean unsetSamplesLength() {
        if (this.isSetSamplesLength()) {
            Integer oldSamplesLength = this.samplesLength;
            this.samplesLength = null;
            this.firePropertyChange("samplesLength", oldSamplesLength, this.samplesLength);
            return true;
        }
        return false;
    }

    public String getDataString() {
        if (this.isSetData()) {
            return this.data.getCharacters();
        }
        throw new PropertyUndefinedError("data", (SBase)this);
    }

    public XMLNode getData() {
        if (this.isSetData()) {
            return this.data;
        }
        throw new PropertyUndefinedError("data", (SBase)this);
    }

    public boolean isSetData() {
        return this.data != null;
    }

    public void setData(String data) throws XMLStreamException {
        this.setData(XMLNode.convertStringToXMLNode((String)data));
    }

    public void setData(XMLNode data) {
        XMLNode oldData = this.data;
        this.data = data;
        this.firePropertyChange("data", oldData, this.data);
    }

    public boolean unsetData() {
        if (this.isSetData()) {
            XMLNode oldData = this.data;
            this.data = null;
            this.firePropertyChange("data", oldData, this.data);
            return true;
        }
        return false;
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public int getChildCount() {
        int count = super.getChildCount();
        if (this.isSetData()) {
            ++count;
        }
        return count;
    }

    @Override
    public TreeNode getChildAt(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException(MessageFormat.format(resourceBundle.getString("IndexSurpassesBoundsException"), index, 0));
        }
        int count = super.getChildCount();
        int pos = 0;
        if (index < count) {
            return super.getChildAt(index);
        }
        index -= count;
        if (this.isSetData()) {
            if (pos == index) {
                return this.getData();
            }
            ++pos;
        }
        throw new IndexOutOfBoundsException(MessageFormat.format(resourceBundle.getString("IndexExceedsBoundsException"), index, Math.min(pos, 0)));
    }

    @Override
    public int hashCode() {
        int prime = 1997;
        int hashCode = super.hashCode();
        if (this.isSetNumSamples1()) {
            hashCode += 1997 * this.getNumSamples1();
        }
        if (this.isSetNumSamples2()) {
            hashCode += 1997 * this.getNumSamples2();
        }
        if (this.isSetNumSamples3()) {
            hashCode += 1997 * this.getNumSamples3();
        }
        if (this.isSetDataType()) {
            hashCode += 1997 * this.getDataType().hashCode();
        }
        if (this.isSetCompression()) {
            hashCode += 1997 * this.getCompression().hashCode();
        }
        if (this.isSetSamples()) {
            hashCode += 1997 * this.getSamples().hashCode();
        }
        if (this.isSetSamplesLength()) {
            hashCode += 1997 * this.getSamplesLength();
        }
        if (this.isSetInterpolation()) {
            hashCode += 1997 * this.getInterpolation().hashCode();
        }
        return hashCode;
    }

    @Override
    public Map<String, String> writeXMLAttributes() {
        Map<String, String> attributes = super.writeXMLAttributes();
        if (this.isSetNumSamples1()) {
            attributes.put("spatial:numSamples1", String.valueOf(this.getNumSamples1()));
        }
        if (this.isSetNumSamples2()) {
            attributes.put("spatial:numSamples2", String.valueOf(this.getNumSamples2()));
        }
        if (this.isSetNumSamples3()) {
            attributes.put("spatial:numSamples3", String.valueOf(this.getNumSamples3()));
        }
        if (this.isSetDataType()) {
            attributes.put("spatial:dataType", this.getDataType().toString().toLowerCase());
        }
        if (this.isSetCompression()) {
            attributes.put("spatial:compression", this.getCompression().toString());
        }
        if (this.isSetInterpolation()) {
            attributes.put("spatial:interpolationType", this.getInterpolation().toString());
        }
        if (this.isSetSamplesLength()) {
            attributes.put("spatial:samplesLength", String.valueOf(this.getSamplesLength()));
        }
        return attributes;
    }

    @Override
    public boolean readAttribute(String attributeName, String prefix, String value) {
        boolean isAttributeRead = super.readAttribute(attributeName, prefix, value);
        if (!isAttributeRead) {
            isAttributeRead = true;
            if (attributeName.equals("numSamples1")) {
                try {
                    this.setNumSamples1(StringTools.parseSBMLInt((String)value));
                }
                catch (Exception e) {
                    logger.warn((Object)MessageFormat.format(SpatialConstants.bundle.getString("COULD_NOT_READ_ATTRIBUTE"), value, "numSamples1", this.getElementName()));
                }
            } else if (attributeName.equals("numSamples2")) {
                try {
                    this.setNumSamples2(StringTools.parseSBMLInt((String)value));
                }
                catch (Exception e) {
                    logger.warn((Object)MessageFormat.format(SpatialConstants.bundle.getString("COULD_NOT_READ_ATTRIBUTE"), value, "numSamples2", this.getElementName()));
                }
            } else if (attributeName.equals("numSamples3")) {
                try {
                    this.setNumSamples3(StringTools.parseSBMLInt((String)value));
                }
                catch (Exception e) {
                    logger.warn((Object)MessageFormat.format(SpatialConstants.bundle.getString("COULD_NOT_READ_ATTRIBUTE"), value, "numSamples3", this.getElementName()));
                }
            } else if (attributeName.equals("interpolationType") || attributeName.equals("interpolation")) {
                try {
                    this.setInterpolation(InterpolationKind.valueOf(value));
                }
                catch (Exception e) {
                    logger.warn((Object)MessageFormat.format(SpatialConstants.bundle.getString("COULD_NOT_READ_ATTRIBUTE"), value, "interpolationType", this.getElementName()));
                }
            } else if (attributeName.equals("compression")) {
                try {
                    this.setCompression(CompressionKind.valueOf(value));
                }
                catch (Exception e) {
                    logger.warn((Object)MessageFormat.format(SpatialConstants.bundle.getString("COULD_NOT_READ_ATTRIBUTE"), value, "compression", this.getElementName()));
                }
            } else if (attributeName.equals("samplesLength")) {
                try {
                    this.setSamplesLength(String.valueOf(value));
                }
                catch (Exception e) {
                    logger.warn((Object)MessageFormat.format(SpatialConstants.bundle.getString("COULD_NOT_READ_ATTRIBUTE"), value, "samplesLength", this.getElementName()));
                }
            } else if (attributeName.equals("dataType")) {
                try {
                    this.setDataType(DataKind.valueOf(value.toUpperCase()));
                }
                catch (Exception e) {
                    logger.warn((Object)MessageFormat.format(SpatialConstants.bundle.getString("COULD_NOT_READ_ATTRIBUTE"), value, "dataType", this.getElementName()));
                }
            } else {
                isAttributeRead = false;
            }
        }
        return isAttributeRead;
    }
}

