/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.spatial;

import java.text.MessageFormat;
import java.util.Map;
import org.apache.log4j.Logger;
import org.sbml.jsbml.AbstractSBase;
import org.sbml.jsbml.PropertyUndefinedError;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.spatial.CompressionKind;
import org.sbml.jsbml.ext.spatial.DataKind;
import org.sbml.jsbml.ext.spatial.SpatialConstants;
import org.sbml.jsbml.util.StringTools;

public class SpatialPoints
extends AbstractSBase {
    private static final transient Logger logger = Logger.getLogger(SpatialPoints.class);
    private static final long serialVersionUID = -3467717442431545263L;
    private CompressionKind compression;
    private Integer arrayDataLength;
    private DataKind dataType;
    private String arrayData;

    public SpatialPoints() {
        this.initDefaults();
    }

    public SpatialPoints(int level, int version) {
        super(level, version);
    }

    public SpatialPoints(SpatialPoints sp) {
        super((SBase)sp);
        if (sp.isSetCompression()) {
            this.setCompression(sp.getCompression());
        }
        if (sp.isSetArrayDataLength()) {
            this.setArrayDataLength(sp.getArrayDataLength());
        }
        if (sp.isSetDataType()) {
            this.setDataType(sp.getDataType());
        }
        if (sp.isSetArrayData()) {
            this.setArrayData(sp.getArrayData());
        }
    }

    public SpatialPoints clone() {
        return new SpatialPoints(this);
    }

    public boolean equals(Object object) {
        boolean equal = super.equals(object);
        if (equal) {
            SpatialPoints sp = (SpatialPoints)((Object)object);
            if ((equal &= sp.isSetCompression() == this.isSetCompression()) && this.isSetCompression()) {
                equal &= sp.getCompression().equals((Object)this.getCompression());
            }
            if ((equal &= sp.isSetArrayData() == this.isSetArrayData()) && this.isSetArrayData()) {
                equal &= sp.getArrayData() == this.getArrayData();
            }
            if ((equal &= sp.isSetArrayDataLength() == this.isSetArrayDataLength()) && this.isSetArrayDataLength()) {
                equal &= sp.getArrayDataLength() == this.getArrayDataLength();
            }
            if ((equal &= sp.isSetDataType() == this.isSetDataType()) && this.isSetDataType()) {
                equal &= sp.getDataType().equals((Object)this.getDataType());
            }
        }
        return equal;
    }

    public void initDefaults() {
        this.packageName = "spatial";
        this.setPackageVersion(-1);
    }

    public CompressionKind getCompression() {
        if (this.isSetCompression()) {
            return this.compression;
        }
        throw new PropertyUndefinedError("compression", (SBase)this);
    }

    public boolean isSetCompression() {
        return this.compression != null;
    }

    public void setCompression(String compression) {
        this.setCompression(CompressionKind.valueOf(compression));
    }

    public void setCompression(CompressionKind compression) {
        CompressionKind oldCompression = this.compression;
        this.compression = compression;
        this.firePropertyChange("compression", (Object)oldCompression, (Object)this.compression);
    }

    public boolean unsetCompression() {
        if (this.isSetCompression()) {
            CompressionKind oldCompression = this.compression;
            this.compression = null;
            this.firePropertyChange("compression", (Object)oldCompression, (Object)this.compression);
            return true;
        }
        return false;
    }

    public String getArrayData() {
        if (this.isSetArrayData()) {
            return this.arrayData;
        }
        throw new PropertyUndefinedError("arrayData", (SBase)this);
    }

    public boolean isSetArrayData() {
        return this.arrayData != null;
    }

    public void setArrayData(String arrayData) {
        String oldArrayData = this.arrayData;
        this.arrayData = arrayData;
        this.firePropertyChange("arrayData", oldArrayData, this.arrayData);
    }

    public boolean unsetArrayData() {
        if (this.isSetArrayData()) {
            String oldArrayData = this.arrayData;
            this.arrayData = null;
            this.arrayDataLength = null;
            this.firePropertyChange("arrayData", oldArrayData, this.arrayData);
            return true;
        }
        return false;
    }

    public boolean append(String data) {
        if (data == null) {
            return false;
        }
        if (this.isSetArrayData()) {
            String oldArrayData = this.arrayData;
            this.arrayData = this.arrayData + data;
            this.firePropertyChange("arrayData", oldArrayData, this.arrayData);
        } else {
            this.setArrayData(data);
        }
        return true;
    }

    public int getArrayDataLength() {
        if (this.isSetArrayDataLength()) {
            return this.arrayDataLength;
        }
        throw new PropertyUndefinedError("arrayDataLength", (SBase)this);
    }

    public boolean isSetArrayDataLength() {
        return this.arrayDataLength != null;
    }

    public void setArrayDataLength(int arrayDataLength) {
        Integer oldArrayDataLength = this.arrayDataLength;
        this.arrayDataLength = arrayDataLength;
        this.firePropertyChange("arrayDataLength", oldArrayDataLength, this.arrayDataLength);
    }

    public boolean unsetArrayDataLength() {
        if (this.isSetArrayDataLength()) {
            Integer oldArrayDataLength = this.arrayDataLength;
            this.arrayDataLength = null;
            this.firePropertyChange("arrayDataLength", oldArrayDataLength, this.arrayDataLength);
            return true;
        }
        return false;
    }

    public DataKind getDataType() {
        if (this.isSetDataType()) {
            return this.dataType;
        }
        throw new PropertyUndefinedError("dataType", (SBase)this);
    }

    public boolean isSetDataType() {
        return this.dataType != null;
    }

    public void setDataType(String dataType) {
        this.setDataType(DataKind.valueOf(dataType));
    }

    public void setDataType(DataKind dataType) {
        DataKind oldDataType = this.dataType;
        this.dataType = dataType;
        this.firePropertyChange("dataType", (Object)oldDataType, (Object)this.dataType);
    }

    public boolean unsetDataType() {
        if (this.isSetDataType()) {
            DataKind oldDataType = this.dataType;
            this.dataType = null;
            this.firePropertyChange("dataType", (Object)oldDataType, (Object)this.dataType);
            return true;
        }
        return false;
    }

    public int hashCode() {
        int prime = 2011;
        int hashCode = super.hashCode();
        if (this.isSetCompression()) {
            hashCode += 2011 * this.getCompression().hashCode();
        }
        if (this.isSetArrayDataLength()) {
            hashCode += 2011 * this.getArrayDataLength();
        }
        if (this.isSetArrayData()) {
            hashCode += 2011 * this.getArrayData().hashCode();
        }
        if (this.isSetDataType()) {
            hashCode += 2011 * this.getDataType().hashCode();
        }
        return hashCode;
    }

    public Map<String, String> writeXMLAttributes() {
        Map attributes = super.writeXMLAttributes();
        if (this.isSetCompression()) {
            attributes.remove("compression");
            attributes.put("spatial:compression", this.getCompression().toString());
        }
        if (this.isSetArrayDataLength()) {
            attributes.remove("arrayDataLength");
            attributes.put("spatial:arrayDataLength", String.valueOf(this.getArrayDataLength()));
        }
        if (this.isSetDataType()) {
            attributes.remove("dataType");
            attributes.put("spatial:dataType", this.getDataType().toString().toLowerCase());
        }
        return attributes;
    }

    public boolean readAttribute(String attributeName, String prefix, String value) {
        boolean isAttributeRead;
        boolean bl = isAttributeRead = super.readAttribute(attributeName, prefix, value) && "spatial" == prefix;
        if (!isAttributeRead) {
            isAttributeRead = true;
            if (attributeName.equals("compression")) {
                try {
                    this.setCompression(value);
                }
                catch (Exception e) {
                    logger.warn((Object)MessageFormat.format(SpatialConstants.bundle.getString("COULD_NOT_READ_ATTRIBUTE"), value, "compression", this.getElementName()));
                }
            } else if (attributeName.equals("arrayDataLength")) {
                try {
                    this.setArrayDataLength(StringTools.parseSBMLInt((String)value));
                }
                catch (Exception e) {
                    logger.warn((Object)MessageFormat.format(SpatialConstants.bundle.getString("COULD_NOT_READ_ATTRIBUTE"), value, "arrayDataLength", this.getElementName()));
                }
            } else if (attributeName.equals("dataType")) {
                try {
                    this.setDataType(value.toUpperCase());
                }
                catch (Exception e) {
                    logger.warn((Object)MessageFormat.format(SpatialConstants.bundle.getString("COULD_NOT_READ_ATTRIBUTE"), value, "dataType", this.getElementName()));
                }
            } else {
                isAttributeRead = false;
            }
        }
        return isAttributeRead;
    }
}

