/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.xml.parsers;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.sbml.jsbml.ASTNode;
import org.sbml.jsbml.Compartment;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.Parameter;
import org.sbml.jsbml.Reaction;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.Species;
import org.sbml.jsbml.ext.ASTNodePlugin;
import org.sbml.jsbml.ext.SBasePlugin;
import org.sbml.jsbml.ext.spatial.AbstractSpatialNamedSBase;
import org.sbml.jsbml.ext.spatial.AdjacentDomains;
import org.sbml.jsbml.ext.spatial.AdvectionCoefficient;
import org.sbml.jsbml.ext.spatial.AnalyticGeometry;
import org.sbml.jsbml.ext.spatial.AnalyticVolume;
import org.sbml.jsbml.ext.spatial.Boundary;
import org.sbml.jsbml.ext.spatial.BoundaryCondition;
import org.sbml.jsbml.ext.spatial.CSGHomogeneousTransformation;
import org.sbml.jsbml.ext.spatial.CSGNode;
import org.sbml.jsbml.ext.spatial.CSGObject;
import org.sbml.jsbml.ext.spatial.CSGPrimitive;
import org.sbml.jsbml.ext.spatial.CSGPseudoPrimitive;
import org.sbml.jsbml.ext.spatial.CSGRotation;
import org.sbml.jsbml.ext.spatial.CSGScale;
import org.sbml.jsbml.ext.spatial.CSGSetOperator;
import org.sbml.jsbml.ext.spatial.CSGTransformation;
import org.sbml.jsbml.ext.spatial.CSGTranslation;
import org.sbml.jsbml.ext.spatial.CSGeometry;
import org.sbml.jsbml.ext.spatial.CompartmentMapping;
import org.sbml.jsbml.ext.spatial.CoordinateComponent;
import org.sbml.jsbml.ext.spatial.DiffusionCoefficient;
import org.sbml.jsbml.ext.spatial.Domain;
import org.sbml.jsbml.ext.spatial.DomainType;
import org.sbml.jsbml.ext.spatial.Geometry;
import org.sbml.jsbml.ext.spatial.GeometryDefinition;
import org.sbml.jsbml.ext.spatial.InteriorPoint;
import org.sbml.jsbml.ext.spatial.ParametricGeometry;
import org.sbml.jsbml.ext.spatial.ParametricObject;
import org.sbml.jsbml.ext.spatial.SampledField;
import org.sbml.jsbml.ext.spatial.SampledFieldGeometry;
import org.sbml.jsbml.ext.spatial.SampledVolume;
import org.sbml.jsbml.ext.spatial.SpatialCompartmentPlugin;
import org.sbml.jsbml.ext.spatial.SpatialConstants;
import org.sbml.jsbml.ext.spatial.SpatialModelPlugin;
import org.sbml.jsbml.ext.spatial.SpatialParameterPlugin;
import org.sbml.jsbml.ext.spatial.SpatialPoints;
import org.sbml.jsbml.ext.spatial.SpatialReactionPlugin;
import org.sbml.jsbml.ext.spatial.SpatialSpeciesPlugin;
import org.sbml.jsbml.ext.spatial.SpatialSymbolReference;
import org.sbml.jsbml.ext.spatial.TransformationComponent;
import org.sbml.jsbml.xml.parsers.AbstractReaderWriter;
import org.sbml.jsbml.xml.parsers.PackageParser;
import org.sbml.jsbml.xml.stax.SBMLObjectForXML;

public class SpatialParser
extends AbstractReaderWriter
implements PackageParser {
    private static final transient Logger logger = Logger.getLogger(SpatialParser.class);
    public static final String namespaceURIrequired = "http://www.sbml.org/sbml/level3/version1/req/version1";

    public void processCharactersOf(String elementName, String characters, Object contextObject) {
        if (contextObject instanceof SampledField) {
            SampledField sampledField = (SampledField)contextObject;
            sampledField.append(characters);
        } else if (contextObject instanceof SpatialPoints) {
            SpatialPoints spatialPoints = (SpatialPoints)((Object)contextObject);
            spatialPoints.append(characters);
        } else if (contextObject instanceof ParametricObject) {
            ParametricObject parametricObject = (ParametricObject)contextObject;
            parametricObject.append(characters);
        }
    }

    public void writeCharacters(SBMLObjectForXML xmlObject, Object sbmlElementToWrite) {
        ParametricObject parametricObject;
        if (sbmlElementToWrite instanceof SampledField) {
            SampledField sampledField = (SampledField)sbmlElementToWrite;
            if (sampledField.isSetSamples()) {
                xmlObject.setCharacters(sampledField.getSamples());
            }
        } else if (sbmlElementToWrite instanceof SpatialPoints) {
            SpatialPoints spatialPoints = (SpatialPoints)((Object)sbmlElementToWrite);
            if (spatialPoints.isSetArrayData()) {
                xmlObject.setCharacters(spatialPoints.getArrayData());
            }
        } else if (sbmlElementToWrite instanceof ParametricObject && (parametricObject = (ParametricObject)sbmlElementToWrite).isSetPointIndex()) {
            xmlObject.setCharacters(parametricObject.getPointIndex());
        }
    }

    public String getShortLabel() {
        return "spatial";
    }

    public String getNamespaceURI() {
        return "http://www.sbml.org/sbml/level3/version1/spatial/version1";
    }

    public List<Object> getListOfSBMLElementsToWrite(Object treeNode) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getListOfSBMLElementsToWrite: " + treeNode.getClass().getCanonicalName()));
        }
        List listOfElementsToWrite = new ArrayList();
        if (treeNode instanceof SBase && !(treeNode instanceof Model) && ((SBase)treeNode).getExtension(this.getNamespaceURI()) != null) {
            SBasePlugin sbasePlugin = ((SBase)treeNode).getExtension(this.getNamespaceURI());
            if (sbasePlugin != null) {
                listOfElementsToWrite = super.getListOfSBMLElementsToWrite((Object)sbasePlugin);
                logger.debug((Object)("getListOfSBMLElementsToWrite: nb children = " + sbasePlugin.getChildCount()));
            }
        } else {
            listOfElementsToWrite = super.getListOfSBMLElementsToWrite(treeNode);
        }
        return listOfElementsToWrite;
    }

    public void writeElement(SBMLObjectForXML xmlObject, Object sbmlElementToWrite) {
        super.writeElement(xmlObject, sbmlElementToWrite);
        if (xmlObject.getName().equals("listOfCSGeometrys") || xmlObject.getName().equals("listOfAnalyticGeometrys") || xmlObject.getName().equals("listOfSampledFieldGeometrys") || xmlObject.getName().equals("listOfParametricGeometrys") || xmlObject.getName().equals("listOfMixedGeometrys")) {
            xmlObject.setName("listOfGeometryDefinitions");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("writeElement: " + sbmlElementToWrite.getClass().getSimpleName()));
        }
    }

    public boolean processAttribute(String elementName, String attributeName, String value, String uri, String prefix, boolean isLastAttribute, Object contextObject) {
        if (contextObject instanceof Species) {
            Species species = (Species)contextObject;
            SpatialSpeciesPlugin spatialSpecies = null;
            if (species.getExtension("http://www.sbml.org/sbml/level3/version1/spatial/version1") != null) {
                spatialSpecies = (SpatialSpeciesPlugin)species.getExtension("http://www.sbml.org/sbml/level3/version1/spatial/version1");
            } else {
                spatialSpecies = new SpatialSpeciesPlugin(species);
                species.addExtension("http://www.sbml.org/sbml/level3/version1/spatial/version1", (SBasePlugin)spatialSpecies);
            }
            contextObject = spatialSpecies;
        } else if (contextObject instanceof Reaction) {
            Reaction reaction = (Reaction)contextObject;
            SpatialReactionPlugin spatialReaction = null;
            if (reaction.getExtension("http://www.sbml.org/sbml/level3/version1/spatial/version1") != null) {
                spatialReaction = (SpatialReactionPlugin)reaction.getExtension("http://www.sbml.org/sbml/level3/version1/spatial/version1");
            } else {
                spatialReaction = new SpatialReactionPlugin(reaction);
                reaction.addExtension("http://www.sbml.org/sbml/level3/version1/spatial/version1", (SBasePlugin)spatialReaction);
            }
            contextObject = spatialReaction;
        }
        return super.processAttribute(elementName, attributeName, value, uri, prefix, isLastAttribute, contextObject);
    }

    public Object processStartElement(String elementName, String uri, String prefix, boolean hasAttributes, boolean hasNamespaces, Object contextObject) {
        if (contextObject instanceof Model) {
            Model model = (Model)contextObject;
            SpatialModelPlugin spatialModel = null;
            if (model.getExtension("http://www.sbml.org/sbml/level3/version1/spatial/version1") != null) {
                spatialModel = (SpatialModelPlugin)model.getExtension("http://www.sbml.org/sbml/level3/version1/spatial/version1");
            } else {
                spatialModel = new SpatialModelPlugin(model);
                model.addExtension("http://www.sbml.org/sbml/level3/version1/spatial/version1", (SBasePlugin)spatialModel);
            }
            if (elementName.equals("geometry")) {
                Geometry geometry = new Geometry();
                spatialModel.setGeometry(geometry);
                return geometry;
            }
        } else if (contextObject instanceof Compartment) {
            Compartment compartment = (Compartment)contextObject;
            SpatialCompartmentPlugin spatialCompartment = null;
            if (compartment.getExtension("http://www.sbml.org/sbml/level3/version1/spatial/version1") != null) {
                spatialCompartment = (SpatialCompartmentPlugin)compartment.getExtension("http://www.sbml.org/sbml/level3/version1/spatial/version1");
            } else {
                spatialCompartment = new SpatialCompartmentPlugin(compartment);
                compartment.addExtension("http://www.sbml.org/sbml/level3/version1/spatial/version1", (SBasePlugin)spatialCompartment);
            }
            if (elementName.equals("compartmentMapping")) {
                CompartmentMapping compartmentMapping = new CompartmentMapping();
                spatialCompartment.setCompartmentMapping(compartmentMapping);
                return compartmentMapping;
            }
        } else if (contextObject instanceof Parameter) {
            Parameter param = (Parameter)contextObject;
            SpatialParameterPlugin spatialParam = null;
            if (param.getExtension("http://www.sbml.org/sbml/level3/version1/spatial/version1") != null) {
                spatialParam = (SpatialParameterPlugin)param.getExtension("http://www.sbml.org/sbml/level3/version1/spatial/version1");
            } else {
                spatialParam = new SpatialParameterPlugin(param);
                param.addExtension("http://www.sbml.org/sbml/level3/version1/spatial/version1", (SBasePlugin)spatialParam);
            }
            if (elementName.equals("spatialSymbolReference")) {
                SpatialSymbolReference ssr = new SpatialSymbolReference();
                spatialParam.setParamType(ssr);
                return ssr;
            }
            if (elementName.equals("diffusionCoefficient")) {
                DiffusionCoefficient dc = new DiffusionCoefficient();
                spatialParam.setParamType(dc);
                return dc;
            }
            if (elementName.equals("advectionCoefficient")) {
                AdvectionCoefficient ac = new AdvectionCoefficient();
                spatialParam.setParamType(ac);
                return ac;
            }
            if (elementName.equals("boundaryCondition")) {
                BoundaryCondition bc = new BoundaryCondition();
                spatialParam.setParamType(bc);
                return bc;
            }
        } else if (contextObject instanceof Geometry) {
            Geometry geometry = (Geometry)contextObject;
            if (elementName.equals("listOfCoordinateComponents")) {
                ListOf<CoordinateComponent> listOfCoordinateComponents = geometry.getListOfCoordinateComponents();
                return listOfCoordinateComponents;
            }
            if (elementName.equals("listOfDomainTypes")) {
                ListOf<DomainType> listOfDomainTypes = geometry.getListOfDomainTypes();
                return listOfDomainTypes;
            }
            if (elementName.equals("listOfDomains")) {
                ListOf<Domain> listOfDomains = geometry.getListOfDomains();
                return listOfDomains;
            }
            if (elementName.equals("listOfAdjacentDomains")) {
                ListOf<AdjacentDomains> listOfAdjacentDomains = geometry.getListOfAdjacentDomains();
                return listOfAdjacentDomains;
            }
            if (elementName.equals("listOfGeometryDefinitions")) {
                ListOf<GeometryDefinition> listOfGeometryDefinitions = geometry.getListOfGeometryDefinitions();
                return listOfGeometryDefinitions;
            }
            if (elementName.equals(SpatialConstants.listOfSampledFields)) {
                ListOf<SampledField> listOfSampledFields = geometry.getListOfSampledFields();
                return listOfSampledFields;
            }
        } else if (contextObject instanceof CoordinateComponent) {
            CoordinateComponent cc = (CoordinateComponent)contextObject;
            if (elementName.equals("boundaryMin")) {
                Boundary boundary = new Boundary();
                cc.setBoundaryMinimum(boundary);
                return boundary;
            }
            if (elementName.equals("boundaryMax")) {
                Boundary boundary = new Boundary();
                cc.setBoundaryMaximum(boundary);
                return boundary;
            }
        } else if (contextObject instanceof Domain) {
            Domain domain = (Domain)contextObject;
            if (elementName.equals("listOfInteriorPoints")) {
                ListOf<InteriorPoint> listOfInteriorPoints = domain.getListOfInteriorPoints();
                return listOfInteriorPoints;
            }
        } else if (contextObject instanceof AnalyticGeometry) {
            AnalyticGeometry analyticGeometry = (AnalyticGeometry)contextObject;
            if (elementName.equals("listOfAnalyticVolumes")) {
                ListOf<AnalyticVolume> listOfAnalyticVolumes = analyticGeometry.getListOfAnalyticVolumes();
                return listOfAnalyticVolumes;
            }
        } else if (contextObject instanceof SampledFieldGeometry) {
            SampledFieldGeometry sfg = (SampledFieldGeometry)contextObject;
            if (elementName.equals("listOfSampledVolumes")) {
                ListOf<SampledVolume> listOfSampledVolumes = sfg.getListOfSampledVolumes();
                return listOfSampledVolumes;
            }
        } else if (contextObject instanceof CSGeometry) {
            CSGeometry csg = (CSGeometry)contextObject;
            if (elementName.equals("listOfCSGObjects")) {
                ListOf<CSGObject> listOfCSGObjects = csg.getListOfCSGObjects();
                return listOfCSGObjects;
            }
        } else if (contextObject instanceof CSGObject) {
            CSGObject cso = (CSGObject)contextObject;
            if (elementName.equals("csgPrimitive")) {
                CSGPrimitive csgNode = new CSGPrimitive();
                cso.setCSGNode(csgNode);
                return csgNode;
            }
            if (elementName.equals("csgPseudoPrimitive")) {
                CSGPseudoPrimitive csgNode = new CSGPseudoPrimitive();
                cso.setCSGNode(csgNode);
                return csgNode;
            }
            if (elementName.equals("csgSetOperator")) {
                CSGSetOperator csgNode = new CSGSetOperator();
                cso.setCSGNode(csgNode);
                return csgNode;
            }
            if (elementName.equals("csgTranslation")) {
                CSGTranslation csgNode = new CSGTranslation();
                cso.setCSGNode(csgNode);
                return csgNode;
            }
            if (elementName.equals("csgRotation")) {
                CSGRotation csgNode = new CSGRotation();
                cso.setCSGNode(csgNode);
                return csgNode;
            }
            if (elementName.equals("csgScale")) {
                CSGScale csgNode = new CSGScale();
                cso.setCSGNode(csgNode);
                return csgNode;
            }
            if (elementName.equals("csgHomogeneousTransformation")) {
                CSGHomogeneousTransformation csgNode = new CSGHomogeneousTransformation();
                cso.setCSGNode(csgNode);
                return csgNode;
            }
        } else {
            if (contextObject instanceof CSGScale) {
                CSGScale csgParent = (CSGScale)contextObject;
                return this.setCSGNode(csgParent, elementName);
            }
            if (contextObject instanceof CSGRotation) {
                CSGRotation csgParent = (CSGRotation)contextObject;
                return this.setCSGNode(csgParent, elementName);
            }
            if (contextObject instanceof CSGTranslation) {
                CSGTranslation csgParent = (CSGTranslation)contextObject;
                return this.setCSGNode(csgParent, elementName);
            }
            if (contextObject instanceof CSGSetOperator) {
                CSGSetOperator csgso = (CSGSetOperator)contextObject;
                if (elementName.equals("listOfCSGNodes")) {
                    ListOf<CSGNode> listOfCSGNodes = csgso.getListOfCSGNodes();
                    return listOfCSGNodes;
                }
            } else if (contextObject instanceof CSGHomogeneousTransformation) {
                CSGHomogeneousTransformation csght = (CSGHomogeneousTransformation)contextObject;
                if (elementName.equals("forwardTransformation")) {
                    TransformationComponent tc = new TransformationComponent();
                    csght.setForwardTransformation(tc);
                    return tc;
                }
                if (elementName.equals("reverseTransformation")) {
                    TransformationComponent tc = new TransformationComponent();
                    csght.setReverseTransformation(tc);
                    return tc;
                }
            } else if (contextObject instanceof ParametricGeometry) {
                ParametricGeometry pg = (ParametricGeometry)contextObject;
                if (elementName.equals("spatialPoints")) {
                    SpatialPoints sp = new SpatialPoints();
                    pg.setSpatialPoints(sp);
                    return sp;
                }
                if (elementName.equals("listOfParametricObjects")) {
                    ListOf<ParametricObject> listOfParametricObjects = pg.getListOfParametricObjects();
                    return listOfParametricObjects;
                }
            } else if (contextObject instanceof ListOf) {
                ListOf listOf = (ListOf)contextObject;
                if (elementName.equals("coordinateComponent")) {
                    Geometry geo = (Geometry)listOf.getParentSBMLObject();
                    CoordinateComponent elem = new CoordinateComponent();
                    geo.addCoordinateComponent(elem);
                    return elem;
                }
                if (elementName.equals("domainType")) {
                    Geometry geo = (Geometry)listOf.getParentSBMLObject();
                    DomainType elem = new DomainType();
                    geo.addDomainType(elem);
                    return elem;
                }
                if (elementName.equals("domain")) {
                    Geometry geo = (Geometry)listOf.getParentSBMLObject();
                    Domain elem = new Domain();
                    geo.addDomain(elem);
                    return elem;
                }
                if (elementName.equals("adjacentDomains")) {
                    Geometry geo = (Geometry)listOf.getParentSBMLObject();
                    AdjacentDomains elem = new AdjacentDomains();
                    geo.addAdjacentDomain(elem);
                    return elem;
                }
                if (elementName.equals("sampledFieldGeometry")) {
                    Geometry geo = (Geometry)listOf.getParentSBMLObject();
                    SampledFieldGeometry elem = new SampledFieldGeometry();
                    geo.addGeometryDefinition(elem);
                    return elem;
                }
                if (elementName.equals("analyticGeometry")) {
                    Geometry geo = (Geometry)listOf.getParentSBMLObject();
                    AnalyticGeometry elem = new AnalyticGeometry();
                    geo.addGeometryDefinition(elem);
                    return elem;
                }
                if (elementName.equals("analyticGeometry")) {
                    Geometry geo = (Geometry)listOf.getParentSBMLObject();
                    AnalyticGeometry elem = new AnalyticGeometry();
                    geo.addGeometryDefinition(elem);
                    return elem;
                }
                if (elementName.equals("csGeometry")) {
                    Geometry geo = (Geometry)listOf.getParentSBMLObject();
                    CSGeometry elem = new CSGeometry();
                    geo.addGeometryDefinition(elem);
                    return elem;
                }
                if (elementName.equals("parametricGeometry")) {
                    Geometry geo = (Geometry)listOf.getParentSBMLObject();
                    ParametricGeometry elem = new ParametricGeometry();
                    geo.addGeometryDefinition(elem);
                    return elem;
                }
                if (elementName.equals("interiorPoint")) {
                    Domain domain = (Domain)listOf.getParentSBMLObject();
                    InteriorPoint elem = new InteriorPoint();
                    domain.addInteriorPoint(elem);
                    return elem;
                }
                if (elementName.equals("analyticVolume")) {
                    AnalyticGeometry av = (AnalyticGeometry)listOf.getParentSBMLObject();
                    AnalyticVolume elem = new AnalyticVolume();
                    av.addAnalyticVolume(elem);
                    return elem;
                }
                if (elementName.equals("sampledVolume")) {
                    SampledFieldGeometry sfg = (SampledFieldGeometry)listOf.getParentSBMLObject();
                    SampledVolume elem = new SampledVolume();
                    sfg.addSampledVolume(elem);
                    return elem;
                }
                if (elementName.equals("sampledField")) {
                    Geometry g = (Geometry)listOf.getParentSBMLObject();
                    SampledField elem = new SampledField();
                    g.addSampledField(elem);
                    return elem;
                }
                if (elementName.equals("csgObject")) {
                    CSGObject elem = new CSGObject();
                    CSGeometry g = (CSGeometry)listOf.getParentSBMLObject();
                    g.addCSGObject(elem);
                    return elem;
                }
                if (elementName.equals("csgPrimitive")) {
                    CSGPrimitive elem = new CSGPrimitive();
                    this.addCSGNode((AbstractSpatialNamedSBase)listOf.getParentSBMLObject(), elem);
                    return elem;
                }
                if (elementName.equals("csgPseudoPrimitive")) {
                    CSGPseudoPrimitive elem = new CSGPseudoPrimitive();
                    this.addCSGNode((AbstractSpatialNamedSBase)listOf.getParentSBMLObject(), elem);
                    return elem;
                }
                if (elementName.equals("csgSetOperator")) {
                    CSGSetOperator elem = new CSGSetOperator();
                    this.addCSGNode((AbstractSpatialNamedSBase)listOf.getParentSBMLObject(), elem);
                    return elem;
                }
                if (elementName.equals("csgTranslation")) {
                    CSGTranslation elem = new CSGTranslation();
                    this.addCSGNode((AbstractSpatialNamedSBase)listOf.getParentSBMLObject(), elem);
                    return elem;
                }
                if (elementName.equals("csgRotation")) {
                    CSGRotation elem = new CSGRotation();
                    this.addCSGNode((AbstractSpatialNamedSBase)listOf.getParentSBMLObject(), elem);
                    return elem;
                }
                if (elementName.equals("csgScale")) {
                    CSGScale elem = new CSGScale();
                    this.addCSGNode((AbstractSpatialNamedSBase)listOf.getParentSBMLObject(), elem);
                    return elem;
                }
                if (elementName.equals("csgHomogeneousTransformation")) {
                    CSGHomogeneousTransformation elem = new CSGHomogeneousTransformation();
                    this.addCSGNode((AbstractSpatialNamedSBase)listOf.getParentSBMLObject(), elem);
                    return elem;
                }
                if (elementName.equals("spatialPoints")) {
                    ParametricGeometry pg = (ParametricGeometry)listOf.getParentSBMLObject();
                    SpatialPoints elem = new SpatialPoints();
                    pg.setSpatialPoints(elem);
                    return elem;
                }
                if (elementName.equals("parametricObject")) {
                    ParametricGeometry pg = (ParametricGeometry)listOf.getParentSBMLObject();
                    ParametricObject elem = new ParametricObject();
                    pg.addParametricObject(elem);
                    return elem;
                }
            }
        }
        return contextObject;
    }

    private CSGNode setCSGNode(CSGTransformation csgT, String elementName) {
        if (elementName.equals("csgPrimitive")) {
            CSGPrimitive csgNode = new CSGPrimitive();
            csgT.setCSGNode(csgNode);
            return csgNode;
        }
        if (elementName.equals("csgPseudoPrimitive")) {
            CSGPseudoPrimitive csgNode = new CSGPseudoPrimitive();
            csgT.setCSGNode(csgNode);
            return csgNode;
        }
        if (elementName.equals("csgSetOperator")) {
            CSGSetOperator csgNode = new CSGSetOperator();
            csgT.setCSGNode(csgNode);
            return csgNode;
        }
        if (elementName.equals("csgTranslation")) {
            CSGTranslation csgNode = new CSGTranslation();
            csgT.setCSGNode(csgNode);
            return csgNode;
        }
        if (elementName.equals("csgRotation")) {
            CSGRotation csgNode = new CSGRotation();
            csgT.setCSGNode(csgNode);
            return csgNode;
        }
        if (elementName.equals("csgScale")) {
            CSGScale csgNode = new CSGScale();
            csgT.setCSGNode(csgNode);
            return csgNode;
        }
        if (elementName.equals("csgHomogeneousTransformation")) {
            CSGHomogeneousTransformation csgNode = new CSGHomogeneousTransformation();
            csgT.setCSGNode(csgNode);
            return csgNode;
        }
        return null;
    }

    private void addCSGNode(AbstractSpatialNamedSBase parent, CSGNode csgNode) {
        if (parent.getParentSBMLObject() instanceof CSGTransformation) {
            CSGTransformation csgso = (CSGTransformation)parent.getParentSBMLObject();
            csgso.setCSGNode(csgNode);
        } else if (parent.getParentSBMLObject() instanceof CSGSetOperator) {
            CSGSetOperator csgso = (CSGSetOperator)parent.getParentSBMLObject();
            csgso.addCSGNode(csgNode);
        } else if (parent.getParentSBMLObject() instanceof CSGObject) {
            CSGObject csgso = (CSGObject)parent.getParentSBMLObject();
            csgso.setCSGNode(csgNode);
        }
    }

    public String getNamespaceFor(int level, int version, int packageVersion) {
        if (level == 3 && version == 1 && packageVersion == 1) {
            return "http://www.sbml.org/sbml/level3/version1/spatial/version1";
        }
        return null;
    }

    public List<String> getNamespaces() {
        return SpatialConstants.namespaces;
    }

    public List<String> getPackageNamespaces() {
        return this.getNamespaces();
    }

    public String getPackageName() {
        return "spatial";
    }

    public boolean isRequired() {
        return true;
    }

    public SBasePlugin createPluginFor(SBase sbase) {
        if (sbase != null) {
            if (sbase instanceof Model) {
                return new SpatialModelPlugin((Model)sbase);
            }
            if (sbase instanceof Compartment) {
                return new SpatialCompartmentPlugin((Compartment)sbase);
            }
            if (sbase instanceof Species) {
                return new SpatialSpeciesPlugin((Species)sbase);
            }
            if (sbase instanceof Parameter) {
                return new SpatialParameterPlugin((Parameter)sbase);
            }
            if (sbase instanceof Reaction) {
                return new SpatialReactionPlugin((Reaction)sbase);
            }
        }
        return null;
    }

    public ASTNodePlugin createPluginFor(ASTNode astNode) {
        return null;
    }
}

