/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.spatial;

import java.text.MessageFormat;
import javax.swing.tree.TreeNode;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.SBMLException;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.spatial.CSGObject;
import org.sbml.jsbml.ext.spatial.GeometryDefinition;

public class CSGeometry
extends GeometryDefinition {
    private static final long serialVersionUID = -3162376343741365280L;
    private ListOf<CSGObject> listOfCSGObjects;

    public CSGeometry() {
    }

    public CSGeometry(CSGeometry csg) {
        super(csg);
        if (csg.isSetListOfCSGObjects()) {
            this.setListOfCSGObjects((ListOf<CSGObject>)csg.getListOfCSGObjects().clone());
        }
    }

    public CSGeometry(int level, int version) {
        super(level, version);
    }

    public CSGeometry(String id, int level, int version) {
        super(id, level, version);
    }

    @Override
    public CSGeometry clone() {
        return new CSGeometry(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CSGeometry other = (CSGeometry)obj;
        return !(this.listOfCSGObjects == null ? other.listOfCSGObjects != null : !this.listOfCSGObjects.equals(other.listOfCSGObjects));
    }

    public boolean isSetListOfCSGObjects() {
        return this.listOfCSGObjects != null && !this.listOfCSGObjects.isEmpty();
    }

    public ListOf<CSGObject> getListOfCSGObjects() {
        if (!this.isSetListOfCSGObjects()) {
            this.listOfCSGObjects = new ListOf(this.getLevel(), this.getVersion());
            this.listOfCSGObjects.setPackageVersion(-1);
            this.listOfCSGObjects.setPackageName(null);
            this.listOfCSGObjects.setPackageName("spatial");
            this.listOfCSGObjects.setSBaseListType(ListOf.Type.other);
            this.registerChild((SBase)this.listOfCSGObjects);
        }
        return this.listOfCSGObjects;
    }

    public void setListOfCSGObjects(ListOf<CSGObject> listOfCSGObjects) {
        this.unsetListOfCSGObjects();
        this.listOfCSGObjects = listOfCSGObjects;
        if (listOfCSGObjects != null) {
            listOfCSGObjects.setPackageVersion(-1);
            listOfCSGObjects.setPackageName(null);
            listOfCSGObjects.setPackageName("spatial");
            listOfCSGObjects.setSBaseListType(ListOf.Type.other);
            this.registerChild((SBase)this.listOfCSGObjects);
        }
    }

    public boolean unsetListOfCSGObjects() {
        if (this.isSetListOfCSGObjects()) {
            ListOf<CSGObject> oldCSGObjects = this.listOfCSGObjects;
            this.listOfCSGObjects = null;
            oldCSGObjects.fireNodeRemovedEvent();
            return true;
        }
        return false;
    }

    public boolean addCSGObject(CSGObject csgo) {
        return this.getListOfCSGObjects().add((SBase)csgo);
    }

    public boolean removeCSGObject(CSGObject csgo) {
        if (this.isSetListOfCSGObjects()) {
            if (this.getListOfCSGObjects().size() == 1) {
                return false;
            }
            return this.getListOfCSGObjects().remove((SBase)csgo);
        }
        return false;
    }

    public void removeCSGObject(int i) {
        if (!this.isSetListOfCSGObjects()) {
            throw new IndexOutOfBoundsException(Integer.toString(i));
        }
        if (this.getListOfCSGObjects().size() == 1) {
            throw new SBMLException("There must be at least one AnalyticVolume defined for this list");
        }
        this.getListOfCSGObjects().remove(i);
    }

    public CSGObject createCSGObject() {
        return this.createCSGObject(null);
    }

    public CSGObject createCSGObject(String id) {
        CSGObject csgo = new CSGObject(id, this.getLevel(), this.getVersion());
        this.addCSGObject(csgo);
        return csgo;
    }

    @Override
    public int hashCode() {
        int prime = 1301;
        int result = super.hashCode();
        result = 1301 * result + (this.listOfCSGObjects == null ? 0 : this.listOfCSGObjects.hashCode());
        return result;
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public int getChildCount() {
        int count = super.getChildCount();
        if (this.isSetListOfCSGObjects()) {
            ++count;
        }
        return count;
    }

    @Override
    public TreeNode getChildAt(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException(index + " < 0");
        }
        int count = super.getChildCount();
        int pos = 0;
        if (index < count) {
            return super.getChildAt(index);
        }
        index -= count;
        if (this.isSetListOfCSGObjects()) {
            if (pos == index) {
                return this.getListOfCSGObjects();
            }
            ++pos;
        }
        throw new IndexOutOfBoundsException(MessageFormat.format("Index {0,number,integer} >= {1,number,integer}", index, Math.min(pos, 0)));
    }

    public int getCSGObjectCount() {
        return this.isSetListOfCSGObjects() ? this.getListOfCSGObjects().size() : 0;
    }

    public int getNumCSGObjects() {
        return this.getCSGObjectCount();
    }

    public String getElementName() {
        return "csGeometry";
    }
}

