/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.spatial;

import java.text.MessageFormat;
import java.util.Map;
import org.apache.log4j.Logger;
import org.sbml.jsbml.PropertyUndefinedError;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.spatial.AbstractSpatialNamedSBase;
import org.sbml.jsbml.ext.spatial.SpatialConstants;
import org.sbml.jsbml.util.StringTools;

public class SampledVolume
extends AbstractSpatialNamedSBase {
    private static final transient Logger logger = Logger.getLogger(SampledVolume.class);
    private static final long serialVersionUID = -8253664900275697978L;
    private String domainType;
    private Double sampledValue;
    private Double minValue;
    private Double maxValue;

    public SampledVolume() {
    }

    public SampledVolume(SampledVolume sv) {
        super(sv);
        if (sv.isSetDomainType()) {
            this.setDomainType(sv.getDomainType());
        }
        if (sv.isSetSampledValue()) {
            this.setSampledValue(sv.getSampledValue());
        }
        if (sv.isSetMinValue()) {
            this.setMinValue(sv.getMinValue());
        }
        if (sv.isSetMaxValue()) {
            this.setMaxValue(sv.getMaxValue());
        }
    }

    public SampledVolume(String id, int level, int version) {
        super(id, level, version);
    }

    @Override
    public SampledVolume clone() {
        return new SampledVolume(this);
    }

    @Override
    public boolean equals(Object object) {
        boolean equal = super.equals(object);
        if (equal) {
            SampledVolume sv = (SampledVolume)object;
            if ((equal &= sv.isSetSampledValue() == this.isSetSampledValue()) && this.isSetSampledValue()) {
                equal &= sv.getSampledValue() == this.getSampledValue();
            }
            if ((equal &= sv.isSetDomainType() == this.isSetDomainType()) && this.isSetDomainType()) {
                equal &= sv.getDomainType().equals(this.getDomainType());
            }
            if ((equal &= sv.isSetMaxValue() == this.isSetMaxValue()) && this.isSetMaxValue()) {
                equal &= sv.getMaxValue() == this.getMaxValue();
            }
            if ((equal &= sv.isSetMinValue() == this.isSetMinValue()) && this.isSetMinValue()) {
                equal &= sv.getMinValue() == this.getMinValue();
            }
        }
        return equal;
    }

    public String getDomainType() {
        if (this.isSetDomainType()) {
            return this.domainType;
        }
        throw new PropertyUndefinedError("domainType", (SBase)this);
    }

    public boolean isSetDomainType() {
        return this.domainType != null;
    }

    public void setDomainType(String domainType) {
        String oldDomainType = this.domainType;
        this.domainType = domainType;
        this.firePropertyChange("domainType", oldDomainType, this.domainType);
    }

    public boolean unsetDomainType() {
        if (this.isSetDomainType()) {
            String oldDomainType = this.domainType;
            this.domainType = null;
            this.firePropertyChange("domainType", oldDomainType, this.domainType);
            return true;
        }
        return false;
    }

    public double getSampledValue() {
        if (this.isSetSampledValue()) {
            return this.sampledValue;
        }
        throw new PropertyUndefinedError("sampledValue", (SBase)this);
    }

    public boolean isSetSampledValue() {
        return this.sampledValue != null;
    }

    public void setSampledValue(double sampledValue) {
        Double oldSampledValue = this.sampledValue;
        this.sampledValue = sampledValue;
        this.firePropertyChange("sampledValue", oldSampledValue, this.sampledValue);
    }

    public boolean unsetSampledValue() {
        if (this.isSetSampledValue()) {
            Double oldSampledValue = this.sampledValue;
            this.sampledValue = null;
            this.firePropertyChange("sampledValue", oldSampledValue, this.sampledValue);
            return true;
        }
        return false;
    }

    public double getMinValue() {
        if (this.isSetMinValue()) {
            return this.minValue;
        }
        throw new PropertyUndefinedError("minValue", (SBase)this);
    }

    public boolean isSetMinValue() {
        return this.minValue != null;
    }

    public void setMinValue(double minValue) {
        Double oldMinValue = this.minValue;
        this.minValue = minValue;
        this.firePropertyChange("minValue", oldMinValue, this.minValue);
    }

    public boolean unsetMinValue() {
        if (this.isSetMinValue()) {
            Double oldMinValue = this.minValue;
            this.minValue = null;
            this.firePropertyChange("minValue", oldMinValue, this.minValue);
            return true;
        }
        return false;
    }

    public double getMaxValue() {
        if (this.isSetMaxValue()) {
            return this.maxValue;
        }
        throw new PropertyUndefinedError("maxValue", (SBase)this);
    }

    public boolean isSetMaxValue() {
        return this.maxValue != null;
    }

    public void setMaxValue(double maxValue) {
        Double oldMaxValue = this.maxValue;
        this.maxValue = maxValue;
        this.firePropertyChange("maxValue", oldMaxValue, this.maxValue);
    }

    public boolean unsetMaxValue() {
        if (this.isSetMaxValue()) {
            Double oldMaxValue = this.maxValue;
            this.maxValue = null;
            this.firePropertyChange("maxValue", oldMaxValue, this.maxValue);
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int prime = 1949;
        int hashCode = super.hashCode();
        if (this.isSetSampledValue()) {
            hashCode = (int)((double)hashCode + 1949.0 * this.getSampledValue());
        }
        if (this.isSetMinValue()) {
            hashCode = (int)((double)hashCode + 1949.0 * this.getMinValue());
        }
        if (this.isSetMaxValue()) {
            hashCode = (int)((double)hashCode + 1949.0 * this.getMaxValue());
        }
        if (this.isSetDomainType()) {
            hashCode += 1949 * this.getDomainType().hashCode();
        }
        return hashCode;
    }

    @Override
    public Map<String, String> writeXMLAttributes() {
        Map<String, String> attributes = super.writeXMLAttributes();
        if (this.isSetSampledValue()) {
            attributes.remove("sampledValue");
            attributes.put("spatial:sampledValue", String.valueOf(this.getSampledValue()));
        }
        if (this.isSetMinValue()) {
            attributes.remove("minValue");
            attributes.put("spatial:minValue", String.valueOf(this.getMinValue()));
        }
        if (this.isSetMaxValue()) {
            attributes.remove("maxValue");
            attributes.put("spatial:maxValue", String.valueOf(this.getMaxValue()));
        }
        if (this.isSetDomainType()) {
            attributes.remove("domainType");
            attributes.put("spatial:domainType", this.getDomainType());
        }
        return attributes;
    }

    @Override
    public boolean readAttribute(String attributeName, String prefix, String value) {
        boolean isAttributeRead;
        boolean bl = isAttributeRead = super.readAttribute(attributeName, prefix, value) && "spatial" == prefix;
        if (!isAttributeRead) {
            isAttributeRead = true;
            if (attributeName.equals("domainType")) {
                try {
                    this.setDomainType(value);
                }
                catch (Exception e) {
                    logger.warn((Object)MessageFormat.format(SpatialConstants.bundle.getString("COULD_NOT_READ_ATTRIBUTE"), value, "domainType", this.getElementName()));
                }
            } else if (attributeName.equals("sampledValue")) {
                try {
                    this.setSampledValue(StringTools.parseSBMLDouble((String)value));
                }
                catch (Exception e) {
                    logger.warn((Object)MessageFormat.format(SpatialConstants.bundle.getString("COULD_NOT_READ_ATTRIBUTE"), value, "sampledValue", this.getElementName()));
                }
            } else if (attributeName.equals("minValue")) {
                try {
                    this.setMinValue(StringTools.parseSBMLDouble((String)value));
                }
                catch (Exception e) {
                    logger.warn((Object)MessageFormat.format(SpatialConstants.bundle.getString("COULD_NOT_READ_ATTRIBUTE"), value, "minValue", this.getElementName()));
                }
            } else if (attributeName.equals("maxValue")) {
                try {
                    this.setMaxValue(StringTools.parseSBMLDouble((String)value));
                }
                catch (Exception e) {
                    logger.warn((Object)MessageFormat.format(SpatialConstants.bundle.getString("COULD_NOT_READ_ATTRIBUTE"), value, "maxValue", this.getElementName()));
                }
            } else {
                isAttributeRead = false;
            }
        }
        return isAttributeRead;
    }
}

