/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.ext.spatial.Boundary;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.InvalidAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;

public class BoundaryConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                if (level < 3) break;
                this.addRangeToSet(set, 1221001, 1221005);
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case MODELING_PRACTICE: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
        }
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func = null;
        switch (errorCode) {
            case 1221001: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 1221002: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 1221003: {
                func = new UnknownPackageAttributeValidationFunction<Boundary>("spatial"){

                    public boolean check(ValidationContext ctx, Boundary bound) {
                        if (!bound.isSetId()) {
                            return false;
                        }
                        if (!bound.isSetValue()) {
                            return false;
                        }
                        return super.check(ctx, (TreeNodeWithChangeSupport)bound);
                    }
                };
                break;
            }
            case 1221004: {
                func = new InvalidAttributeValidationFunction("value");
                break;
            }
            case 1221005: {
                func = new ValidationFunction<Boundary>(){

                    public boolean check(ValidationContext ctx, Boundary bound) {
                        return true;
                    }
                };
            }
        }
        return func;
    }
}

