/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.ext.spatial.DomainType;
import org.sbml.jsbml.ext.spatial.Geometry;
import org.sbml.jsbml.ext.spatial.SpatialModelPlugin;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.InvalidAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;

public class DomainTypeConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                if (level < 3) break;
                this.addRangeToSet(set, 1220701, 1220705);
                this.addRangeToSet(set, 1220750, 1220752);
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case MODELING_PRACTICE: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
        }
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func = null;
        switch (errorCode) {
            case 1220701: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 1220702: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 1220703: {
                func = new UnknownPackageAttributeValidationFunction<DomainType>("spatial"){

                    public boolean check(ValidationContext ctx, DomainType dt) {
                        if (!dt.isSetId()) {
                            return false;
                        }
                        if (!dt.isSetSpatialDimensions()) {
                            return false;
                        }
                        return super.check(ctx, (TreeNodeWithChangeSupport)dt);
                    }
                };
                break;
            }
            case 1220704: {
                func = new InvalidAttributeValidationFunction("spatialDimensions");
                break;
            }
            case 1220705: {
                func = new ValidationFunction<DomainType>(){

                    public boolean check(ValidationContext ctx, DomainType dt) {
                        return true;
                    }
                };
                break;
            }
            case 1220750: {
                func = new ValidationFunction<DomainType>(){

                    public boolean check(ValidationContext ctx, DomainType dt) {
                        Geometry g;
                        int coord_components;
                        SpatialModelPlugin smp = (SpatialModelPlugin)dt.getModel().getPlugin("spatial");
                        if (smp.isSetGeometry() && (coord_components = (g = smp.getGeometry()).getListOfCoordinateComponents().getNumChildren()) == 3) {
                            return dt.getSpatialDimensions() == 2 || dt.getSpatialDimensions() == 3;
                        }
                        return true;
                    }
                };
                break;
            }
            case 1220751: {
                func = new ValidationFunction<DomainType>(){

                    public boolean check(ValidationContext ctx, DomainType dt) {
                        Geometry g;
                        int coord_components;
                        SpatialModelPlugin smp = (SpatialModelPlugin)dt.getModel().getPlugin("spatial");
                        if (smp.isSetGeometry() && (coord_components = (g = smp.getGeometry()).getListOfCoordinateComponents().getNumChildren()) == 2) {
                            return dt.getSpatialDimensions() == 1 || dt.getSpatialDimensions() == 2;
                        }
                        return true;
                    }
                };
                break;
            }
            case 1220752: {
                func = new ValidationFunction<DomainType>(){

                    public boolean check(ValidationContext ctx, DomainType dt) {
                        Geometry g;
                        int coord_components;
                        SpatialModelPlugin smp = (SpatialModelPlugin)dt.getModel().getPlugin("spatial");
                        if (smp.isSetGeometry() && (coord_components = (g = smp.getGeometry()).getListOfCoordinateComponents().getNumChildren()) == 1) {
                            return dt.getSpatialDimensions() == 0 || dt.getSpatialDimensions() == 1;
                        }
                        return true;
                    }
                };
            }
        }
        return func;
    }
}

