/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.ext.spatial.CoordinateComponent;
import org.sbml.jsbml.ext.spatial.CoordinateKind;
import org.sbml.jsbml.ext.spatial.Geometry;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.DuplicatedElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.InvalidAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageElementValidationFunction;

public class GeometryConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                if (level < 3) break;
                this.addRangeToSet(set, 1223701, 1223717);
                this.addRangeToSet(set, 1223750, 1223754);
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case MODELING_PRACTICE: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
        }
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func = null;
        switch (errorCode) {
            case 1223701: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 1223702: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 1223703: {
                func = new UnknownPackageAttributeValidationFunction<Geometry>("spatial"){

                    public boolean check(ValidationContext ctx, Geometry geom) {
                        if (!geom.isSetCoordinateSystem()) {
                            return false;
                        }
                        return super.check(ctx, (TreeNodeWithChangeSupport)geom);
                    }
                };
                break;
            }
            case 1223704: {
                func = new ValidationFunction<Geometry>(){

                    public boolean check(ValidationContext ctx, Geometry geom) {
                        boolean check = true;
                        if (check && geom.isSetListOfCoordinateComponents()) {
                            check &= new DuplicatedElementValidationFunction("listOfCoordinateComponents").check(ctx, (TreeNodeWithChangeSupport)geom);
                        }
                        if (check && geom.isSetListOfDomainTypes()) {
                            check &= new DuplicatedElementValidationFunction("listOfDomainTypes").check(ctx, (TreeNodeWithChangeSupport)geom);
                        }
                        if (check && geom.isSetListOfDomains()) {
                            check &= new DuplicatedElementValidationFunction("listOfDomains").check(ctx, (TreeNodeWithChangeSupport)geom);
                        }
                        if (check && geom.isSetListOfAdjacentDomains()) {
                            check &= new DuplicatedElementValidationFunction("listOfAdjacentDomains").check(ctx, (TreeNodeWithChangeSupport)geom);
                        }
                        if (check && geom.isSetListOfGeometryDefinitions()) {
                            check &= new DuplicatedElementValidationFunction("listOfGeometryDefinitions").check(ctx, (TreeNodeWithChangeSupport)geom);
                        }
                        if (check && geom.isSetListOfSampledFields()) {
                            check &= new DuplicatedElementValidationFunction("listOfSampledFields").check(ctx, (TreeNodeWithChangeSupport)geom);
                        }
                        if (check) {
                            check &= new UnknownPackageElementValidationFunction("spatial").check(ctx, (TreeNodeWithChangeSupport)geom);
                        }
                        return check;
                    }
                };
                break;
            }
            case 1223705: {
                func = new InvalidAttributeValidationFunction("coordinateSystem");
                break;
            }
            case 1223706: {
                func = new ValidationFunction<Geometry>(){

                    public boolean check(ValidationContext ctx, Geometry geom) {
                        if (geom.isSetListOfCoordinateComponents()) {
                            return new UnknownElementValidationFunction().check(ctx, geom.getListOfCoordinateComponents());
                        }
                        return true;
                    }
                };
                break;
            }
            case 1223707: {
                func = new ValidationFunction<Geometry>(){

                    public boolean check(ValidationContext ctx, Geometry geom) {
                        if (geom.isSetListOfDomainTypes()) {
                            return new UnknownElementValidationFunction().check(ctx, geom.getListOfDomainTypes());
                        }
                        return true;
                    }
                };
                break;
            }
            case 1223708: {
                func = new ValidationFunction<Geometry>(){

                    public boolean check(ValidationContext ctx, Geometry geom) {
                        if (geom.isSetListOfDomains()) {
                            return new UnknownElementValidationFunction().check(ctx, geom.getListOfDomains());
                        }
                        return true;
                    }
                };
                break;
            }
            case 1223709: {
                func = new ValidationFunction<Geometry>(){

                    public boolean check(ValidationContext ctx, Geometry geom) {
                        if (geom.isSetListOfAdjacentDomains()) {
                            return new UnknownElementValidationFunction().check(ctx, geom.getListOfAdjacentDomains());
                        }
                        return true;
                    }
                };
                break;
            }
            case 1223710: {
                func = new ValidationFunction<Geometry>(){

                    public boolean check(ValidationContext ctx, Geometry geom) {
                        if (geom.isSetListOfGeometryDefinitions()) {
                            return new UnknownElementValidationFunction().check(ctx, geom.getListOfGeometryDefinitions());
                        }
                        return true;
                    }
                };
                break;
            }
            case 1223711: {
                func = new ValidationFunction<Geometry>(){

                    public boolean check(ValidationContext ctx, Geometry geom) {
                        if (geom.isSetListOfSampledFields()) {
                            return new UnknownElementValidationFunction().check(ctx, geom.getListOfSampledFields());
                        }
                        return true;
                    }
                };
                break;
            }
            case 1223712: {
                func = new ValidationFunction<Geometry>(){

                    public boolean check(ValidationContext ctx, Geometry geom) {
                        if (geom.isSetListOfCoordinateComponents()) {
                            return new UnknownAttributeValidationFunction().check(ctx, geom.getListOfCoordinateComponents());
                        }
                        return true;
                    }
                };
                break;
            }
            case 1223713: {
                func = new ValidationFunction<Geometry>(){

                    public boolean check(ValidationContext ctx, Geometry geom) {
                        if (geom.isSetListOfDomainTypes()) {
                            return new UnknownAttributeValidationFunction().check(ctx, geom.getListOfDomainTypes());
                        }
                        return true;
                    }
                };
                break;
            }
            case 1223714: {
                func = new ValidationFunction<Geometry>(){

                    public boolean check(ValidationContext ctx, Geometry geom) {
                        if (geom.isSetListOfDomains()) {
                            return new UnknownAttributeValidationFunction().check(ctx, geom.getListOfDomains());
                        }
                        return true;
                    }
                };
                break;
            }
            case 1223715: {
                func = new ValidationFunction<Geometry>(){

                    public boolean check(ValidationContext ctx, Geometry geom) {
                        if (geom.isSetListOfAdjacentDomains()) {
                            return new UnknownAttributeValidationFunction().check(ctx, geom.getListOfAdjacentDomains());
                        }
                        return true;
                    }
                };
                break;
            }
            case 1223716: {
                func = new ValidationFunction<Geometry>(){

                    public boolean check(ValidationContext ctx, Geometry geom) {
                        if (geom.isSetListOfGeometryDefinitions()) {
                            return new UnknownAttributeValidationFunction().check(ctx, geom.getListOfGeometryDefinitions());
                        }
                        return true;
                    }
                };
                break;
            }
            case 1223717: {
                func = new ValidationFunction<Geometry>(){

                    public boolean check(ValidationContext ctx, Geometry geom) {
                        if (geom.isSetListOfSampledFields()) {
                            return new UnknownAttributeValidationFunction().check(ctx, geom.getListOfSampledFields());
                        }
                        return true;
                    }
                };
                break;
            }
            case 1223750: {
                func = new ValidationFunction<Geometry>(){

                    public boolean check(ValidationContext ctx, Geometry geom) {
                        return geom.isSetListOfCoordinateComponents();
                    }
                };
                break;
            }
            case 1223751: {
                func = new ValidationFunction<Geometry>(){

                    public boolean check(ValidationContext ctx, Geometry geom) {
                        int child_num;
                        return !geom.isSetListOfCoordinateComponents() || (child_num = geom.getListOfCoordinateComponents().getChildCount()) >= 1 && child_num <= 3;
                    }
                };
                break;
            }
            case 1223752: {
                func = new ValidationFunction<Geometry>(){

                    public boolean check(ValidationContext ctx, Geometry geom) {
                        CoordinateComponent coord;
                        int child_num;
                        return !geom.isSetListOfCoordinateComponents() || (child_num = geom.getListOfCoordinateComponents().getChildCount()) != 1 || (coord = (CoordinateComponent)((Object)geom.getListOfCoordinateComponents().getChildAt(0))).getType() == CoordinateKind.cartesianX;
                    }
                };
                break;
            }
            case 1223753: {
                func = new ValidationFunction<Geometry>(){

                    public boolean check(ValidationContext ctx, Geometry geom) {
                        int child_num;
                        if (geom.isSetListOfCoordinateComponents() && (child_num = geom.getListOfCoordinateComponents().getChildCount()) == 2) {
                            boolean cartX = false;
                            boolean cartY = false;
                            ListOf<CoordinateComponent> locc = geom.getListOfCoordinateComponents();
                            for (CoordinateComponent cc : locc) {
                                if (cc.getType() == CoordinateKind.cartesianX) {
                                    cartX = true;
                                }
                                if (cc.getType() != CoordinateKind.cartesianY) continue;
                                cartY = true;
                            }
                            return cartX && cartY;
                        }
                        return true;
                    }
                };
                break;
            }
            case 1223754: {
                func = new ValidationFunction<Geometry>(){

                    public boolean check(ValidationContext ctx, Geometry geom) {
                        int child_num;
                        if (geom.isSetListOfCoordinateComponents() && (child_num = geom.getListOfCoordinateComponents().getChildCount()) == 3) {
                            boolean cartX = false;
                            boolean cartY = false;
                            boolean cartZ = false;
                            ListOf<CoordinateComponent> locc = geom.getListOfCoordinateComponents();
                            for (CoordinateComponent cc : locc) {
                                if (cc.getType() == CoordinateKind.cartesianX) {
                                    cartX = true;
                                }
                                if (cc.getType() == CoordinateKind.cartesianY) {
                                    cartY = true;
                                }
                                if (cc.getType() != CoordinateKind.cartesianZ) continue;
                                cartZ = true;
                            }
                            return cartX && cartY && cartZ;
                        }
                        return true;
                    }
                };
            }
        }
        return func;
    }
}

