/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.ext.spatial.InteriorPoint;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.InvalidAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;

public class InteriorPointConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                if (level < 3) break;
                this.addRangeToSet(set, 1220901, 0x12A12A);
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case MODELING_PRACTICE: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
        }
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func = null;
        switch (errorCode) {
            case 1220901: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 1220902: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 1220903: {
                func = new UnknownPackageAttributeValidationFunction<InteriorPoint>("spatial"){

                    public boolean check(ValidationContext ctx, InteriorPoint ip) {
                        if (!ip.isSetCoord1()) {
                            return false;
                        }
                        return super.check(ctx, (TreeNodeWithChangeSupport)ip);
                    }
                };
                break;
            }
            case 1220904: {
                func = new InvalidAttributeValidationFunction("coord1");
                break;
            }
            case 1220905: {
                func = new InvalidAttributeValidationFunction("coord2");
                break;
            }
            case 0x12A12A: {
                func = new InvalidAttributeValidationFunction("coord3");
            }
        }
        return func;
    }
}

