/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.ext.spatial.SpatialParameterPlugin;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.DuplicatedElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageElementValidationFunction;

public class SpatialParameterPluginConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                if (level < 3) break;
                set.add(1220501);
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case MODELING_PRACTICE: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
        }
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        ValidationFunction<SpatialParameterPlugin> func = null;
        switch (errorCode) {
            case 1220501: {
                func = new ValidationFunction<SpatialParameterPlugin>(){

                    public boolean check(ValidationContext ctx, SpatialParameterPlugin spatialPM) {
                        boolean onlyOneSSR = new DuplicatedElementValidationFunction("spatialSymbolReference").check(ctx, (TreeNodeWithChangeSupport)spatialPM);
                        boolean onlyOneAC = new DuplicatedElementValidationFunction("advectionCoefficient").check(ctx, (TreeNodeWithChangeSupport)spatialPM);
                        boolean onlyOneBC = new DuplicatedElementValidationFunction("boundaryCondition").check(ctx, (TreeNodeWithChangeSupport)spatialPM);
                        boolean onlyOneDC = new DuplicatedElementValidationFunction("diffusionCoefficient").check(ctx, (TreeNodeWithChangeSupport)spatialPM);
                        boolean noOtherElements = new UnknownPackageElementValidationFunction("spatial").check(ctx, (TreeNodeWithChangeSupport)spatialPM);
                        return onlyOneSSR && onlyOneAC && onlyOneBC && onlyOneDC && noOtherElements;
                    }
                };
            }
        }
        return func;
    }
}

