/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.Reaction;
import org.sbml.jsbml.ext.spatial.SpatialReactionPlugin;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.InvalidAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;

public class SpatialReactionPluginConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                if (level < 3) break;
                this.addRangeToSet(set, 1220601, 1220602);
                set.add(1220650);
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case MODELING_PRACTICE: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
        }
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func = null;
        switch (errorCode) {
            case 1220601: {
                func = new UnknownPackageAttributeValidationFunction<SpatialReactionPlugin>("spatial"){

                    public boolean check(ValidationContext ctx, SpatialReactionPlugin srp) {
                        if (!srp.isSetIsLocal()) {
                            return false;
                        }
                        return super.check(ctx, (TreeNodeWithChangeSupport)srp);
                    }
                };
                break;
            }
            case 1220602: {
                func = new InvalidAttributeValidationFunction("isLocal");
                break;
            }
            case 1220650: {
                func = new ValidationFunction<SpatialReactionPlugin>(){

                    public boolean check(ValidationContext ctx, SpatialReactionPlugin srp) {
                        if (srp.isSetIsLocal()) {
                            if (!srp.getIsLocal()) {
                                return true;
                            }
                            Reaction reaction = srp.getExtendedSBase();
                            if (!reaction.isSetCompartment()) {
                                return false;
                            }
                        }
                        return true;
                    }
                };
            }
        }
        return func;
    }
}

