/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.spatial;

import java.text.MessageFormat;
import java.util.Map;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.PropertyUndefinedError;
import org.sbml.jsbml.SBMLException;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.spatial.AbstractSpatialNamedSBase;
import org.sbml.jsbml.ext.spatial.InteriorPoint;
import org.sbml.jsbml.ext.spatial.SpatialConstants;

public class Domain
extends AbstractSpatialNamedSBase {
    private static final transient Logger logger = Logger.getLogger(Domain.class);
    private static final long serialVersionUID = 7959434109047369076L;
    private String domainType;
    private ListOf<InteriorPoint> listOfInteriorPoints;

    public Domain() {
    }

    public Domain(int level, int version) {
        super(level, version);
    }

    public Domain(String id, int level, int version) {
        super(id, level, version);
    }

    public Domain(Domain dm) {
        super(dm);
        if (dm.isSetListOfInteriorPoints()) {
            this.setListOfInteriorPoints((ListOf<InteriorPoint>)dm.getListOfInteriorPoints().clone());
        }
        if (dm.isSetDomainType()) {
            this.setDomainType(dm.getDomainType());
        }
    }

    @Override
    public Domain clone() {
        return new Domain(this);
    }

    public String getDomainType() {
        if (this.isSetDomainType()) {
            return this.domainType;
        }
        throw new PropertyUndefinedError("domainType", (SBase)this);
    }

    public boolean isSetDomainType() {
        return this.domainType != null;
    }

    public void setDomainType(String domainType) {
        String oldDomainType = this.domainType;
        this.domainType = domainType;
        this.firePropertyChange("domainType", oldDomainType, this.domainType);
    }

    public boolean unsetDomainType() {
        if (this.isSetDomainType()) {
            String oldDomainType = this.domainType;
            this.domainType = null;
            this.firePropertyChange("domainType", oldDomainType, this.domainType);
            return true;
        }
        return false;
    }

    public boolean isSetListOfInteriorPoints() {
        return this.listOfInteriorPoints != null;
    }

    public ListOf<InteriorPoint> getListOfInteriorPoints() {
        if (!this.isSetListOfInteriorPoints()) {
            this.listOfInteriorPoints = new ListOf();
            this.listOfInteriorPoints.setPackageVersion(-1);
            this.listOfInteriorPoints.setPackageName(null);
            this.listOfInteriorPoints.setPackageName("spatial");
            this.listOfInteriorPoints.setSBaseListType(ListOf.Type.other);
            this.registerChild((SBase)this.listOfInteriorPoints);
        }
        return this.listOfInteriorPoints;
    }

    public void setListOfInteriorPoints(ListOf<InteriorPoint> listOfInteriorPoints) {
        this.unsetListOfInteriorPoints();
        this.listOfInteriorPoints = listOfInteriorPoints;
        if (listOfInteriorPoints != null) {
            listOfInteriorPoints.setPackageVersion(-1);
            listOfInteriorPoints.setPackageName(null);
            listOfInteriorPoints.setPackageName("spatial");
            listOfInteriorPoints.setSBaseListType(ListOf.Type.other);
            this.registerChild((SBase)this.listOfInteriorPoints);
        }
    }

    public boolean unsetListOfInteriorPoints() {
        if (this.isSetListOfInteriorPoints()) {
            ListOf<InteriorPoint> oldInteriorPoints = this.listOfInteriorPoints;
            this.listOfInteriorPoints = null;
            oldInteriorPoints.fireNodeRemovedEvent();
            return true;
        }
        return false;
    }

    public boolean addInteriorPoint(InteriorPoint interiorPoint) {
        return this.getListOfInteriorPoints().add((SBase)interiorPoint);
    }

    public boolean removeInteriorPoint(InteriorPoint interiorPoint) {
        if (this.isSetListOfInteriorPoints()) {
            if (this.getListOfInteriorPoints().size() <= 1) {
                return false;
            }
            return this.getListOfInteriorPoints().remove((SBase)interiorPoint);
        }
        return false;
    }

    public void removeInteriorPoint(int i) {
        if (!this.isSetListOfInteriorPoints()) {
            throw new IndexOutOfBoundsException(Integer.toString(i));
        }
        if (this.getListOfInteriorPoints().size() <= 1) {
            throw new SBMLException("There must be at least one InteriorPoint defined for this list");
        }
        this.getListOfInteriorPoints().remove(i);
    }

    public InteriorPoint createInteriorPoint() {
        InteriorPoint interiorPoint = new InteriorPoint(this.getLevel(), this.getVersion());
        this.addInteriorPoint(interiorPoint);
        return interiorPoint;
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public int getChildCount() {
        int count = super.getChildCount();
        if (this.isSetListOfInteriorPoints()) {
            ++count;
        }
        return count;
    }

    @Override
    public TreeNode getChildAt(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException(MessageFormat.format(resourceBundle.getString("IndexSurpassesBoundsException"), index, 0));
        }
        int count = super.getChildCount();
        int pos = 0;
        if (index < count) {
            return super.getChildAt(index);
        }
        index -= count;
        if (this.isSetListOfInteriorPoints()) {
            if (pos == index) {
                return this.getListOfInteriorPoints();
            }
            ++pos;
        }
        throw new IndexOutOfBoundsException(MessageFormat.format(resourceBundle.getString("IndexExceedsBoundsException"), index, Math.min(pos, 0)));
    }

    @Override
    public int hashCode() {
        int prime = 1571;
        int hashCode = super.hashCode();
        if (this.isSetDomainType()) {
            hashCode += 1571 * this.getDomainType().hashCode();
        }
        if (this.isSetListOfInteriorPoints()) {
            hashCode += 1571 * this.getListOfInteriorPoints().hashCode();
        }
        return hashCode;
    }

    @Override
    public Map<String, String> writeXMLAttributes() {
        Map<String, String> attributes = super.writeXMLAttributes();
        if (this.isSetDomainType()) {
            attributes.remove("domainType");
            attributes.put("spatial:domainType", this.getDomainType());
        }
        return attributes;
    }

    public boolean readAttribute(String attributeName, String prefix, String value) {
        boolean isAttributeRead = super.readAttribute(attributeName, prefix, value);
        if (!isAttributeRead) {
            isAttributeRead = true;
            if (attributeName.equals("domainType")) {
                try {
                    this.setDomainType(value);
                }
                catch (Exception e) {
                    logger.warn((Object)MessageFormat.format(SpatialConstants.bundle.getString("COULD_NOT_READ_ATTRIBUTE"), value, "domainType", this.getElementName()));
                }
            } else {
                isAttributeRead = false;
            }
        }
        return isAttributeRead;
    }

    @Override
    public boolean equals(Object object) {
        boolean equal = super.equals(object);
        if (equal) {
            Domain dm = (Domain)object;
            if ((equal &= dm.isSetDomainType() == this.isSetDomainType()) && this.isSetDomainType()) {
                equal &= dm.getDomainType().equals(this.getDomainType());
            }
            if ((equal &= dm.isSetListOfInteriorPoints() == this.isSetListOfInteriorPoints()) && this.isSetListOfInteriorPoints()) {
                equal &= dm.getListOfInteriorPoints().equals(this.getListOfInteriorPoints());
            }
        }
        return equal;
    }
}

