/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.spatial;

import java.text.MessageFormat;
import javax.swing.tree.TreeNode;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.PropertyUndefinedError;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.spatial.GeometryDefinition;
import org.sbml.jsbml.ext.spatial.ParametricObject;
import org.sbml.jsbml.ext.spatial.SpatialPoints;

public class ParametricGeometry
extends GeometryDefinition {
    SpatialPoints spatialPoints;
    ListOf<ParametricObject> listOfParametricObjects;
    private static final long serialVersionUID = 5947368889263003716L;

    public ParametricGeometry() {
    }

    public ParametricGeometry(ParametricGeometry pg) {
        super(pg);
        if (pg.isSetListOfParametricObjects()) {
            this.setListOfParametricObjects((ListOf<ParametricObject>)pg.getListOfParametricObjects().clone());
        }
        if (pg.isSetSpatialPoints()) {
            this.setSpatialPoints(pg.getSpatialPoints().clone());
        }
    }

    public ParametricGeometry(int level, int version) {
        super(level, version);
    }

    public ParametricGeometry(String id, int level, int version) {
        super(id, level, version);
    }

    @Override
    public ParametricGeometry clone() {
        return new ParametricGeometry(this);
    }

    @Override
    public boolean equals(Object object) {
        boolean equal = super.equals(object);
        if (equal) {
            ParametricGeometry pg = (ParametricGeometry)object;
            if ((equal &= pg.isSetListOfParametricObjects() == this.isSetListOfParametricObjects()) && this.isSetListOfParametricObjects()) {
                equal &= pg.getListOfParametricObjects().equals(this.getListOfParametricObjects());
            }
            if ((equal &= pg.isSetSpatialPoints() == this.isSetSpatialPoints()) && this.isSetSpatialPoints()) {
                equal &= pg.getSpatialPoints().equals(this.getSpatialPoints());
            }
        }
        return equal;
    }

    @Override
    public int hashCode() {
        int prime = 1999;
        int hashCode = super.hashCode();
        if (this.isSetListOfParametricObjects()) {
            hashCode += 1999 * this.getListOfParametricObjects().hashCode();
        }
        if (this.isSetSpatialPoints()) {
            hashCode += 1999 * this.getSpatialPoints().hashCode();
        }
        return hashCode;
    }

    public boolean isSetListOfParametricObjects() {
        return this.listOfParametricObjects != null;
    }

    public ListOf<ParametricObject> getListOfParametricObjects() {
        if (!this.isSetListOfParametricObjects()) {
            this.listOfParametricObjects = new ListOf(this.getLevel(), this.getVersion());
            this.listOfParametricObjects.setNamespace("http://www.sbml.org/sbml/level3/version1/spatial/version1");
            this.listOfParametricObjects.setSBaseListType(ListOf.Type.other);
            this.registerChild((SBase)this.listOfParametricObjects);
        }
        return this.listOfParametricObjects;
    }

    public void setListOfParametricObjects(ListOf<ParametricObject> listOfParametricObjects) {
        this.unsetListOfParametricObjects();
        this.listOfParametricObjects = listOfParametricObjects;
        this.registerChild((SBase)this.listOfParametricObjects);
    }

    public boolean unsetListOfParametricObjects() {
        if (this.isSetListOfParametricObjects()) {
            ListOf<ParametricObject> oldParametricObjects = this.listOfParametricObjects;
            this.listOfParametricObjects = null;
            oldParametricObjects.fireNodeRemovedEvent();
            return true;
        }
        return false;
    }

    public boolean addParametricObject(ParametricObject parametricObject) {
        return this.getListOfParametricObjects().add((SBase)parametricObject);
    }

    public boolean removeParametricObject(ParametricObject parametricObject) {
        if (this.isSetListOfParametricObjects()) {
            return this.getListOfParametricObjects().remove((SBase)parametricObject);
        }
        return false;
    }

    public void removeParametricObject(int i) {
        if (!this.isSetListOfParametricObjects()) {
            throw new IndexOutOfBoundsException(Integer.toString(i));
        }
        this.getListOfParametricObjects().remove(i);
    }

    public ParametricObject createParametricObject() {
        return this.createParametricObject(null);
    }

    public ParametricObject createParametricObject(String id) {
        ParametricObject parametricObject = new ParametricObject(id, this.getLevel(), this.getVersion());
        this.addParametricObject(parametricObject);
        return parametricObject;
    }

    public SpatialPoints getSpatialPoints() {
        if (this.isSetSpatialPoints()) {
            return this.spatialPoints;
        }
        throw new PropertyUndefinedError("spatialPoints", (SBase)this);
    }

    public boolean isSetSpatialPoints() {
        return this.spatialPoints != null;
    }

    public void setSpatialPoints(SpatialPoints spatialPoints) {
        SpatialPoints oldSpatialPoints = this.spatialPoints;
        this.spatialPoints = spatialPoints;
        this.registerChild(spatialPoints);
        this.firePropertyChange("spatialPoints", oldSpatialPoints, this.spatialPoints);
    }

    public boolean unsetSpatialPoints() {
        if (this.isSetSpatialPoints()) {
            SpatialPoints oldSpatialPoints = this.spatialPoints;
            this.spatialPoints = null;
            this.firePropertyChange("spatialPoints", oldSpatialPoints, this.spatialPoints);
            return true;
        }
        return false;
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public int getChildCount() {
        int count = super.getChildCount();
        if (this.isSetListOfParametricObjects()) {
            ++count;
        }
        if (this.isSetSpatialPoints()) {
            ++count;
        }
        return count;
    }

    @Override
    public TreeNode getChildAt(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException(MessageFormat.format(resourceBundle.getString("IndexSurpassesBoundsException"), index, 0));
        }
        int count = super.getChildCount();
        int pos = 0;
        if (index < count) {
            return super.getChildAt(index);
        }
        index -= count;
        if (this.isSetListOfParametricObjects()) {
            if (pos == index) {
                return this.getListOfParametricObjects();
            }
            ++pos;
        }
        if (this.isSetSpatialPoints()) {
            if (pos == index) {
                return this.getSpatialPoints();
            }
            ++pos;
        }
        throw new IndexOutOfBoundsException(MessageFormat.format(resourceBundle.getString("IndexExceedsBoundsException"), index, Math.min(pos, 0)));
    }
}

