/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.ext.spatial.AnalyticVolume;
import org.sbml.jsbml.ext.spatial.DomainType;
import org.sbml.jsbml.ext.spatial.SpatialModelPlugin;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.DuplicatedMathValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.InvalidAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;

public class AnalyticVolumeConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                if (level < 3) break;
                this.addRangeToSet(set, 1221901, 1221908);
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case MODELING_PRACTICE: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
        }
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func = null;
        switch (errorCode) {
            case 1221901: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 1221902: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 1221903: {
                func = new UnknownPackageAttributeValidationFunction<AnalyticVolume>("spatial"){

                    public boolean check(ValidationContext ctx, AnalyticVolume av) {
                        if (!av.isSetId()) {
                            return false;
                        }
                        if (!av.isSetFunctionType()) {
                            return false;
                        }
                        if (!av.isSetDomainType()) {
                            return false;
                        }
                        return super.check(ctx, (TreeNodeWithChangeSupport)av);
                    }
                };
                break;
            }
            case 1221904: {
                func = new DuplicatedMathValidationFunction(true);
                break;
            }
            case 1221905: {
                func = new InvalidAttributeValidationFunction("functionType");
                break;
            }
            case 1221906: {
                func = new ValidationFunction<AnalyticVolume>(){

                    public boolean check(ValidationContext ctx, AnalyticVolume av) {
                        DomainType dom;
                        SpatialModelPlugin smp;
                        return !av.isSetDomainType() || !(smp = (SpatialModelPlugin)av.getModel().getPlugin("spatial")).isSetGeometry() || (dom = smp.getGeometry().getDomainType(av.getDomainType())) != null;
                    }
                };
                break;
            }
            case 1221907: {
                func = new ValidationFunction<AnalyticVolume>(){

                    public boolean check(ValidationContext ctx, AnalyticVolume av) {
                        return true;
                    }
                };
                break;
            }
            case 1221908: {
                func = new InvalidAttributeValidationFunction("ordinal");
            }
        }
        return func;
    }
}

