/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.HashSet;
import java.util.Set;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.ext.spatial.CSGObject;
import org.sbml.jsbml.ext.spatial.CSGeometry;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.DuplicatedElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageElementValidationFunction;

public class CSGeometryConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                if (level < 3) break;
                this.addRangeToSet(set, 1222201, 1222205);
                set.add(1222350);
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case MODELING_PRACTICE: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
        }
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func = null;
        switch (errorCode) {
            case 1222201: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 1222202: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 1222203: {
                func = new ValidationFunction<CSGeometry>(){

                    public boolean check(ValidationContext ctx, CSGeometry csg) {
                        return new DuplicatedElementValidationFunction("listOfCSGObjects").check(ctx, (TreeNodeWithChangeSupport)csg) && new UnknownPackageElementValidationFunction("spatial").check(ctx, (TreeNodeWithChangeSupport)csg);
                    }
                };
                break;
            }
            case 1222204: {
                func = new ValidationFunction<CSGeometry>(){

                    public boolean check(ValidationContext ctx, CSGeometry csg) {
                        if (csg.isSetListOfCSGObjects()) {
                            return new UnknownElementValidationFunction().check(ctx, csg.getListOfCSGObjects());
                        }
                        return true;
                    }
                };
                break;
            }
            case 1222205: {
                func = new ValidationFunction<CSGeometry>(){

                    public boolean check(ValidationContext ctx, CSGeometry csg) {
                        if (csg.isSetListOfCSGObjects()) {
                            return new UnknownAttributeValidationFunction().check(ctx, csg.getListOfCSGObjects());
                        }
                        return true;
                    }
                };
                break;
            }
            case 1222350: {
                func = new ValidationFunction<CSGeometry>(){

                    public boolean check(ValidationContext ctx, CSGeometry csg) {
                        if (csg.isSetListOfCSGObjects()) {
                            HashSet<Integer> ordinals = new HashSet<Integer>();
                            ListOf<CSGObject> locsgo = csg.getListOfCSGObjects();
                            for (CSGObject csgo : locsgo) {
                                if (!ordinals.isEmpty() && ordinals.contains(csgo.getOrdinal())) {
                                    return false;
                                }
                                ordinals.add(csgo.getOrdinal());
                            }
                        }
                        return true;
                    }
                };
            }
        }
        return func;
    }
}

