/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.ext.spatial.ParametricGeometry;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.DuplicatedElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageElementValidationFunction;

public class ParametricGeometryConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                if (level < 3) break;
                this.addRangeToSet(set, 1222001, 1222005);
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case MODELING_PRACTICE: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
        }
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func = null;
        switch (errorCode) {
            case 1222001: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 1222002: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 1222003: {
                func = new ValidationFunction<ParametricGeometry>(){

                    public boolean check(ValidationContext ctx, ParametricGeometry pg) {
                        return new DuplicatedElementValidationFunction("spatialPoints").check(ctx, (TreeNodeWithChangeSupport)pg) && new DuplicatedElementValidationFunction("listOfParametricObjects").check(ctx, (TreeNodeWithChangeSupport)pg) && new UnknownPackageElementValidationFunction("spatial").check(ctx, (TreeNodeWithChangeSupport)pg);
                    }
                };
                break;
            }
            case 1222004: {
                func = new ValidationFunction<ParametricGeometry>(){

                    public boolean check(ValidationContext ctx, ParametricGeometry pg) {
                        if (pg.isSetListOfParametricObjects()) {
                            return new UnknownElementValidationFunction().check(ctx, pg.getListOfParametricObjects());
                        }
                        return true;
                    }
                };
                break;
            }
            case 1222005: {
                func = new ValidationFunction<ParametricGeometry>(){

                    public boolean check(ValidationContext ctx, ParametricGeometry pg) {
                        if (pg.isSetListOfParametricObjects()) {
                            return new UnknownAttributeValidationFunction().check(ctx, pg.getListOfParametricObjects());
                        }
                        return true;
                    }
                };
            }
        }
        return func;
    }
}

