/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.ext.spatial.Geometry;
import org.sbml.jsbml.ext.spatial.SampledVolume;
import org.sbml.jsbml.ext.spatial.SpatialModelPlugin;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.InvalidAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;

public class SampledVolumeConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                if (level < 3) break;
                this.addRangeToSet(set, 1221701, 1221708);
                this.addRangeToSet(set, 1221750, 1221751);
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case MODELING_PRACTICE: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
        }
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func = null;
        switch (errorCode) {
            case 1221701: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 1221702: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 1221703: {
                func = new UnknownPackageAttributeValidationFunction<SampledVolume>("spatial"){

                    public boolean check(ValidationContext ctx, SampledVolume sv) {
                        if (!sv.isSetId()) {
                            return false;
                        }
                        if (!sv.isSetDomainType()) {
                            return false;
                        }
                        return super.check(ctx, (TreeNodeWithChangeSupport)sv);
                    }
                };
                break;
            }
            case 1221704: {
                func = new ValidationFunction<SampledVolume>(){

                    public boolean check(ValidationContext ctx, SampledVolume sv) {
                        Geometry g;
                        SpatialModelPlugin smp;
                        return !sv.isSetDomainType() || !(smp = (SpatialModelPlugin)sv.getModel().getPlugin("spatial")).isSetGeometry() || (g = smp.getGeometry()).getDomainType(sv.getDomainType()) != null;
                    }
                };
                break;
            }
            case 1221705: {
                break;
            }
            case 1221706: {
                func = new InvalidAttributeValidationFunction("sampledValue");
                break;
            }
            case 1221707: {
                func = new InvalidAttributeValidationFunction("minValue");
                break;
            }
            case 1221708: {
                func = new InvalidAttributeValidationFunction("maxValue");
                break;
            }
            case 1221750: {
                func = new ValidationFunction<SampledVolume>(){

                    public boolean check(ValidationContext ctx, SampledVolume sv) {
                        if (!(sv.isSetSampledValue() || sv.isSetMinValue() && sv.isSetMaxValue())) {
                            return false;
                        }
                        if (sv.isSetSampledValue()) {
                            return !sv.isSetMinValue() && !sv.isSetMaxValue();
                        }
                        return true;
                    }
                };
                break;
            }
            case 1221751: {
                func = new ValidationFunction<SampledVolume>(){

                    public boolean check(ValidationContext ctx, SampledVolume sv) {
                        return !sv.isSetMaxValue() || !sv.isSetMinValue() || !(sv.getMinValue() > sv.getMaxValue());
                    }
                };
            }
        }
        return func;
    }
}

