/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import java.util.StringTokenizer;
import org.sbml.jsbml.ext.spatial.SpatialPoints;
import org.sbml.jsbml.util.StringTools;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.InvalidAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;

public class SpatialPointsConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                if (level < 3) break;
                this.addRangeToSet(set, 1224001, 1224008);
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case MODELING_PRACTICE: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
        }
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func = null;
        switch (errorCode) {
            case 1224001: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 1224002: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 1224003: {
                func = new UnknownPackageAttributeValidationFunction<SpatialPoints>("spatial"){

                    public boolean check(ValidationContext ctx, SpatialPoints sp) {
                        if (!sp.isSetCompression()) {
                            return false;
                        }
                        if (!sp.isSetArrayData()) {
                            return false;
                        }
                        if (!sp.isSetArrayDataLength()) {
                            return false;
                        }
                        return super.check(ctx, (TreeNodeWithChangeSupport)sp);
                    }
                };
                break;
            }
            case 1224004: {
                func = new InvalidAttributeValidationFunction("compression");
                break;
            }
            case 1224005: {
                func = new ValidationFunction<SpatialPoints>(){

                    public boolean check(ValidationContext ctx, SpatialPoints sp) {
                        if (sp.isSetArrayData()) {
                            String arrayData = sp.getArrayData().trim();
                            StringTokenizer test = new StringTokenizer(arrayData, " ;");
                            while (test.hasMoreTokens()) {
                                try {
                                    StringTools.parseSBMLDoubleStrict((String)test.nextToken());
                                }
                                catch (Exception e) {
                                    return false;
                                }
                            }
                            return true;
                        }
                        return true;
                    }
                };
                break;
            }
            case 1224006: {
                func = new InvalidAttributeValidationFunction("arrayDataLength");
                break;
            }
            case 1224007: {
                func = new ValidationFunction<SpatialPoints>(){

                    public boolean check(ValidationContext ctx, SpatialPoints sp) {
                        return true;
                    }
                };
                break;
            }
            case 1224008: {
                func = new InvalidAttributeValidationFunction("dataType");
            }
        }
        return func;
    }
}

