/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.io;

import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Builder;
import scala.io.Codec$;
import scala.io.Source$;
import scala.meta.internal.io.InputStreamIO$;
import scala.meta.internal.io.ListFiles;
import scala.meta.io.AbsolutePath;
import scala.meta.io.AbsolutePath$;
import scala.meta.io.RelativePath;
import scala.meta.io.RelativePath$;

public final class PlatformFileIO$ {
    public static final PlatformFileIO$ MODULE$;

    static {
        new PlatformFileIO$();
    }

    public byte[] readAllBytes(URI uri) {
        return InputStreamIO$.MODULE$.readBytes(uri.toURL().openStream());
    }

    public byte[] readAllBytes(AbsolutePath path) {
        return Files.readAllBytes(path.toNIO());
    }

    public String slurp(AbsolutePath path, Charset charset) {
        return Source$.MODULE$.fromFile(path.toFile(), Codec$.MODULE$.apply(charset)).mkString();
    }

    public ListFiles listFiles(AbsolutePath path) {
        return new ListFiles(path, (Seq<RelativePath>)((Seq)((List)Option$.MODULE$.apply((Object)path.toFile().list()).toList().flatten((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ArrayOps<String> apply(String[] xs) {
                return Predef$.MODULE$.refArrayOps((Object[])xs);
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final RelativePath apply(String path) {
                return RelativePath$.MODULE$.apply(path);
            }
        }, List$.MODULE$.canBuildFrom())));
    }

    public boolean isFile(AbsolutePath path) {
        return path.toFile().isFile();
    }

    public boolean isDirectory(AbsolutePath path) {
        return path.toFile().isDirectory();
    }

    public ListFiles listAllFilesRecursively(AbsolutePath root) {
        Builder builder = List$.MODULE$.newBuilder();
        Files.walkFileTree(root.toNIO(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(root, builder){
            private final AbsolutePath root$1;
            private final Builder builder$1;

            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                AbsolutePath abspath = AbsolutePath$.MODULE$.apply(file.toAbsolutePath());
                this.builder$1.$plus$eq((Object)abspath.toRelative(this.root$1));
                return FileVisitResult.CONTINUE;
            }
            {
                this.root$1 = root$1;
                this.builder$1 = builder$1;
            }
        });
        return new ListFiles(root, (Seq<RelativePath>)((Seq)builder.result()));
    }

    private PlatformFileIO$() {
        MODULE$ = this;
    }
}

