/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths$;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Builder;
import scala.meta.internal.io.JSIO$;
import scala.meta.internal.io.ListFiles;
import scala.meta.internal.semanticdb3.Index;
import scala.meta.internal.semanticdb3.Index$;
import scala.meta.internal.semanticdb3.TextDocument;
import scala.meta.internal.semanticdb3.TextDocuments;
import scala.meta.internal.semanticdb3.TextDocuments$;
import scala.meta.io.AbsolutePath;
import scala.meta.io.AbsolutePath$;
import scala.meta.io.RelativePath;
import scala.meta.io.RelativePath$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.scalajs.js.Array;
import scala.scalajs.js.JSConverters;
import scala.scalajs.js.JSConverters$;
import scalapb.GeneratedMessage;

public final class PlatformFileIO$ {
    public static final PlatformFileIO$ MODULE$;

    static {
        new PlatformFileIO$();
    }

    public InputStream newInputStream(URI uri) {
        return new ByteArrayInputStream(this.readAllBytes(uri));
    }

    public byte[] readAllBytes(URI uri) {
        String string = uri.getScheme();
        String string2 = "file";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            Path filepath = Paths$.MODULE$.get(uri);
            return this.readAllBytes(AbsolutePath$.MODULE$.apply(filepath.toString(), AbsolutePath$.MODULE$.workingDirectory()));
        }
        throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Can't read ", " as InputStream"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{uri})));
    }

    public byte[] readAllBytes(AbsolutePath path) {
        return (byte[])JSIO$.MODULE$.inNode(new Serializable(path){
            public static final long serialVersionUID = 0L;
            private final AbsolutePath path$1;

            /*
             * WARNING - void declaration
             */
            public final byte[] apply() {
                void var3_3;
                Array<Object> jsArray = JSIO$.MODULE$.fs().readFileSync(this.path$1.toString());
                int len = jsArray.length();
                byte[] result = new byte[len];
                for (int curr = 0; curr < len; ++curr) {
                    result[curr] = (byte)BoxesRunTime.unboxToInt((Object)jsArray.apply(curr));
                }
                return var3_3;
            }
            {
                this.path$1 = path$1;
            }
        });
    }

    public Seq<TextDocument> readAllDocuments(AbsolutePath path) {
        return (Seq)JSIO$.MODULE$.inNode(new Serializable(path){
            public static final long serialVersionUID = 0L;
            private final AbsolutePath path$2;

            public final Seq<TextDocument> apply() {
                byte[] bytes = PlatformFileIO$.MODULE$.readAllBytes(this.path$2);
                return ((TextDocuments)TextDocuments$.MODULE$.parseFrom(bytes)).documents();
            }
            {
                this.path$2 = path$2;
            }
        });
    }

    public Index readIndex(AbsolutePath path) {
        return (Index)JSIO$.MODULE$.inNode(new Serializable(path){
            public static final long serialVersionUID = 0L;
            private final AbsolutePath path$3;

            public final Index apply() {
                byte[] bytes = PlatformFileIO$.MODULE$.readAllBytes(this.path$3);
                return (Index)Index$.MODULE$.parseFrom(bytes);
            }
            {
                this.path$3 = path$3;
            }
        });
    }

    public void write(AbsolutePath path, GeneratedMessage proto) {
        JSIO$.MODULE$.inNode(new Serializable(path, proto){
            public static final long serialVersionUID = 0L;
            private final AbsolutePath path$4;
            private final GeneratedMessage proto$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                JSIO$.MODULE$.fs().mkdirSync(this.path$4.toNIO().getParent().toString());
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                this.proto$1.writeTo((OutputStream)os);
                Array buffer = JSConverters.JSRichGenTraversableOnce$.MODULE$.toJSArray$extension(JSConverters$.MODULE$.array2JSRichGenTrav(Predef$.MODULE$.byteArrayOps(os.toByteArray()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(byte x$1) {
                        return x$1;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))));
                JSIO$.MODULE$.fs().writeFileSync(this.path$4.toString(), (Array<Object>)buffer);
            }
            {
                this.path$4 = path$4;
                this.proto$1 = proto$1;
            }
        });
    }

    public String slurp(AbsolutePath path, Charset charset) {
        return (String)JSIO$.MODULE$.inNode(new Serializable(path, charset){
            public static final long serialVersionUID = 0L;
            private final AbsolutePath path$5;
            private final Charset charset$1;

            public final String apply() {
                return JSIO$.MODULE$.fs().readFileSync(this.path$5.toString(), this.charset$1.toString());
            }
            {
                this.path$5 = path$5;
                this.charset$1 = charset$1;
            }
        });
    }

    public ListFiles listFiles(AbsolutePath path) {
        return (ListFiles)JSIO$.MODULE$.inNode(new Serializable(path){
            public static final long serialVersionUID = 0L;
            private final AbsolutePath path$6;

            public final ListFiles apply() {
                ListFiles listFiles2;
                if (this.path$6.isFile()) {
                    listFiles2 = new ListFiles(this.path$6, (List<RelativePath>)Nil$.MODULE$);
                } else {
                    Array<String> jsArray = JSIO$.MODULE$.fs().readdirSync(this.path$6.toString());
                    Builder builder = List$.MODULE$.newBuilder();
                    builder.sizeHint(jsArray.length());
                    for (int curr = 0; curr < jsArray.length(); ++curr) {
                        builder.$plus$eq((Object)RelativePath$.MODULE$.apply((String)jsArray.apply(curr)));
                    }
                    listFiles2 = new ListFiles(this.path$6, (List<RelativePath>)((List)builder.result()));
                }
                return listFiles2;
            }
            {
                this.path$6 = path$6;
            }
        });
    }

    public boolean isFile(AbsolutePath path) {
        return JSIO$.MODULE$.isFile(path.toString());
    }

    public boolean isDirectory(AbsolutePath path) {
        return JSIO$.MODULE$.isDirectory(path.toString());
    }

    public ListFiles listAllFilesRecursively(AbsolutePath root) {
        Builder builder = List$.MODULE$.newBuilder();
        this.scala$meta$internal$io$PlatformFileIO$$loop$1(root, root, builder);
        return new ListFiles(root, (List<RelativePath>)((List)builder.result()));
    }

    public AbsolutePath jarRootPath(AbsolutePath jarFile) {
        throw new UnsupportedOperationException("Can't expand jar file in Scala.js");
    }

    public final void scala$meta$internal$io$PlatformFileIO$$loop$1(AbsolutePath path, AbsolutePath root$1, Builder builder$1) {
        if (path.isDirectory()) {
            this.listFiles(path).foreach(new Serializable(root$1, builder$1){
                public static final long serialVersionUID = 0L;
                private final AbsolutePath root$1;
                private final Builder builder$1;

                public final void apply(AbsolutePath path) {
                    PlatformFileIO$.MODULE$.scala$meta$internal$io$PlatformFileIO$$loop$1(path, this.root$1, this.builder$1);
                }
                {
                    this.root$1 = root$1;
                    this.builder$1 = builder$1;
                }
            });
        } else {
            builder$1.$plus$eq((Object)path.toRelative(root$1));
        }
    }

    private PlatformFileIO$() {
        MODULE$ = this;
    }
}

