/*
 * Decompiled with CFR 0.152.
 */
package org.langmeta.internal.io;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.langmeta.internal.io.InputStreamIO$;
import org.langmeta.internal.io.ListFiles;
import org.langmeta.io.AbsolutePath;
import org.langmeta.io.AbsolutePath$;
import org.langmeta.io.RelativePath;
import org.langmeta.io.RelativePath$;
import scala.Function1;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.io.Source$;
import scala.meta.internal.semanticdb3.TextDocument;
import scala.meta.internal.semanticdb3.TextDocuments;
import scala.meta.internal.semanticdb3.TextDocuments$;
import scalapb.GeneratedMessage;

public final class PlatformFileIO$ {
    public static final PlatformFileIO$ MODULE$;

    static {
        new PlatformFileIO$();
    }

    /*
     * WARNING - void declaration
     */
    public byte[] readAllBytes(URI uri) {
        byte[] byArray;
        InputStream is = uri.toURL().openStream();
        try {
            byArray = InputStreamIO$.MODULE$.readBytes(is);
        }
        catch (Throwable throwable) {
            void var2_2;
            var2_2.close();
            throw throwable;
        }
        is.close();
        return byArray;
    }

    public byte[] readAllBytes(AbsolutePath path) {
        return Files.readAllBytes(path.toNIO());
    }

    /*
     * WARNING - void declaration
     */
    public Seq<TextDocument> readAllDocuments(AbsolutePath path) {
        Seq seq;
        InputStream stream = Files.newInputStream(path.toNIO(), new OpenOption[0]);
        try {
            seq = ((TextDocuments)TextDocuments$.MODULE$.parseFrom(stream)).documents();
        }
        catch (Throwable throwable) {
            void var2_2;
            var2_2.close();
            throw throwable;
        }
        stream.close();
        return seq;
    }

    /*
     * WARNING - void declaration
     */
    public void write(AbsolutePath path, GeneratedMessage proto) {
        path.toFile().getParentFile().mkdirs();
        OutputStream os = Files.newOutputStream(path.toNIO(), new OpenOption[0]);
        try {
            proto.writeTo(os);
        }
        catch (Throwable throwable) {
            void var3_3;
            var3_3.close();
            throw throwable;
        }
        os.close();
    }

    public String slurp(AbsolutePath path, Charset charset) {
        return Source$.MODULE$.fromFile(path.toFile(), Codec$.MODULE$.apply(charset)).mkString();
    }

    public ListFiles listFiles(AbsolutePath path) {
        return new ListFiles(path, (List<RelativePath>)((List)((List)Option$.MODULE$.apply((Object)path.toFile().list()).toList().flatten((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ArrayOps<String> apply(String[] xs) {
                return Predef$.MODULE$.refArrayOps((Object[])xs);
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final RelativePath apply(String path) {
                return RelativePath$.MODULE$.apply(path);
            }
        }, List$.MODULE$.canBuildFrom())));
    }

    public boolean isFile(AbsolutePath path) {
        return Files.isRegularFile(path.toNIO(), new LinkOption[0]);
    }

    public boolean isDirectory(AbsolutePath path) {
        return Files.isDirectory(path.toNIO(), new LinkOption[0]);
    }

    public ListFiles listAllFilesRecursively(AbsolutePath root) {
        Buffer relativeFiles = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(Files.walk(root.toNIO(), new FileVisitOption[0]).collect(Collectors.toList())).asScala()).collect((PartialFunction)new Serializable(root){
            public static final long serialVersionUID = 0L;
            private final AbsolutePath root$1;

            public final <A1 extends Path, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = Files.isRegularFile(A1, new LinkOption[0]) ? RelativePath$.MODULE$.apply(this.root$1.toNIO().relativize(A1)) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Path x1) {
                Path path = x1;
                boolean bl = Files.isRegularFile(path, new LinkOption[0]);
                return bl;
            }
            {
                this.root$1 = root$1;
            }
        }, Buffer$.MODULE$.canBuildFrom());
        return new ListFiles(root, (List<RelativePath>)relativeFiles.toList());
    }

    public AbsolutePath jarRootPath(AbsolutePath jarFile) {
        URI uri = URI.create(new StringBuilder().append((Object)"jar:file:").append((Object)jarFile.toNIO().toUri().getPath()).toString());
        Path roo = this.newFileSystem(uri, new HashMap<String, Object>()).getPath("/", new String[0]);
        return AbsolutePath$.MODULE$.apply(roo, AbsolutePath$.MODULE$.workingDirectory());
    }

    private FileSystem newFileSystem(URI uri, Map<String, Object> map) {
        FileSystem fileSystem;
        try {
            fileSystem = FileSystems.newFileSystem(uri, map);
        }
        catch (FileSystemAlreadyExistsException fileSystemAlreadyExistsException) {
            fileSystem = FileSystems.getFileSystem(uri);
        }
        return fileSystem;
    }

    private PlatformFileIO$() {
        MODULE$ = this;
    }
}

